%  MATLAB scipt cocotst1.m
%  for testing out colormap ideas in the cornea study
%

disp('Running cocotst1.m, to test colors') ;

itest = 13 ;   %  1,...,13
                    %  CAREFUL,  4,5,6 are not very interesting.

if itest == 1 ;
  plot(hsv) ;
    title('1st Plot of the intensities for the default color map (64)') ;

elseif itest == 2 ;
  rgbplot(hsv) ;
    title('RGB Plot of the intensities for the default color map (64)') ;

elseif itest == 3 ;
  colormap(hsv(16)) ;
  pcolor([1:17; 1:17]') ;  
    title('Bar chart of color for the default color map (64)') ;

elseif itest == 4 ;
  plot(gray) ;
    title('1st Plot of the intensities for the gray color map (64)') ;

elseif itest == 5 ;
  rgbplot(gray) ;
    title('RGB Plot of the intensities for the gray color map (64)') ;

elseif itest == 6 ;
  colormap(gray(16)) ;
  pcolor([1:17; 1:17]') ;  
    title('Bar chart of color for the default color map (64)') ;

elseif itest == 7 ;
  plot(hot) ;
    title('1st Plot of the intensities for the hot color map (64)') ;

elseif itest == 8 ;
  rgbplot(hot) ;
    title('RGB Plot of the intensities for the hot color map (64)') ;

elseif itest == 9 ;
  colormap(hot(16)) ;
  pcolor([1:17; 1:17]') ;  
    title('Bar chart of color for the default color map (64)') ;

end ;


if itest >= 10 ;
  %  These use the "full range" Keratron data, from the email message:
  %             cocolora.msg
  %   which were copied into the ASCII file 
  %             cocolor1.dat
  %  for importing into matlab programs
  %    locurve & hicurve are upper and lower ends of the "range"
  %    for each color
  load cornea\cocolor1.dat ;
  locurve = cocolor1(:,1) ;
  hicurve = cocolor1(:,2) ;
  cyan = cocolor1(:,3) ;
  magenta = cocolor1(:,4) ;
  yellow = cocolor1(:,5) ;
  black = cocolor1(:,6) ;

  red   = 1 - cyan - black ;
  green = 1 - magenta - black;
  blue  = 1 - yellow - black ;

  comap = [red green blue] ;
  ncomap = size(comap,1) ;
          %  number of rows in the color map ;

  %  make sure values are positive
  flag = comap < 0 ;
  fflag = find(flag) ;
  comap(fflag) = zeros(length(fflag),1) ;

  %  make sure values are less than 1
  flag = comap > 1 ;
  fflag = find(flag) ;
  comap(fflag) = ones(length(fflag),1) ;

  if itest == 10 ;
    plot(comap) ;
      title('1st Plot of the intensities for the Keratron color map') ;

  elseif itest == 11 ;
    rgbplot(comap) ;
      title('RGB Plot of the intensities for the Keratron color map') ;

  elseif itest == 12 ;
    colormap(comap) ;
    pcolor([1:ncomap+1; 1:ncomap+1]') ;  
      title('Bar chart of color for the Keratron color map') ;

  elseif itest == 13 ;

    colormap(comap) ;
      u01 = linspace(0,1,ncomap+1) ;

    subplot(5,1,1) ;
        xm = 5:.5:25 ;
        xm = [xm; xm] ;
        ym = [zeros(1,size(xm,2)); ones(1,size(xm,2))] ;
      colcurv = interp1([0; hicurve], u01, xm(:)) ;
          %  use this to determine vector of colors representing
          %  curvature, when plotting.  This transforms curvature 
          %  to get Keratron colors, when using comap as colormap.
          %  NOTE: interp1 seems to need vector argument
    pcolor(xm,ym,reshape(colcurv,size(xm))) ;  
          %  reshape to get back to matric argument
      caxis([0,1]) ;  
          %  min and max colors for u01 color spacing
      title('Check of Keratron color bin edges') ;


    subplot(5,1,2) ;
        xm = 25:.5:45 ;
        xm = [xm; xm] ;
        ym = [zeros(1,size(xm,2)); ones(1,size(xm,2))] ;
      colcurv = interp1([0; hicurve], u01, xm(:)) ;
          %  use this to determine vector of colors representing
          %  curvature, when plotting.  This transforms curvature 
          %  to get Keratron colors, when using comap as colormap.
          %  NOTE: interp1 seems to need vector argument
    pcolor(xm,ym,reshape(colcurv,size(xm))) ;  
          %  reshape to get back to matric argument
      caxis([0,1]) ;  
          %  min and max colors for u01 color spacing


    subplot(5,1,3) ;
        xm = 45:.5:65 ;
        xm = [xm; xm] ;
        ym = [zeros(1,size(xm,2)); ones(1,size(xm,2))] ;
      colcurv = interp1([0; hicurve], u01, xm(:)) ;
          %  use this to determine vector of colors representing
          %  curvature, when plotting.  This transforms curvature 
          %  to get Keratron colors, when using comap as colormap.
          %  NOTE: interp1 seems to need vector argument
    pcolor(xm,ym,reshape(colcurv,size(xm))) ;  
          %  reshape to get back to matric argument
      caxis([0,1]) ;  
          %  min and max colors for u01 color spacing


    subplot(5,1,4) ;
        xm = 65:.5:85 ;
        xm = [xm; xm] ;
        ym = [zeros(1,size(xm,2)); ones(1,size(xm,2))] ;
      colcurv = interp1([0; hicurve], u01, xm(:)) ;
          %  use this to determine vector of colors representing
          %  curvature, when plotting.  This transforms curvature 
          %  to get Keratron colors, when using comap as colormap.
          %  NOTE: interp1 seems to need vector argument
    pcolor(xm,ym,reshape(colcurv,size(xm))) ;  
          %  reshape to get back to matric argument
      caxis([0,1]) ;  
          %  min and max colors for u01 color spacing


    subplot(5,1,5) ;
        xm = 85:.5:105 ;
        xm = [xm; xm] ;
        ym = [zeros(1,size(xm,2)); ones(1,size(xm,2))] ;
      colcurv = interp1([0; hicurve], u01, xm(:)) ;
          %  use this to determine vector of colors representing
          %  curvature, when plotting.  This transforms curvature 
          %  to get Keratron colors, when using comap as colormap.
          %  NOTE: interp1 seems to need vector argument
    pcolor(xm,ym,reshape(colcurv,size(xm))) ;  
          %  reshape to get back to matric argument
      caxis([0,1]) ;  
          %  min and max colors for u01 color spacing
    

  end ;

end ;



