disp('MATLAB Script File: cofmtst1.m') ;
%
%   For the Cornea Study, this does tests of input feature matrices
%   and their conversions
%
format compact ;

itest = 3 ;   %  1,2,3

if itest == 1 ;   %  then look at individual images as in corecon6.m

  fmistr = 'fm420841.mat' ;
  fmistr = 'fm420592.mat' ;

  ['load \matlab\steve\cornea\fm\' fmistr]
  eval(['load \matlab\steve\cornea\fm\' fmistr]) ;

  fm ;    %  19 x 7

  disp('Now load printout from .dat file') ;
  load a42p0592.tst ;
          %  Note this file needs to be in the current directory
  tabamp = a42p0592(1:10,:) ;
  tabpha = a42p0592(11:20,:) ;


  %  For comparison, convert c-s to amplitude - phase form
  mamp = abs(fm(1,:)) ;
  mpha = atan2(0,fm(1,:)) * 180 / pi ;
  for i = 1:9 ;
      vamp = sqrt(fm(2*i,:).^2 + fm(2*i+1,:).^2) ;
    mamp = [mamp; vamp] ;
      vpha = atan2(fm(2*i+1,:),fm(2*i,:)) * 180 / pi ;
        vind = find(vpha < 0) ;
      vpha(vind) = vpha(vind) + 360 ;
    mpha = [mpha; vpha] ;
  end ;


  disp('Here is the biggest difference between amplitude fm''s:') ;
  check = max(max(abs(tabamp - mamp))) 

  disp('Here is the biggest difference between phase fm''s:') ;
  check = max(max(abs(tabpha - mpha))) 

  disp('Any Key to Continue with explicit matrices') ;
  pause ;



  disp('Amplitude fm from .dat') ;
  tabamp
  disp('Amplitude fm converted from cos/sin in .mat') ;
  mamp

  disp('Any Key to Continue') ;
  pause ;


  disp('Phase fm from .dat') ;
  tabpha
  disp('Phase fm converted from cos/sin in .mat') ;
  mpha

  disp('Any Key to Continue') ;
  pause ;



  %  For comparison, convert amplitude - phase to c-s form
  mcs = tabamp(1,:) .* cos(tabpha(1,:) * pi / 180) ;
  for i = 2:10 ;
    mcs = [mcs; tabamp(i,:) .* cos(tabpha(i,:) * pi / 180)] ;
    mcs = [mcs; tabamp(i,:) .* sin(tabpha(i,:) * pi / 180)] ;
  end ;

  disp('Here is the biggest difference between fm''s:') ;
  check = max(max(abs(mcs - fm))) 

  disp('Any Key to Continue with explicit matrices') ;
  pause ;


  disp('cos/sin fm converted from amp - pha from .dat') ;
  mcs
  disp('cos/sin fm from .mat') ;
  fm

elseif itest == 2 ;   %  then look at mean 1m0 images as in corecon6.m

  fmistr = 'mn421mo.mat' ;

  ['load \matlab\steve\cornea\fm\' fmistr]
  eval(['load \matlab\steve\cornea\fm\' fmistr]) ;


  disp('Now load printout from .dat file') ;
  load a42p1mo.tst ;
          %  Note this file needs to be in the current directory
  tabamp = a42p1mo(1:10,:) ;
  tabpha = a42p1mo(11:20,:) ;


  disp('Here is the biggest difference between amplitude fm''s:') ;
  check = max(max(abs(tabamp - mnamp))) 

  disp('Here is the biggest difference between phase fm''s:') ;
  check = max(max(abs(tabpha - mnpha))) 

  disp('Any Key to Continue with explicit matrices') ;
  pause ;



  disp('Amplitude fm from .dat') ;
  tabamp
  disp('Amplitude fm converted from cos/sin in .mat') ;
  mnamp

  disp('Any Key to Continue') ;
  pause ;


  disp('Phase fm from .dat') ;
  tabpha
  disp('Phase fm converted from .mat') ;
  mnpha

elseif itest == 3 ;   %  then look at mean Pre images as in corecon6.m

  fmistr = 'mn42pre.mat' ;

  ['load \matlab\steve\cornea\fm\' fmistr]
  eval(['load \matlab\steve\cornea\fm\' fmistr]) ;


  disp('Now load printout from .dat file') ;
  load a42ppre.tst ;
          %  Note this file needs to be in the current directory
  tabamp = a42ppre(1:10,:) ;
  tabpha = a42ppre(11:20,:) ;


  disp('Here is the biggest difference between amplitude fm''s:') ;
  check = max(max(abs(tabamp - mnamp))) 

  disp('Here is the biggest difference between phase fm''s:') ;
  check = max(max(abs(tabpha - mnpha))) 

  disp('Any Key to Continue with explicit matrices') ;
  pause ;



  disp('Amplitude fm from .dat') ;
  tabamp
  disp('Amplitude fm converted from cos/sin in .mat') ;
  mnamp

  disp('Any Key to Continue') ;
  pause ;


  disp('Phase fm from .dat') ;
  tabpha
  disp('Phase fm converted from .mat') ;
  mnpha


end ;
