function coa1pcpp
% COA1PCPP, Does print of Parallel Coordinate Plots for a single population
%      Corneal Topography Analysis System
%   Creates a bacl and white postscript file, of
%   large size window with one page of Par. Coord. Plots
%      Intended to be called by coapam.m
% Outputs:
%     Postscript file in directory ~cornean\outputs

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina




%  Set up global variables
%
global PCP1PHAND LISTFILESTR OUTPUTPATH ;
%  PCP1PHAND - Handle for Parallel Coordinate Plot Window
%  LISTFILESTR - Input list file name
%  OUTPUTPATH - path for output, .ps files, .mpeg files




if isempty(PCP1PHAND) ;
        %  then SPCA window not yet created,
        %  so give error message

  disp('   ') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
  disp('!!!   Can''t print Parellel Coord. plot,') ;
  disp('!!!   Since Analysis not done yet') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

else ;  %  then have done the analysis, so print result

  figure(PCP1PHAND) ;

  orient tall ;
  eval(['print ' OUTPUTPATH LISTFILESTR 'pcp.ps -dps']) ;

  disp('  Finished Creating Postscript file for ') ;
  disp(['    Parallel Coord plot of list file: ' LISTFILESTR]) ;

end ;
