function coa2pcpp
% COA2PCPP, Does print of Parallel Coordinate Plot
%   for 2 populations
%      Corneal Topography Analysis System
%   Creates a color postscript file, of
%   large size window with Parallel Coordinate Plot
%      Intended to be called by coa2pm.m
% Outputs:
%     Postscript file in directory ~cornean\outputs

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina




%  Set up global variables
%
global PCP2PHAND LISTFILESTR1 LISTFILESTR2 PC2STR OUTPUTPATH ;
%  PCP2PHAND - handle for 2 popn Parallel Coord Plot Window
%  LISTFILESTR1 - Input list file name, Population 1
%  LISTFILESTR2 Input list file name, Population 2
%  PC2STR - String with title info for 2 population analyses
%  OUTPUTPATH - path for output, .ps files, .mpeg files




if isempty(PCP2PHAND) ;
        %  then 2 popn Parallel Coordinates window not yet created,
        %  so give error message

  disp('   ') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
  disp('!!!   Can''t print Parallel Coord plot,') ;
  disp('!!!   Since 2 Pop''n Analysis not done yet') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

else ;  %  then have done the analysis, so print result

  figure(PCP2PHAND) ;

  orient tall ;
  eval(['print ' OUTPUTPATH 'pcp' LISTFILESTR1 LISTFILESTR2 '.ps -dpsc']) ;

  disp('  Finished Creating Postscript file for ') ;
  disp(['    2 Pop''n Parallel Coordinates Plot ']) ;
  disp(['    for: ' LISTFILESTR1 LISTFILESTR2]) ;


end ;
