function coa2ppcp
% COA2PPCP, Does Parallel Coordinate Plots from Analyses for 2 Populations
%      Corneal Topography Analysis System
%   Creates a large size window with:
%          1.  Parallel coordinate plots, in raw units
%          2.  Parallel coordinate plots, normalized by med
%          3.  Parallel coordinate plots, normalized by med and mad
%
%      Intended to be called by coa2pm.m
%      Reads list of files from LISTFILESTR1 and LISTFILESTR2
% Outputs:
%     Only graphics, in a new Figure

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina



%  Set up global variables
%
global SPCAHANDPOS PCP2PHAND FEATMPATH LISTR SUBDIRSTR ;
        %  window positioning vector,
        %  handle for Parallel Coordinate Plot Window
        %  path for storing Zernike feature matrices
        %  string for inputting list file
        %  SUBDIRSTR - current subdirectory 
global LISTFILESTR1 LISTFILESTR2 SETLIST1PATH SETLIST2PATH ;
        %  list file strings
        %  strings to set paths to lists
global PC2STR ;
        %  PC2STR - String with title info for 2 population analyses




%  Read in matrix of Zernike feature coefficients, Population 1
%
disp('      Reading Files for Population 1') ;
eval(SETLIST1PATH) ;
          %  sets LISTR to Full Path List, for Population 1
mfv1 = coaflr ;
d1 = size(mfv1,1) ;
n1 = size(mfv1,2) ;



%  Read in matrix of Zernike feature coefficients, Population 2
%
disp('      Reading Files for Population 2') ;
eval(SETLIST2PATH) ;
          %  sets LISTR to Full Path List, for Population 2
mfv2 = coaflr ;
d2 = size(mfv2,1) ;
n2 = size(mfv2,2) ;



%  Set up window page
%
PCP2PHAND = figure ;
          %  create a new window
set(PCP2PHAND, 'NumberTitle', 'off');
set(PCP2PHAND,'Position', SPCAHANDPOS) ;
set(PCP2PHAND,'Name',['Parallel Coordinates Plot']) ;

titstr = [LISTFILESTR1 ' & ' LISTFILESTR2 ...
               ' - Parallel Coord''s Plot - '] ;

subplot(4,1,1) ;
  plot((1:d2)',mfv2,'c-',(1:d1)',mfv1,'r-') ;
    title([titstr 'Zernike Scale']) ;
    axis([0,d1+1,1.05*min(min([mfv1,mfv2])), ...
                         1.05*max(max([mfv1,mfv2]))]) ;

subplot(4,1,2) ;
  center = median([mfv1, mfv2]')' ;
  nmfv1 = mfv1 - vec2mat(center,n1) ;
  nmfv2 = mfv2 - vec2mat(center,n2) ;
  plot((1:d2)',nmfv2,'c-',(1:d1)',nmfv1,'r-') ;
    title([titstr '(Zernike - median)']) ;
    minmax = 1.05 * max(max(abs([nmfv1,nmfv2]))) ;
    axis([0,d1+1,-minmax,minmax]) ;

subplot(4,1,3) ;
  scale = gpmad([mfv1, mfv2]')' ;
  nmfv1 = nmfv1 ./ vec2mat(scale,n1) ;
  nmfv2 = nmfv2 ./ vec2mat(scale,n2) ;
  plot((1:d2)',nmfv2,'c-',(1:d1)',nmfv1,'r-') ;
    title([titstr '(Zernike - median)/MAD']) ;
    minmax = 1.05 * max(max(abs([nmfv1,nmfv2]))) ;
    axis([0,d1+1,-minmax,minmax]) ;

subplot(4,1,4) ;
  plot((1:d2)',nmfv2,'c-',(1:d1)',nmfv1,'r-') ;
    title([titstr '(Zernike - median)/MAD']) ;
    axis([0,d1+1,-5,5]) ;
