function [comap, hicurve] = coacmap ;
% COACMAP, Sets Keratron Colormap
%      Corneal Topography Analysis System
%      Intended to be called by coaram.m
% Output:
%     comap - colormap for Keratron colors
%     hicurve - Gridpoints of Keratron range

%    Copyright (c) J. S. Marron, N. Locantore, 1998
%    Department of Statistics, University of North Carolina



%  Set up global variable
%
global INDATPATH ;
%  INDATPATH - path for input Keratron files




%  These use the "full range" Keratron data, from the email message:
%             cocolora.msg
%   which were copied into the ASCII file 
%             cocolor1.dat
%  for importing into matlab programs
%    locurve & hicurve are upper and lower ends of the "range"
%    for each color
eval(['load ' INDATPATH 'cocolor1.dat']) ;
          %  Assumes this file is in the directory with input data
locurve = cocolor1(:,1) ;
hicurve = cocolor1(:,2) ;
cyan = cocolor1(:,3) ;
magenta = cocolor1(:,4) ;
yellow = cocolor1(:,5) ;
black = cocolor1(:,6) ;

red   = 1 - cyan + black ;
green = 1 - magenta + black;
blue  = 1 - yellow + black ;

comap = [red green blue] ;
ncomap = size(comap,1) ;
          %  number of rows in the color map ;

%  make sure values are positive
flag = comap < 0 ;
fflag = find(flag) ;
comap(fflag) = zeros(length(fflag),1) ;

%  make sure values are less than 1
flag = comap > 1 ;
fflag = find(flag) ;
comap(fflag) = ones(length(fflag),1) ;





