function coadlwr
% COALWZR, Dynamic List-Wise zernike Reconstruction
%      Corneal Topography Analysis System, ver. 0.1
%   Creates a movie of Zernike Reconstructions (in order of list file)
%      from the current list of Zernike Feature matrix files
%   Intended to be called by coapam.m
%      Reads list of files from LISTFILESTR
% Output:
%     Only graphics in the current figure


%    Copyright (c) J. S. Marron, N. Locantore 1998
%    Department of Statistics, University of North Carolina




%  Set up global variables
%
%  First some general globals
global R0 NMAX IBASIS IRECENT CRAD CANG COMAP NRPT NRIF ;
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  IBASIS - 1 for full (triangle), 2 for radial (3 row)
%  IRECENT - To recenter (or not) decompositions
%  CRAD, radius of recentering (read in as editable text)
          %    this gets reloaded when a feature vec is reloaded from file
%  CANG, angle of recentering (read in as editable text)
          %    this gets reloaded when a feature vec is reloaded from file
%  COMAP - Color Map
%  NRPT - Number of times to Repeat Movie
%  NRIF - Number of times to Repeat Individual Movie Frames
          %    (controls speed of .mpeg version)

%  Next some globals for file names, etc.
global SETLISTPATH LISTFILESTR LISTR ;
%  SETLISTPATH - string to set path to lists 
%  LISTFILESTR - string with input name of file with list of filenames
%  LISTR - string for inputting list file

%  Next the paths for file control
global FEATMPATH SUBDIRSTR ;
%  FEATMPATH - path for storing Zernike feature matrices
%  SUBDIRSTR - current subdirectory (of both indata and outputs)

%  Next some file handles, etc.
global DLWRMOVHAND RDHANDPOS ;
%  DLWRMOVHAND - vector of List-Wise Zernike Recon Movie
%  RDHANDPOS - Position coordinates for Movie Figure

global DLWRM ;
        %  Movie matrix for List Wise Reconstruction


%  set local variables
%
ngrid = 64 ;     %  Construct surfaces as ngrid x ngrid array
r0last = R0 ;          %  Original radius of analysis
nmaxlast = [] ;        %  Original maximum number of Zernike columns
                       %       set to empty, so can tell when read
                       %       is first
ibasislast = IBASIS ;  %  Original basis type (full or radial)
irecentlast = IRECENT ;%  Original recentering (or not)
titstr = LISTFILESTR ;



%  Read in filename
%
eval(SETLISTPATH) ;
% sets LISTR (read-in file string)
fid = fopen(LISTR) ;
          %  assigns a file handle, (read only assumed)
if (fid == -1) ;      %  then file not found, so report

  disp('   ') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
  disp('!!!   Can''t do List Wise Recon., because can''t find file:') ;
  disp(['!!!       ' LISTR]) ;
  disp('!!!') ;
  disp('!!!   Terminating List Wise Recon.') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

else ;


  %  Read in list of filenames
  %
  minfilestr = fscanf(fid,'%s',[8,inf]) ;
            %  formatted read, assumes single column
  fclose(fid) ;

  minfilestr = minfilestr' ;
          %  each row corresponds to one filename
  nfile = size(minfilestr,1) ;
          %  number of files = rows of input matrix


  %  Create ListWise Reconstruction movie
  %
  DLWRMOVHAND = figure ;
          %  create a new window
  set(DLWRMOVHAND, 'NumberTitle', 'off');
  set(DLWRMOVHAND,'Position', RDHANDPOS) ;
  set(DLWRMOVHAND,'Name','Recon.') ;


  DLWRM = [] ;
  for ifile = 1:nfile ;


    %  get current feature vector
    %
    infilestr = minfilestr(ifile,:) ;
          %  combine indiviual entries into file string
    zmistr = [FEATMPATH SUBDIRSTR infilestr '.mat'] ;
          %  full path and filename 
    eval(['load ' zmistr]) ;
          %  loads this Zernike feature matrix and parameter values

    if isempty(nmaxlast) ;  
                          %  then are at first read, 
                          %  so only check other parameters

      if (R0 ~= r0last) ;
        disp('   ') ;
        disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
        disp('!!!   Warning from coalwzr.m:  R0 has changed,') ;
        disp(['!!!      Old R0 = ' num2str(r0last) ',   New R0 = ' num2str(R0)]) ;
        disp('!!!   Hit Any Key to continue with new R0,') ;
        disp('!!!   Or hit (ctrl + C) (twice) to quit') ;
        disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

        pause ;          
      end ;

      if (IBASIS ~= ibasislast) ;
        disp('   ') ;
        disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
        disp('!!!   Warning from coalwzr.m:  IBASIS has changed,') ;
        disp(['!!!      Old IBASIS = ' num2str(ibasislast) ...
                                 ',   New IBASIS = ' num2str(IBASIS)]) ;
        disp('!!!   Hit Any Key to continue with new IBASIS,') ;
        disp('!!!   Or hit (ctrl + C) (twice) to quit') ;
        disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

        pause ;          
      end ;

      if (IRECENT ~= irecentlast) ;
        disp('   ') ;
        disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
        disp('!!!   Warning from coalwzr.m:  IRECENT has changed,') ;
        disp(['!!!      Old IRECENT = ' num2str(irecentlast) ...
                             ',   New IRECENT = ' num2str(IRECENT)]) ;
        disp('!!!   Hit Any Key to continue with new IRECENT,') ;
        disp('!!!   Or hit (ctrl + C) (twice) to quit') ;
        disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

        pause ;          
      end ;

    else ;          %  then are at later reads, so check params

      if (R0 ~= r0last) | (NMAX ~= nmaxlast) | ...
                   (IBASIS ~= ibasislast) | (IRECENT ~= irecentlast) ;
                  %  parameter values have changed, so quit

        %  Write latest values to screen
        NMAX
        nmaxlast
        R0
        r0last
        IBASIS
        ibasislast
        IRECENT
        irecentlast

        disp('   ') ;
        disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
        disp('!!!   Input Zernike Parameters have changed,') ;
        disp(['!!!           (differing file is ' infilestr ')']) ;
        disp('!!!') ;
        disp('!!!   Terminating Listwise Reconstruction') ;
        disp('!!!') ;
        disp('!!!           (Need to redo at least some of the') ;
        disp('!!!            Zernike Decompositions to fix this) ') ;
        disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

        break ;
            %  jump out of loop

      end ;

    end ;

    r0last = R0 ;
    nmaxlast = NMAX ;
    ibasislast = IBASIS ;

    %  Calculate grid quantities
    %
    xgrid = linspace(-R0, R0, ngrid) ;
    ygrid = xgrid ;	        %  Vectors of image coordinate values 


    %  Create image with Keratron Color scheme, and put in current axes
    %
    mout = coazr(betahat) ;
    pcolor(xgrid,ygrid,mout) ;
      shading flat ;
      axis('square') ;
      title(titstr) ;
        caxis([0 1]) ;
      colormap(COMAP) ;

      %  Show where missing data is:
      hold on ;
        adata = linspace(0, (1 - 1/256) * 2 * pi, 256)' ;
%	  polar(adata, inmissr,'-k') ;
%  comment out inner missing data ring, may be used for future analyses
        polar(adata,nonmissr,'-k') ;    
        angc = CANG*pi/180;
        plotang = pi + angc;
        polar(plotang, CRAD, '+k');
        plot(0,0,'ok');
      hold off ;

  for irif = 1:NRIF ;
    DLWRM(:,NRIF*(ifile-1) + irif) = getframe(DLWRMOVHAND) ;
  end ;

  end ;

end ;

movie(DLWRMOVHAND,DLWRM,NRPT) ;









