function coaspcap
% COASPCAP, Does print of Static Principal Component Analysis
%      Corneal Topography Analysis System
%   Creates a color postscript file, of
%   large size window with one page PCA
%      Intended to be called by coapam.m
% Outputs:
%     Postscript file in directory ~cornean\outputs

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina




%  Set up global variables
%
global SPCAHAND LISTFILESTR OUTPUTPATH RMP RCP ;
%  SPCAHAND - handle for Static PCA Window
%  LISTFILESTR - Input list file name
%  OUTPUTPATH - path for output, .ps files, .mpeg files
%  RMP - Robustness Mean Parameter
%  RCP - Robustness Covariance Parameter




if isempty(SPCAHAND) ;
        %  then SPCA window not yet created,
        %  so give error message

  disp('   ') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
  disp('!!!   Can''t print Static PCA plot,') ;
  disp('!!!   Since Analysis not done yet') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

else ;  %  then have done the analysis, so print result

  figure(SPCAHAND) ;

  orient landscape ;
  eval(['print ' OUTPUTPATH LISTFILESTR num2str(RMP) ...
                        num2str(RCP) '.ps -dpsc']) ;

  disp('  Finished Creating Postscript file for ') ;
  disp(['    static PCA of list file: ' LISTFILESTR]) ;

end ;
