disp('Running MATLAB script file lmtzcf41.m') ;
%
%    Makes Figure 4.2, for the Locantore, Marron, Tripoli,
%    Zhang, Cohen paper.
%
%    Copied from cs1.m  (part 6)


seed = 20943343 ;
rand('seed',seed) ;
randn('seed',seed) ;

n = 10 ;
xdat = -2 + .6 * randn(n,1) ;
ydat = -2 - (xdat + 2) + 0.2 * randn(n,1) ;
xdat = [xdat; 3] ;
ydat = [ydat; 3] ;

plot(xdat,ydat,'o') ;
  axis([-4,4,-4,4]) ;
  axis('square') ;
  set(gca,'XTickLabels',[]) ;
  set(gca,'YTickLabels',[]) ;

vmean = mean([xdat, ydat]) ;
hold on ;
  plot(vmean(1),vmean(2),'x') ;
  plot(vmean(1),vmean(2),'o') ;
    vachil = get(gca,'Children') ;
    set(vachil(1),'MarkerSize',10) ;
    set(vachil(1),'LineWidth',2) ;
    set(vachil(2),'MarkerSize',10) ;
    set(vachil(2),'LineWidth',2) ;
hold off ;


cent1x = -1 ;
cent1y = 2 ;
hold on ;
  plot(cent1x,cent1y,'o') ;
    vachil = get(gca,'Children') ;
    set(vachil(1),'MarkerSize',10) ;
    set(vachil(1),'LineWidth',2) ;
hold off ;

r = 1.5 ;
theta = 2 * pi * (0:(1/100):1) ;
cx = cent1x + r * cos(theta) ;
cy = cent1y + r * sin(theta) ;
hold on ;
  plot(cx,cy,'--') ;
hold off ;

cxdat = xdat - cent1x ;
cydat = ydat - cent1y ;
vlength = sqrt(cxdat.^2 + cydat.^2) ;
sxdat = cent1x + r * cxdat ./ vlength ;
sydat = cent1y + r * cydat ./ vlength ;

hold on ;
  plot(sxdat,sydat,'+') ;
  plot(mean(sxdat),mean(sydat),'+') ;
    vachil = get(gca,'Children') ;
    set(vachil(1),'MarkerSize',10) ;
    set(vachil(1),'LineWidth',2) ;
hold off ;


cent2 = rmean([xdat, ydat]) ;
cent2x = cent2(1) ;
cent2y = cent2(2) ;

hold on ;
  plot(cent2x,cent2y,'o') ;
    vachil = get(gca,'Children') ;
    set(vachil(1),'MarkerSize',10) ;
    set(vachil(1),'LineWidth',2) ;
hold off ;

r = 1.5 ;
theta = 2 * pi * (0:(1/100):1) ;
cx = cent2x + r * cos(theta) ;
cy = cent2y + r * sin(theta) ;
hold on ;
  plot(cx,cy,'--') ;
hold off ;

cxdat = xdat - cent2x ;
cydat = ydat - cent2y ;
vlength = sqrt(cxdat.^2 + cydat.^2) ;
sxdat = cent2x + r * cxdat ./ vlength ;
sydat = cent2y + r * cydat ./ vlength ;

hold on ;
  plot(sxdat,sydat,'+') ;
  plot(mean(sxdat),mean(sydat),'+') ;
    vachil = get(gca,'Children') ;
    set(vachil(1),'MarkerSize',10) ;
    set(vachil(1),'LineWidth',2) ;
hold off ;



  orient tall ;
  set(gcf,'PaperPosition',[2.5, 4.5, 4.5, 4.5]) ;
        %  2.0 inches on left and right, 4.0 interior, 8.5 total
        %  4.5 from bottom, 4.5 interior, 11 total
print -deps \matlab\steve\ps\lmtzcf42.eps ;





