function coa1ppcp_outlier
% COA1PPCP, Does Parallel Coordinate Plots for a single population
%      Corneal Topography Analysis System
%   Creates a large size window with:
%          1.  Parallel coordinate plots, in raw units
%          2.  Parallel coordinate plots, normalized by med
%          3.  Parallel coordinate plots, normalized by med and mad
%
%      Intended to be called by coapam.m
%      Reads list of files from LISTFILESTR
% Outputs:
%     Only graphics, in a new Figure

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina



%  Set up global variables
%
global SPCAHANDPOS PCP1PHAND ;
        %  window positioning vector,
        %  Handle for Parallel Coordinate Plot Window
global SETLISTPATH FEATMPATH SUBDIRSTR LISTR LISTFILESTR ;
        %  SETLISTPATH - string to set path to lists
        %  LISTR - string for inputting list file
        %  FEATMPATH - path for storing Zernike feature matrices
        %  SUBDIRSTR - current subdirectory (of both indata and outputs)
        %  list file string






%  Read in matrix of Zernike feature coefficients
%
eval(SETLISTPATH) ;
% sets LISTR (read-in file string)
mfv = coaflr ;
d = size(mfv,1) ;
n = size(mfv,2) ;



%  Set up window page
%
PCP1PHAND = figure ;
          %  create a new window
set(PCP1PHAND, 'NumberTitle', 'off');
set(PCP1PHAND,'Position', SPCAHANDPOS) ;
set(PCP1PHAND,'Name',['Parallel Coordinates Plot for ' LISTFILESTR]) ;

titstr = [LISTFILESTR ' - Parallel Coordinates Plot - '] ;


d
n
mmfv = abs(mfv)' ;
[temp,vindex] = max(mmfv) ;
vindex 
%mfv(:,6:8) 



subplot(4,1,1) ;
  plot((1:d)',mfv,'y-') ;
    title([titstr 'Zernike Scale']) ;
    axis([0,d+1,1.05*min(min(mfv)),1.05*max(max(mfv))]) ;

subplot(4,1,2) ;
  center = median(mfv')' ;
  nmfv = mfv - vec2mat(center,n) ;
  plot((1:d)',nmfv,'y-') ;
    title([titstr '(Zernike - median)']) ;
    minmax = 1.05 * max(max(abs(nmfv))) ;
    axis([0,d+1,-minmax,minmax]) ;

subplot(4,1,3) ;
  scale = gpmad(mfv')' ;
  nmfv = nmfv ./ vec2mat(scale,n) ;
  plot((1:d)',nmfv,'y-') ;
    title([titstr '(Zernike - median)/MAD']) ;
    minmax = 1.05 * max(max(abs(nmfv))) ;
    axis([0,d+1,-minmax,minmax]) ;

subplot(4,1,4) ;
  plot((1:d)',nmfv,'y-') ;
    title([titstr '(Zernike - median)/MAD']) ;
    axis([0,d+1,-5,5]) ;


