disp('Running MATLAB script file lmtzcf44.m') ;
%
%    Makes Figure 4.4, for the Locantore, Marron, Tripoli,
%    Zhang, Cohen paper.
%
%    lines mostly from coa1ppcp.m



global R0 NMAX IBASIS IRECENT LISTR FEATMPATH SUBDIRSTR ;
          %  These are used by coaflr
global R0 NMAX IBASIS IRECENT INDATPATH ;
          %  These are used by coazr

%  First define variables
R0 = 4.0 ;
NMAX = 10 ;
IBASIS = 1 ;
IRECENT = 0 ;
CRAD = 0 ;
CANG = 0 ;

FEATMPATH = '\matlab\cornean\zfm\' ;
SUBDIRSTR = 'milan\' ;
LISTFILESTR = 'prkpreo' ;
SETLISTPATH = 'LISTR = [FEATMPATH SUBDIRSTR LISTFILESTR ''.lst''] ; ' ;



%  Set local parameters
%
ngrid = 64 ;     %  Construct surfaces as ngrid x ngrid array


%  Read in matrix of Zernike feature coefficients
%
eval(SETLISTPATH) ;
% sets LISTR (read-in file string)
mfv = coaflr ;
d = size(mfv,1) ;
n = size(mfv,2) ;




subplot(3,1,1) ;
  plot((1:d)',mfv,'y-') ;
%    title([titstr 'Zernike Scale']) ;
    axis([0,d+1,1.05*min(min(mfv)),1.05*max(max(mfv))]) ;

subplot(3,1,2) ;
  center = median(mfv')' ;
  nmfv = mfv - vec2mat(center,n) ;
  plot((1:d)',nmfv,'y-') ;
%    title([titstr '(Zernike - median)']) ;
    minmax = 1.05 * max(max(abs(nmfv))) ;
    axis([0,d+1,-minmax,minmax]) ;

subplot(3,1,3) ;
  scale = gpmad(mfv')' ;
  nmfv = nmfv ./ vec2mat(scale,n) ;
  plot((1:d)',nmfv,'y-') ;
%    title([titstr '(Zernike - median)/MAD']) ;
    minmax = 1.05 * max(max(abs(nmfv))) ;
    axis([0,d+1,-minmax,minmax]) ;







  orient tall ;
  set(gcf,'PaperPosition',[2.5, 4.0, 4.5, 5.0]) ;
        %  2.5 inches on left and right, 4.0 interior, 8.5 total
        %  4.0 from bottom, 5.0 interior, 11 total
print -deps \matlab\steve\ps\lmtzcf44.eps ;


