%function zarinafig1.m
%  Makes figure 1 for Zarina's Master Paper
%  Designed to called form the command line, after:
%  1.  Cornean is started
%  2.  Parameter R0 = 3.0 is set
%  3.  Directory in Change Parameter Menu set to virezarina
%               (where appropriate files have been copied)
%  4.  File List Prefix in Pop. An. menu set to zarinafig1


%  Copied from:

% COALWZR, List-Wise Zernike Reconstruction
%      Corneal Topography Analysis System, ver. 0.1
%   Creates plots of multiple Zernike Reconstructions (several on a page)
%      from the current list of Zernike Feature matrix files
%      in a new Figure Window (creates several windows, if needed)
%   Intended to be called by coapam.m
%      Reads list of files from LISTFILESTR
% Output:
%     Matlab data file, with Zernike decomposition in vector form
%            in the directory in the global variable FEATMPATH,


%    Copyright (c) J. S. Marron, N. Locantore 1998
%    Department of Statistics, University of North Carolina




%  Set up global variables
%
%  First some general globals
global R0 NMAX IBASIS IRECENT CRAD CANG COMAP ;
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  IBASIS - 1 for full (triangle), 2 for radial (3 row)
%  IRECENT - To recenter (or not) decompositions
%  CRAD, radius of recentering (read in as editable text)
          %    this gets reloaded when a feature vec is reloaded from file
%  CANG, angle of recentering (read in as editable text)
          %    this gets reloaded when a feature vec is reloaded from file
%  COMAP - Color Map

%  Next some globals for file names, etc.
global SETLISTPATH LISTFILESTR LISTR ;
%  SETLISTPATH - string to set path to lists 
%  LISTFILESTR - string with input name of file with list of filenames
%  LISTR - string for inputting list file

%  Next the paths for file control
global FEATMPATH SUBDIRSTR ;
%  FEATMPATH - path for storing Zernike feature matrices
%  SUBDIRSTR - current subdirectory (of both indata and outputs)

%  Next some file handles, etc.
global VLWZRHAND LWZRHANDPOS ;
%  VLWZRHAND - vector of handles for List-Wise Zernike Recon's
%  LWZRHANDPOS - Position coordinates for List-Wise Zernike recons


%  set local variables
%
ngrid = 64 ;     %  Construct surfaces as ngrid x ngrid array
picrows = 4 ;
          %  number of rows for images for output figures
piccols = 6 ;
          %  number of cols for images for output figures
r0last = R0 ;          %  Original radius of analysis
nmaxlast = [] ;        %  Original maximum number of Zernike columns
                       %       set to empty, so can tell when read
                       %       is first
ibasislast = IBASIS ;  %  Original basis type (full or radial)
irecentlast = IRECENT ;%  Original recentering (or not)


%  Read in filename
%
eval(SETLISTPATH) ;
% sets LISTR (read-in file string)
fid = fopen(LISTR) ;
          %  assigns a file handle, (read only assumed)
if (fid == -1) ;      %  then file not found, so report

  disp('   ') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
  disp('!!!   Can''t do List Wise Recon., because can''t find file:') ;
  disp(['!!!       ' LISTR]) ;
  disp('!!!') ;
  disp('!!!   Terminating List Wise Recon.') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

else ;


  %  Read in list of filenames
  %
  minfilestr = fscanf(fid,'%s',[8,inf]) ;
            %  formatted read, assumes single column
  fclose(fid) ;

  minfilestr = minfilestr' ;
          %  each row corresponds to one filename


  %  set page stuff ;
  %
  nfile = size(minfilestr,1) ;
          %  number of files = rows of input matrix
  npage = ceil(nfile / (picrows * piccols)) ;
  ifilestart = 1 ;
  VLWZRHAND = [] ;


  %  Loop through pages
  %
  for ipage = 1:npage ;


    %  Create New Window for This page
    %
    lwzrhand = figure ;
    set(lwzrhand,'Position', LWZRHANDPOS) ;
    VLWZRHAND = [VLWZRHAND; lwzrhand] ;
    orient landscape;
    %  loop through filenames on this page
    %
    ifileend = min((ifilestart + (picrows * piccols) - 1),nfile) ;
    for ifile = ifilestart:ifileend ;

      %  get current feature vector
      %
      infilestr = minfilestr(ifile,:) ;
          %  combine indiviual entries into file string
      zmistr = [FEATMPATH SUBDIRSTR infilestr '.mat'] ;
          %  full path and filename 
      eval(['load ' zmistr]) ;
          %  loads this Zernike feature matrix and parameter values

      if isempty(nmaxlast) ;  
                      %  then are at first read, 
                      %  so only check other parameters

        if (R0 ~= r0last) ;
          disp('   ') ;
          disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
          disp('!!!   Warning from coalwzr.m:  R0 has changed,') ;
          disp(['!!!      Old R0 = ' num2str(r0last) ',   New R0 = ' num2str(R0)]) ;
          disp('!!!   Hit Any Key to continue with new R0,') ;
          disp('!!!   Or hit (ctrl + C) (twice) to quit') ;
          disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

          pause ;          
        end ;

        if (IBASIS ~= ibasislast) ;
          disp('   ') ;
          disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
          disp('!!!   Warning from coalwzr.m:  IBASIS has changed,') ;
          disp(['!!!      Old IBASIS = ' num2str(ibasislast) ...
                                   ',   New IBASIS = ' num2str(IBASIS)]) ;
          disp('!!!   Hit Any Key to continue with new IBASIS,') ;
          disp('!!!   Or hit (ctrl + C) (twice) to quit') ;
          disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

          pause ;          
        end ;

        if (IRECENT ~= irecentlast) ;
          disp('   ') ;
          disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
          disp('!!!   Warning from coalwzr.m:  IRECENT has changed,') ;
          disp(['!!!      Old IRECENT = ' num2str(irecentlast) ...
                               ',   New IRECENT = ' num2str(IRECENT)]) ;
          disp('!!!   Hit Any Key to continue with new IRECENT,') ;
          disp('!!!   Or hit (ctrl + C) (twice) to quit') ;
          disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

          pause ;          
        end ;

      else ;          %  then are at later reads, so check params

        if (R0 ~= r0last) | (NMAX ~= nmaxlast) | ...
                   (IBASIS ~= ibasislast) | (IRECENT ~= irecentlast) ;
                      %  parameter values have changed, so quit

          %  Write latest values to screen
          NMAX
          nmaxlast
          R0
          r0last
          IBASIS
          ibasislast
          IRECENT
          irecentlast

          disp('   ') ;
          disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
          disp('!!!   Input Zernike Parameters have changed,') ;
          disp(['!!!           (differing file is ' infilestr ')']) ;
          disp('!!!') ;
          disp('!!!   Terminating Listwise Reconstruction') ;
          disp('!!!') ;
          disp('!!!           (Need to redo at least some of the') ;
          disp('!!!            Zernike Decompositions to fix this) ') ;
          disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

          break ;
            %  jump out of loop

        end ;

      end ;

      r0last = R0 ;
      nmaxlast = NMAX ;
      ibasislast = IBASIS ;

      %  Calculate grid quantities
      %
      xgrid = linspace(-R0, R0, ngrid) ;
      ygrid = xgrid ;	        %  Vectors of image coordinate values 



      disp(['  Page ' num2str(ipage) ',  file ' infilestr]) ;

      %  setup current axis for plotting image
      %
      iax = ifilestart - (ipage - 1) * (picrows * piccols) ;
      subplot(picrows,piccols,iax) ;

      %  Create image with Keratron Color scheme, and put in current axes
      %
      mout = coazr(betahat) ;
      pcolor(xgrid,ygrid,mout) ;
        shading flat ;
        axis('square') ;
%          titstr = infilestr ;

if ifile <= 6 ;
  titstr = 'Pat. 1, ' ;
  if ifile <= 3 ;
    titstr = [titstr 'Eye 1'] ;
  else ;
    titstr = [titstr 'Eye 2'] ;
  end ;
elseif ifile <= 12 ;
  titstr = 'Pat. 2, ' ;
  if ifile <= 9 ;
    titstr = [titstr 'Eye 1'] ;
  else ;
    titstr = [titstr 'Eye 2'] ;
  end ;
elseif ifile <= 18 ;
  titstr = 'Pat. 3, ' ;
  if ifile <= 15 ;
    titstr = [titstr 'Eye 1'] ;
  else ;
    titstr = [titstr 'Eye 2'] ;
  end ;
else ;
  titstr = 'Pat. 4, ' ;
  if ifile <= 21 ;
    titstr = [titstr 'Eye 1'] ;
  else ;
    titstr = [titstr 'Eye 2'] ;
  end ;
end ;

        title(titstr) ;
          caxis([0 1]) ;
        colormap(COMAP) ;

        %  Show where missing data is:
        hold on ;
          adata = linspace(0, (1 - 1/256) * 2 * pi, 256)' ;
% 	  polar(adata, inmissr,'-k') ;
%  comment out inner missing data ring, may be used for future analyses
          polar(adata,nonmissr,'-k') ;    
          angc = CANG*pi/180;
          plotang = pi + angc;
          polar(plotang, CRAD, '+k');
          plot(0,0,'ok');
        hold off ;

      ifilestart = ifilestart + 1 ;

    end ;

%    %  Add a title for this page
%    %
%    tx = 0.05 ;
%    ty = 0.94 ;
%    tw = 0.8 ;
%    th = 0.05 ;
%          %  set position for new axes, containing only title
%    axes('Position',[tx,ty,tw,th]) ;
%          %  create new axes
%    set(gca,'XTickLabelMode','manual') ;
%    set(gca,'XTickLabel',[]) ;
%    set(gca,'XTickMode','manual') ;
%    set(gca,'XTick',[]) ;
%    set(gca,'XColor',[0,0,0]) ;
%    set(gca,'YTickLabelMode','manual') ;
%    set(gca,'YTickLabel',[]) ;
%    set(gca,'YTickMode','manual') ;
%    set(gca,'YTick',[]) ;
%    set(gca,'YColor',[0,0,0]) ;
%          %  Switch off axis stuff
%set(gca,'visible','off') ;
%          %  Turn off surrounding box
%    titstr = ['Recon''s for file list: ' LISTFILESTR] ;
%    titstr = [titstr ',  page ' num2str(ipage) ',  ' date] ;
%    titstr = [titstr '  NMAX = ' num2str(NMAX) '  r0 = ' num2str(R0)] ;
%    text(0,0.5,titstr) ;
%          %  put down actual title

  end ;

end ;


%  print results
  orient landscape ;
print \matlab\steve\ps\zarinafig1.ps -dpsc ;








