function coadpcas
% COADPCAS, Does save of Dynamic Principal Component Analysis
%      Corneal Topography Analysis System
%   Creates MPEG files, of windows with movies
%      Intended to be called by coapam.m
% Outputs:
%     MPEG files in directory ~cornean\outputs

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina


%  Set up global variables
%
global LISTFILESTR COMAP ;
%  LISTFILESTR - Input list file name
%  COMAP - Color Map
global DPCAM1 DPCAM2 DPCAM3 DPCAM4 ;
        %  Movie matrices in Dynamic PC Analysis



%  Set up mpeg parameters
%
%vopt = [10] ;      %  Need to twiddle these, when have player working
%
%  This is MATLAB "help" to use for choosing parameters:
%	MPGWRITE(M, map, 'filename', options) Encodes M in MPEG format
% 	using the specified colormap and writes the result to the
% 	specified file.  The options argument is an optional vector of
% 	8 or fewer options where each value has the following meaning:
% 	1. REPEAT:
% 		An integer number of times to repeat the movie
% 		(default is 1).
% 	2. P-SEARCH ALGORITHM:
% 		0 = logarithmic	(fastest, default value)
% 		1 = subsample
% 		2 = exhaustive	(better, but slow)
% 	3. B-SEARCH ALGORITHM:
% 		0 = simple	(fastest)
% 		1 = cross2	(slightly slower, default value)
% 		2 = exhaustive	(very slow)
% 	4. REFERENCE FRAME:
% 		0 = original	(faster, default)
% 		1 = decoded	(slower, but results in better quality)
% 	5. RANGE IN PIXELS:
% 		An integer search radius.  Default is 10.
% 	6. I-FRAME Q-SCALE:
% 		An integer between 1 and 31.  Default is 8.
% 	7. P-FRAME Q-SCALE:
% 		An integer between 1 and 31.  Default is 10.
% 	8. B-FRAME Q-SCALE:
% 		An integer between 1 and 31.  Default is 25.
 



%  Construct flag for stopping, 
%             when not all movies have made yet
%
stopflag = isempty(DPCAM1) | isempty(DPCAM2) ;
stopflag = stopflag | isempty(DPCAM3) ;
stopflag = stopflag | isempty(DPCAM4) ;



if stopflag ;
        %  then DPCA movies not yet created,
        %  so give error message

  disp('   ') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
  disp('!!!   Can''t save Dynamic PCA movies,') ;
  disp('!!!   Since not all movies made yet') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

else ;  %  then have done the analysis, so print result

  for imov = 1:4 ;
    outstr = ['outputs\' LISTFILESTR num2str(imov) '.mpg'] ;
    evstr = ['mpgwrite(DPCAM' num2str(imov) ',COMAP,outstr) ;'] ;
%    evstr = ['mpgwrite(DPCAM' num2str(imov) ',COMAP,outstr,vopt) ;'] ;
    eval(evstr) ;
  end ;

  disp('  Finished saving MPEG movie files for ') ;
  disp(['    dynamic PCA of list file: ' LISTFILESTR]) ;
  disp('        Caution: actual MPEG file is created') ;
  disp('                   only after leaving MATLAB') ;

end ;
