function coaipm
% COAIPM, Individual in Population Menu Generation for Cornean
%      Corneal Topography Analysis System
%   Creates a menu in the current Figure Window
%      Intended to be called by cornean.m
% Outputs:
%     Only graphics, in current Figure

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina


%  Set up global variables
%
%  First some general globals
global R0 NMAX MATLABVER COMAP NRPT ;
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  MATLABVER - version of MATLAB, 4 or 5
%  COMAP - Color Map
%  NRPT - Number of times to Repeat Movie
global INFILESTR FEATMPATH LISTFILESTR SETLISTPATH LISTR ;
%  INFILESTR - string with input filename
%  FEATMPATH - path for storing Zernike feature matrices
%  LISTFILESTR - string with input name of file with list of filenames
%  SETLISTPATH - string to set path to lists
%  LISTR - string for inputting list file
global SCREENWD SCREENHT MENUWD ;
        % overall sizes of display area, generic menu width
global VERTGAP HORIZGAP TITLHT BUTTONHT
        %  generic sizes of objects on menus
%  Next the globals for handles to figure windows and plots
global IPMHANDPOS IPMHAND IPMETIHAND IPMETPHAND ;
%  IPMHANDPOS - Position coordinates for Indiv. in Population Menu
%  IPMHAND - handle for Figure Window with Indiv. in Population Menu
%  IPMETIHAND - handle for editable text, with input file prefix for Indiv.
%  IPMETPHAND - handle for editable text, with input file prefix for Pop'n
global IPCAHANDPOS 
%  IPCAHANDPOS - Position coordinates for Indiv. in PCA plot
global IPCAHAND ;
        %  Handle for Indiv. in PC Analysis
global RFILESUF HFILESUF ;
        %  File Suffixes for data files


%  Initialize path, in case default is unacceptable
%
eval(SETLISTPATH) ;




%  Create Individual in Population Menu window and set up basics
%
if isempty(IPMHAND) ;          %  then need a new window
  IPMHAND = figure ;
else ;                     %  then work with existing menu
  figure(IPMHAND) ;
end ;
clf ;
set(IPMHAND, 'NumberTitle', 'off');
set(IPMHAND,'Position', [IPMHANDPOS]) ;
set(IPMHAND,'Name','Ind. in Pop. Menu (Don''t Close)') ;





%  Create header
%
titly = IPMHANDPOS(4) - (TITLHT + VERTGAP) ;
          %  get y coord of starting point working down from top
titlwd = (MENUWD - 2 * HORIZGAP) ;
h1s = 'Corneal Topography Analysis System' ;
          %  string to display as header, window size was chosen 
          %  to make this split correctly
ipmh1hand = uicontrol(IPMHAND,'Style','text',...
            'Position',[HORIZGAP titly titlwd TITLHT],...
            'String',h1s, 'BackgroundColor', [0 0 0], ...
 	    'ForegroundColor', [0 1 1]);



%  Create Editable text, for entering individ. Keratron data filename prefix
%
t1s = 'Inidiv. Data File Prefix:' ;
          %  text to display in front of entry field
twd = IPMHANDPOS(3) - 2 * HORIZGAP ;
          %  total width for this field
twd1 = .7 * twd ;
twd2 = .3 * twd ;
          %  respective parts for the label and editable text
ty = IPMHANDPOS(4) - (TITLHT + BUTTONHT + 2 * VERTGAP) ;
          %  get y coord of starting point working down from top
iamthand = uicontrol(IPMHAND,'Style','text',...
              'Position',[HORIZGAP ty twd1 BUTTONHT],...
              'String',t1s) ;
          %  Creation of text on Main menu, in front of entry field
IPMETIHAND = uicontrol(IPMHAND,'Style','Edit',...
                    'String',INFILESTR,...
                    'Position',[(HORIZGAP + twd1) ty twd2 BUTTONHT],...
                    'CallBack',['INFILESTR = get(IPMETIHAND,''String'') ;',...
                    'eval(SETPATHSTR) ;']) ;
          %  User types text into window, and then global variable
          %  "INFILESTR" contains string with filename
          %  Note: "String" is just a starting default, known to be there



%  Create push button for "Individual Data File Directory"
%
buttony = IPMHANDPOS(4) - (TITLHT + 2 * BUTTONHT + 3 * VERTGAP) ;
          %  get y coord of starting point working down from top
buttonwd = .3 * (MENUWD - 2 * HORIZGAP) ;
          %  only use 30% of usual width
ipmcbs1 = 'disp(''Contents of "indata" directory:'') ; dir indata ;' ;
          %  Individual Analysis CallBack String 1: 
          %  shows contents of input data directory 
mmb1hand = uicontrol(IPMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','see Dir.',...
              'CallBack',ipmcbs1) ;



%  Create push button for "Help"
%
buttonx = HORIZGAP + .7 * (MENUWD - 2 * HORIZGAP) ;
buttonwd = .3 * (MENUWD - 2 * HORIZGAP) ;
          %  only use 30% of usual width
ipmcbs2 = ['disp(''      The field "Keratron Data File Prefix"'') ;'...
           'disp(''      needs to have the prefix of a file that '') ;'...
           'disp(''      is in the "indata" directory '') ;'...
           'disp('' '') ;'] ;
          %  Individual Analysis CallBack String 1: 
          %  give some advice about file storage
mmb1hand = uicontrol(IPMHAND,'Style','push',...
              'Position',[buttonx buttony buttonwd BUTTONHT],...
              'String','Help',...
              'CallBack',ipmcbs2) ;



%  Create Editable text, for entering input List filename prefix
%
t1s = 'Pop''n File List Prefix:' ;
          %  text to display in front of entry field
twd = IPMHANDPOS(3) - 2 * HORIZGAP ;
          %  total width for this field
twd1 = .7 * twd ;
twd2 = .3 * twd ;
          %  respective parts for the label and editable text
ty = IPMHANDPOS(4) - (TITLHT + 3 * BUTTONHT + 4 * VERTGAP) ;
          %  get y coord of starting point working down from top
ipmthand = uicontrol(IPMHAND,'Style','text',...
              'Position',[HORIZGAP ty twd1 BUTTONHT],...
              'String',t1s) ;
          %  Creation of text on Main menu, in front of entry field
IPMETPHAND = uicontrol(IPMHAND,'Style','Edit',...
                    'String',LISTFILESTR,...
                    'Position',[(HORIZGAP + twd1) ty twd2 BUTTONHT],...
                    'CallBack',['LISTFILESTR = get(IPMETPHAND,''String'') ;',...
                    'eval(SETLISTPATH) ;']) ;
          %  User types text into window, and then global variable
          %  "LISTFILESTR" contains string with filename
          %  Note: "String" is just a starting default, known to be there



%  Create push button for "Input List File Directory"
%
buttony = IPMHANDPOS(4) - (TITLHT + 4 * BUTTONHT + 5 * VERTGAP) ;
          %  get y coord of starting point working down from top
buttonwd = .3 * (MENUWD - 2 * HORIZGAP) ;
          %  only use 30% of usual width
ipmcbs1 = ['disp(''Current List Files:'') ;'...
            'dir ' FEATMPATH '*.lst ;'] ;
          %  Population Analysis CallBack String 1: 
          %  shows currently available list files
mmb1hand = uicontrol(IPMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','see Dir.',...
              'CallBack',ipmcbs1) ;



%  Create push button for "Help"
%
buttonx = HORIZGAP + .7 * (MENUWD - 2 * HORIZGAP) ;
buttonwd = .3 * (MENUWD - 2 * HORIZGAP) ;
          %  only use 30% of usual width
ipmcbs2 = ['disp(''      The field "Pop''''n File List Prefix:"'') ;'...
           'disp(''      needs to have the prefix of a file where '') ;'...
           'disp(''      ________.lst is in the "zfm" directory '') ;'...
           'disp('' '') ;'] ;
          %  Population Analysis CallBack String 1: 
          %  give some advice about file storage
mmb2hand = uicontrol(IPMHAND,'Style','push',...
              'Position',[buttonx buttony buttonwd BUTTONHT],...
              'String','Help',...
              'CallBack',ipmcbs2) ;





%  Create push button for Individual in Population plot
%
buttony = IPMHANDPOS(4) - (TITLHT + 5 * BUTTONHT + 6 * VERTGAP) ;
          %  get y coord of starting point working down from top
twd = MENUWD - 2 * HORIZGAP ;
          %  total width for this field
cbs1 = 'coaipca' ;
          %  CallBack String 1: Calls coaipca.m, for
          %          individual in principal component analysis 
ipmb1hand = uicontrol(IPMHAND,'Style','push',...
              'Position',[HORIZGAP buttony twd BUTTONHT],...
              'String','Individual in PCA',...
              'CallBack',cbs1) ;
buttony = IPMHANDPOS(4) - (TITLHT + 6 * BUTTONHT + 7 * VERTGAP) ;
          %  get y coord of starting point working down from top
bgap = .2 * twd ;
bwd = twd - 2* bgap ;
cbs2 = 'coaipcap' ;
          %  CallBack String 2: Calls coaspcap.m, for making print of
          %          static principal component analysis 
ipmb2hand = uicontrol(IPMHAND,'Style','push',...
              'Position',[(HORIZGAP + bgap) buttony bwd BUTTONHT],...
              'String','Print (.ps)',...
              'CallBack',cbs2) ;




