disp('Cornean: Cornea Topography Analysis System, ver. 1.1') ;
disp('(c) J. S. Marron and N. Locantore, 1998') ;
disp('Department of Statistics, University of North Carolina') ;
disp(' ') ;
%
%    This generates main control menu of Cornean
%    Cornea Topography Analysis System,
%      for Analysis of Data Generated by the Keratron 2000
%    This system performs tasks including display of an image,
%      decomposition into Zernike feature matrices,
%      and analyis of populations of feature matrices
%


%  First close all previous windows, and clear all variables
%
close all ;
clear all ;


%%=====================================================================

%  Define global variables
%
global R0 NMAX MATLABVER CRAD CANG COMAP ;
	% R0, Maximum radius and NMAX, maximum zernike order for analysis
        % MATLABVER, version of MATLAB, 4 or 5
        % CRAD, radius of recentering (read in as editable text)
        % CANG, angle of recentering (read in as editable text)
        % COMAP, Color Map
        % NRPT, Number of times to Repeat Movie
global SCREENWD SCREENHT MENUWD ;
        % overall sizes of display area, generic menu width
global VERTGAP HORIZGAP TITLHT BUTTONHT
        %  generic sizes of objects on menus
global MMHAND IAMHAND PAMHAND MAMHAND IPMHAND RAMHAND RRAMHAND
        %  MMHAND - handle for Figure Window with Main Menu
        %  IAMHAND - handle for Figure Window with Individual Analysis Menu
        %  PAMHAND - handle for Figure Window with Population Analysis Menu
        %  MAMHAND - handle for Figure Window with Morphing Analysis Menu
        %  IPMHAND - handle for Figure Window with Indiv. in Population Menu
        %  RAMHAND - handle for Figure Window with Reconstruct, Analyze Menu
	%  RRAMHAND - handle for Figure Window with Radial Recon/Analyze Menu

global IAMETHAND IAMETRHAND IAMETAHAND ;
        %  IAMETHAND - handle for editable text with data file prefix
        %  IAMETRHAND - handle for editable text, with input recentering radius
        %  IAMETAHAND - handle for editable text, with input recentering angle
global RAMCBHAND RAMSL1HAND RAMSL2HAND RAMSAXHAND ;
        %  RAMCBHAND - handle for CheckBoxes in Reconstruct, Analyze Menu
        %  RAMSL1HAND - handle for Slider for Mean of smooths
        %                              in Reconstruct, Analyze Menu
        %  RAMSL2HAND - handle for Slider for sd of smooths
        %                              in Reconstruct, Analyze Menu
        %  RAMSAXHAND - handle for SmoothDemo Axis, in Reconstruct, Analyze Menu
global RRAMCBHAND 
        %  RRAMCBHAND - handle for CheckBoxes in Radial Recon/Analyze Menu
global PAMETHAND VLWZRHAND ;
        %  PAMETHAND - handle for editable text with list file
        %  VLWZRHAND - vector of handles for List-Wise Zernike Recon's
global MAMET1HAND MAMET2HAND MAMET3HAND ;
        %  MAMET1HAND - handle for editable text with data file 1 prefix
        %  MAMET2HAND - handle for editable text with data file 2 prefix
        %  MAMET3HAND - handle for editable text with data file 3 prefix
global IPMETIHAND IPMETPHAND
        %  IPMETIHAND - handle for ed. text, with input file prefix for Indiv.
        %  IPMETPHAND - handle for ed. text, with input file prefix for Pop'n
global MMHANDPOS IAMHANDPOS PAMHANDPOS MAMHANDPOS IPMHANDPOS ;
global RAMHANDPOS RRAMHANDPOS RDHANDPOS PMAPHANDPOS LWZRHANDPOS ;
global DPCAHANDPOS DPCAM1POS DPCAM2POS DPCAM3POS DPCAM4POS SPCAHANDPOS ;
global IPCAHANDPOS ;
	% Figure window positioning handles
global INFILESTR SETPATHSTR RFILESUF HFILESUF CFILESUF;
        % Strings for individual data files
global RISTR HISTR CISTR INDATPATH FEATMPATH ;
        % More strings for individual data files
global LISTFILESTR SETLISTPATH LISTR
        % strings for population lists
global M1FILESTR M2FILESTR M3FILESTR ;
        % strings with movie input filenames
global SETM1PATH SETM2PATH SETM3PATH M1STR M2STR M3STR ;
        % strings for setting movie paths
global DPCAM1HAND DPCAM2HAND DPCAM3HAND DPCAM4HAND SPCAHAND MAMOVHAND ;
        %  Handles for movie windows in Dynamic and Static PC
        %  and morphing Analyses
global DPCAM1 DPCAM2 DPCAM3 DPCAM4 MAM ; 
        %  Movie matrices in Dynamic PC and Morphing Analysis
global IPCAHANDPOS ;
        %  Handle for Indiv. in PC Analysis
global RAMVCIND RRAMVCIND SMOMEAN SMOSD ;
        %  RAMVCIND - Vector of indicators for coefficients in our out,
        %                      in manually driven reconstruction
	%  RRAMVCIND - same as above, but for Radial reconstruction
        %  SMOMEAN - mean for smoothed reconstruction
        %  SMOSD - standard deviation for smoothed reconstruction



%%=====================================================================

%  Adjust this depending on environment where Cornean is running
%

ienviron = 3;	%%  1 -- denotes Matlab 4, 13" monitor, small memory PC,
                %%             PC file path
		%%  2 -- denotes Matlab 4, monitor for Sun Workstation,
                %%             file path for Locantore
                %%  3 -- denotes Matlab 4, 13" monitor, large memory PC,
                %%             PC file path
                %%  4 -- denotes Matlab 5, 13" monitor, large memory PC,
                %%             PC file path
		%%  more here as necessary      



      
%%=====================================================================

%  This block contains environment dependent settings
%

if ienviron == 1;   % file path for environment 1, Marron's PC's
%  General globals
	NMAX = 5 ;
          %  maximum order of Zernikes to use
	R0 = 4.2 ;
          %  radius of analysis
          %    these get reloaded when a feature vec is reloaded from file

	MENUWD = 260 ;
          %  Generic Menu Width
        VERTGAP = 12 ;
          %  Vertical gaps between buttons, etc.
        HORIZGAP = 20 ;
          %  Horizontal gap between buttons, etc.
        TITLHT = 20 ;
          %  Height of Title Fields
        BUTTONHT = 18 ;
          %  Height of Button Fields
          %      set these to just include all text lines in menus

        screenfact = 1 ;
          %  set this bigger than one to make single image plots bigger

	INFILESTR = '000121_2' ;    
          %  default file name for input         
          %  Favorites are:  000121_2   (good standard Kerataconus)
          %                  000084_1   (central Kerataconus)
          %                  000053_1   (PRK big red ring)
          %                  000139_2   (PRK, wide ring, so thin outer boundary)
          %                  000006_1   (Normal)
	RFILESUF = '.xlb' ;
          %  radii data file suffix 
   	HFILESUF = '.zlb' ;
          %  height data file suffix
   	CFILESUF = '.tlb' ;
          %  curvature data file suffix

        LISTFILESTR = 'prkpreo' ;
          %  default file list

	global INDATPATH FEATMPATH ;
	INDATPATH = '\matlab\cornean\indata\' ;
          %  path for input Keratron files
	FEATMPATH = '\matlab\cornean\zfm\' ;
          %  path for storing Zernike feature matrices

        SETPATHSTR = [...
	'RISTR = [INDATPATH INFILESTR RFILESUF] ;', ...
	'HISTR = [INDATPATH INFILESTR HFILESUF] ;', ...
	'CISTR = [INDATPATH INFILESTR CFILESUF] ;'] ;
          %  Set full filenames

        SETLISTPATH = 'LISTR = [FEATMPATH LISTFILESTR ''.lst''] ; ' ;
          %  Set full filename for list file

        M1FILESTR = '000059_2' ;
        M2FILESTR = '000042_1' ;
          %  default movie files

        SETM1PATH = 'M1STR = [FEATMPATH M1FILESTR] ;' ;
        SETM2PATH = 'M2STR = [FEATMPATH M2FILESTR] ;' ;
        SETM3PATH = 'M3STR = [FEATMPATH M3FILESTR] ;' ;
          %  Set full filenames for movie inputs

        NRPT = 10 ;
          %  number of times to replay movies
          %      (don't use negative for "go back and forth",
          %              since is already handled (separately)
          %              individual contexts)

        MATLABVER = 4 ;



%%--------------------------------------------------------------------

elseif ienviron == 2;   % environment for Locantore's Unix
%  General globals
	NMAX = 10 ;
  	  %  maximum number of Zernikes to use	
	R0 = 4 ;
          %  radius of analysis
          %    these get reloaded when a feature vec is reloaded from file

	MENUWD = 300 ;
          %  Generic Menu Width
        VERTGAP = 12 ;
          %  Vertical gaps between buttons, etc.
        HORIZGAP = 20 ;
          %  Horizontal gap between buttons, etc.
        TITLHT = 25 ;
          %  Height of Title Fields
        BUTTONHT = 18 ;
          %  Height of Button Fields
          %      set these to just include all text lines in menus

        screenfact = 2 ;
          %  set this bigger than one to make single image plots bigger

	INFILESTR = '000188_1' ;    
          %  default file name for input   
	RFILESUF = '.xlb' ;
          %  radii data file suffix 
   	HFILESUF = '.zlb' ;
          %  height data file suffix
   	CFILESUF = '.tlb' ;
          %  curvature data file suffix

        LISTFILESTR = 'normal1' ;
          %  default file list

	global INDATPATH FEATMPATH ;
  INDATPATH = '/home/Mickey/students/locantor/cornean/indata/normal/';
          %  path for input Keratron files
	FEATMPATH = '/home/Mickey/students/locantor/cornean/zfm/' ;
          %  path for storing Zernike feature matrices

        SETPATHSTR = [...
	'RISTR = [INDATPATH INFILESTR RFILESUF] ;', ...
	'HISTR = [INDATPATH INFILESTR HFILESUF] ;', ...
	'CISTR = [INDATPATH INFILESTR CFILESUF] ;'] ;
          %  Set full filenames

        SETLISTPATH = 'LISTR = [FEATMPATH LISTFILESTR ''.lst''] ; ' ;
          %  Set full filename for list file

        M1FILESTR = '000059_2' ;
        M2FILESTR = '000042_1' ;
          %  default movie files

        SETM1PATH = 'M1STR = [FEATMPATH M1FILESTR] ;' ;
        SETM2PATH = 'M2STR = [FEATMPATH M2FILESTR] ;' ;
        SETM3PATH = 'M3STR = [FEATMPATH M3FILESTR] ;' ;
          %  Set full filenames for movie inputs

        NRPT = 10 ;
          %  number of times to replay movies
          %      (don't use negative for "go back and forth",
          %              since is already handled (separately)
          %              individual contexts)

        MATLABVER = 4 ;



%%--------------------------------------------------------------------

elseif ienviron == 3;   % environment for Marron's Matlab 4, large memory
%  General globals
	NMAX = 10 ;
  	  %  maximum number of Zernikes to use	
	R0 = 4.2 ;
          %  radius of analysis
          %    these get reloaded when a feature vec is reloaded from file

	MENUWD = 300 ;
          %  Generic Menu Width
        VERTGAP = 12 ;
          %  Vertical gaps between buttons, etc.
        HORIZGAP = 20 ;
          %  Horizontal gap between buttons, etc.
        TITLHT = 20 ;
          %  Height of Title Fields
        BUTTONHT = 18 ;
          %  Height of Button Fields
          %      set these to just include all text lines in menus

        screenfact = 1 ;
          %  set this bigger than one to make single image plots bigger

	INFILESTR = '000121_2' ;    
          %  default file name for input         
          %  Favorites are:  000121_2   (good standard Kerataconus)
          %                  000084_1   (central Kerataconus)
          %                  000053_1   (PRK big red ring)
          %                  000139_2   (PRK, wide ring, so thin outer boundary)
          %                  000006_1   (Normal)
	RFILESUF = '.xlb' ;
          %  radii data file suffix 
   	HFILESUF = '.zlb' ;
          %  height data file suffix
   	CFILESUF = '.tlb' ;
          %  curvature data file suffix

        LISTFILESTR = 'prkpreo' ;
          %  default file list

	global INDATPATH FEATMPATH ;
	INDATPATH = '\matlab\cornean\indata\' ;
          %  path for input Keratron files
	FEATMPATH = '\matlab\cornean\zfm\' ;
          %  path for storing Zernike feature matrices

        SETPATHSTR = [...
	'RISTR = [INDATPATH INFILESTR RFILESUF] ;', ...
	'HISTR = [INDATPATH INFILESTR HFILESUF] ;', ...
	'CISTR = [INDATPATH INFILESTR CFILESUF] ;'] ;
          %  Set full filenames

        SETLISTPATH = 'LISTR = [FEATMPATH LISTFILESTR ''.lst''] ; ' ;
          %  Set full filename for list file

        M1FILESTR = '000059_2' ;
        M2FILESTR = '000042_1' ;
          %  default movie files

        SETM1PATH = 'M1STR = [FEATMPATH M1FILESTR] ;' ;
        SETM2PATH = 'M2STR = [FEATMPATH M2FILESTR] ;' ;
        SETM3PATH = 'M3STR = [FEATMPATH M3FILESTR] ;' ;
          %  Set full filenames for movie inputs

        NRPT = 10 ;
          %  number of times to replay movies
          %      (don't use negative for "go back and forth",
          %              since is already handled (separately)
          %              individual contexts)

        MATLABVER = 4 ;



%%--------------------------------------------------------------------

elseif ienviron == 4;   % environment for large memory PC, Matlab 5
%  General globals
	NMAX = 10 ;
  	  %  maximum number of Zernikes to use	
	R0 = 4.2 ;
          %  radius of analysis
          %    these get reloaded when a feature vec is reloaded from file

	MENUWD = 300 ;
          %  Generic Menu Width
        VERTGAP = 12 ;
          %  Vertical gaps between buttons, etc.
        HORIZGAP = 20 ;
          %  Horizontal gap between buttons, etc.
        TITLHT = 20 ;
          %  Height of Title Fields
        BUTTONHT = 18 ;
          %  Height of Button Fields
          %      set these to just include all text lines in menus

        screenfact = 1 ;
          %  set this bigger than one to make single image plots bigger

	INFILESTR = '000121_2' ;    
          %  default file name for input         
          %  Favorites are:  000121_2   (good standard Kerataconus)
          %                  000084_1   (central Kerataconus)
          %                  000053_1   (PRK big red ring)
          %                  000139_2   (PRK, wide ring, so thin outer boundary)
          %                  000006_1   (Normal)
	RFILESUF = '.xlb' ;
          %  radii data file suffix 
   	HFILESUF = '.zlb' ;
          %  height data file suffix
   	CFILESUF = '.tlb' ;
          %  curvature data file suffix

        LISTFILESTR = 'prkpreo' ;
          %  default file list

	global INDATPATH FEATMPATH ;
	INDATPATH = '\matlab\cornean\indata\' ;
          %  path for input Keratron files
	FEATMPATH = '\matlab\cornean\zfm\' ;
          %  path for storing Zernike feature matrices

        SETPATHSTR = [...
	'RISTR = [INDATPATH INFILESTR RFILESUF] ;', ...
	'HISTR = [INDATPATH INFILESTR HFILESUF] ;', ...
	'CISTR = [INDATPATH INFILESTR CFILESUF] ;'] ;
          %  Set full filenames

        SETLISTPATH = 'LISTR = [FEATMPATH LISTFILESTR ''.lst''] ; ' ;
          %  Set full filename for list file

        M1FILESTR = '000059_2' ;
        M2FILESTR = '000042_1' ;
          %  default movie files

        SETM1PATH = 'M1STR = [FEATMPATH M1FILESTR] ;' ;
        SETM2PATH = 'M2STR = [FEATMPATH M2FILESTR] ;' ;
        SETM3PATH = 'M3STR = [FEATMPATH M3FILESTR] ;' ;
          %  Set full filenames for movie inputs

        NRPT = 10 ;
          %  number of times to replay movies
          %      (don't use negative for "go back and forth",
          %              since is already handled (separately)
          %              individual contexts)

        MATLABVER = 5 ;



%%--------------------------------------------------------------------
end;

eval(SETPATHSTR) ;

%%=====================================================================

%  Set up Keratron colormap
%
COMAP = coacmap ;



%  Get Screensize
%
ScreenSize = get(0,'ScreenSize') ;
          %  4-vector of screensize in pixels
SCREENWD = ScreenSize(3) ;
          %  screen width
SCREENHT = ScreenSize(4) ;
          %  screen height


%  Main Menu Window
%
mmwd = MENUWD ;
          %  width for main menu
nmmbutton = 4 ;
          %  Number of buttons to put on main menu
mmhdrht = 2 * TITLHT ;
          %  Main Menu Header Height (has more line than usual)
mmht = mmhdrht + nmmbutton * BUTTONHT + (nmmbutton + 2) * VERTGAP ;
          %  height for main menu
mmx = 1 ;
          %  put on left side
mmy = SCREENHT - mmht ;
          %  put at top
MMHANDPOS = [mmx, mmy, mmwd, mmht] ;


%  Individual Analysis Menu
%
iamwd = 1.05 * MENUWD ;
niambutton = 7 ;
          %  Number of buttons to put on Individual Analysis menu
iamht = TITLHT + niambutton * BUTTONHT + 2 * 2 + (niambutton + 4) * VERTGAP ;
          %  height for Individual Analysis menu, as:
          %    niambutton rows of buttons
          %    2 boundary lines (2 pixels deep)
iamx = 1 + 0.10 * SCREENWD ;
          %  put 10% from left side
iamy = SCREENHT - iamht - 0.13 * SCREENHT ;
          %  put 13% down from top
IAMHANDPOS  = [iamx,iamy,iamwd,iamht] ;


%  Population Analysis Menu
%
pamwd = MENUWD ;
npambutton = 7 ;
          %  Number of buttons to put on Population Analysis menu
pamht = TITLHT + npambutton * BUTTONHT + (npambutton + 2) * VERTGAP ;
          %  height for Population Analysis menu, as:
          %    npambutton rows of buttons
pamx = 1 + 0.20 * SCREENWD ;
          %  put 20% from left side
pamy = SCREENHT - pamht - 0.13 * SCREENHT ;
          %  put 13% down from top
PAMHANDPOS  = [pamx,pamy,pamwd,pamht] ;


%  Difference Analysis Menu (formerly called "morphing analysis")
%
mamwd = MENUWD ;
nmambutton = 9 ;
          %  Number of buttons to put on Difference Analysis menu
mamht = TITLHT + nmambutton * BUTTONHT + (nmambutton + 2) * VERTGAP ;
          %  height for Difference Analysis menu, as:
          %    nmambutton rows of buttons
mamx = 1 + 0.30 * SCREENWD ;
          %  put 30% from left side
mamy = SCREENHT - mamht - 0.13 * SCREENHT ;
          %  put 13% down from top
MAMHANDPOS  = [mamx,mamy,mamwd,mamht] ;


%  Individual in Population Menu
%
ipmwd = MENUWD ;
nipmbutton = 6 ;
          %  Number of buttons to put on Individual in Population menu
ipmht = TITLHT + nipmbutton * BUTTONHT + (nipmbutton + 2) * VERTGAP ;
          %  height for Individual in Population menu, as:
          %    nipmbutton rows of buttons
ipmx = 1 + 0.40 * SCREENWD ;
          %  put 20% from left side
ipmy = SCREENHT - ipmht - 0.13 * SCREENHT ;
          %  put 13% down from top
IPMHANDPOS  = [ipmx,ipmy,ipmwd,ipmht] ;


%  Single Image, Reconstruct Analyze Menu
%  WAS 490 400
ramwd = 160 + (40*NMAX) ;  %  here use old value that works well
ramht = 180 + (20*NMAX) ;  %  again use old value that works well
ramx = 1 + 0.10 * SCREENWD ;
          %  put 10% from left side
ramy = SCREENHT - ramht - 0.18 * SCREENHT ;
          %  put 18% down from top
RAMHANDPOS  = [ramx,ramy,ramwd,ramht] ;

%  Single Image, Radial Reconstruct Analyze Menu
%  
ramwd = 160 + (15*NMAX) ;  %  here use old value that works well
ramht = 180 + (35*NMAX) ;  %  again use old value that works well
ramx = 1 + 0.10 * SCREENWD ;
          %  put 10% from left side
ramy = SCREENHT - ramht - 0.18 * SCREENHT ;
          %  put 18% down from top
if ramy < 0 ;    %  if box starts below the screen bottom
  ramy = 0 ;            %  then start at bottom
  ramht = SCREENHT ;    %  and use full height of screen
end ;
RRAMHANDPOS  = [ramx,ramy,ramwd,ramht] ;

%  Raw Data, and Reconstructed single image positions
%
rdwd = screenfact * 2 * 64 + 40 ;
          %  2 * 64 + boundary stuff
rdht = screenfact * 2 * 64 + 60 ;
          %  2 * 64 + boundary stuff
rdx = SCREENWD - 1.3 * rdwd ;
rdy = SCREENHT - 1.5 * rdht ;
RDHANDPOS = [rdx rdy rdwd rdht] ;


%  Power Map Position
%
pmapwd = screenfact * 120 ;
pmapht = screenfact * 80 ;
pmapx = 1 + 0.03 * SCREENWD ;
pmapy = 1 + 0.03 * SCREENHT ;
PMAPHANDPOS = [pmapx pmapy pmapwd pmapht] ;


%  List-Wise Reconstruction Window Position
%
lwzrwd = .85 * SCREENWD ;
lwzrht = .85 * SCREENHT ;
lwzrx = .99 * SCREENWD - lwzrwd ;
lwzry = 1 + .05 * SCREENHT ;
LWZRHANDPOS = [lwzrx lwzry lwzrwd lwzrht] ;


%  Static PCA Window Position
%
spcawd = .85 * SCREENWD ;
spcaht = .85 * SCREENHT ;
spcax = 1 + .05 * SCREENWD ;
spcay = 1 + .05 * SCREENHT ;
SPCAHANDPOS = [spcax spcay spcawd spcaht] ;


%  Dynamic PCA Control Panel Position
%
dpcawd = MENUWD ;
dpcaht = BUTTONHT + 2 * VERTGAP ;
dpcax = 1 + 0.03 * SCREENWD ;
dpcay = 1 + 0.03 * SCREENHT ;
DPCAHANDPOS = [dpcax dpcay dpcawd dpcaht] ;


%  Dynamic PCA Movie Positions
%
dpcamwd = 128 + 20 ;
          %  2 * 64 + boundary stuff
dpcamht = 256 + 60 ;
          %  4 * 64 + boundary stuff
dpcam1x = .98 * SCREENWD - 4 * dpcamwd;
dpcam1y = SCREENHT - 2.0 * rdht ;
DPCAM1POS = [dpcam1x dpcam1y dpcamwd dpcamht] ;
dpcam2x = .98 * SCREENWD - 3 * dpcamwd;
dpcam2y = SCREENHT - 2.0 * rdht ;
DPCAM2POS = [dpcam2x dpcam2y dpcamwd dpcamht] ;
dpcam3x = .98 * SCREENWD - 2 * dpcamwd;
dpcam3y = SCREENHT - 2.0 * rdht ;
DPCAM3POS = [dpcam3x dpcam3y dpcamwd dpcamht] ;
dpcam4x = .98 * SCREENWD - dpcamwd;
dpcam4y = SCREENHT - 2.0 * rdht ;
DPCAM4POS = [dpcam4x dpcam4y dpcamwd dpcamht] ;

%  Individual in PCA Window Position
%
ipcawd = .85 * SCREENWD ;
ipcaht = .85 * SCREENHT ;
ipcax = 1 + .05 * SCREENWD ;
ipcay = 1 + .05 * SCREENHT ;
IPCAHANDPOS = [ipcax ipcay ipcawd ipcaht] ;




%%=====================================================================

%  Put Main Menu window on screen
%
MMHAND = figure(1) ;
          %  Use Figure 1 for Main Menu
clf ;
set(MMHAND,'Position', MMHANDPOS) ;
set(MMHAND,'NumberTitle', 'off') ; 
set(MMHAND,'Name','Cornean: Main Menu');

%  Create header text
%
titly = (2*mmhdrht/3) + nmmbutton * BUTTONHT + (nmmbutton + 1) * VERTGAP ;
titlwd = (MENUWD - 2 * HORIZGAP) ;
mmhhand = uicontrol(MMHAND,'Style','text',...
            'Position',[HORIZGAP titly titlwd (mmhdrht/3)],...
            'String','Corneal Topography Analysis System', ...	   
 	    'BackgroundColor', [0 0 0], ...
 	    'ForegroundColor', [0 1 1]);

titly = (mmhdrht/3) + nmmbutton * BUTTONHT + (nmmbutton + 1) * VERTGAP ;
mmhhand2 = uicontrol(MMHAND, 'Style','text',...
            'Position',[HORIZGAP titly titlwd (mmhdrht/3)],...
            'String','(c) J.S.Marron, N.Locantore, 1998', ...	   
 	    'BackgroundColor', [0 0 0], ...
 	    'ForegroundColor', [0 1 1]);

titly = nmmbutton * BUTTONHT + (nmmbutton + 1) * VERTGAP ;
mmhhand3 = uicontrol(MMHAND, 'Style','text',...
            'Position',[HORIZGAP titly titlwd (mmhdrht/3)],...
            'String','University of North Carolina, Chapel Hill', ...	   
 	    'BackgroundColor', [0 0 0], ...
 	    'ForegroundColor', [0 1 1]);




%  Create push button for "Create Individual Analysis Menu"
%
buttony = (nmmbutton - 1) * BUTTONHT + nmmbutton * VERTGAP ;
buttonwd = (MENUWD - 2 * HORIZGAP) ;
mmcbs1 = 'coaiam' ;
          %  Main Menu CallBack String 1: calls coaiam.m
mmb1hand = uicontrol(MMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','Go to Individual Analysis Menu',...
              'CallBack',mmcbs1) ;



%  Create push button for "Create Population Analysis Menu"
%
buttony = (nmmbutton - 2) * BUTTONHT + (nmmbutton - 1) * VERTGAP ;
mmcbs2 = 'coapam' ;
          %  Main Menu CallBack String 2: calls coapam.m
mmb2hand = uicontrol(MMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','Go to Population Analysis Menu',...
              'CallBack',mmcbs2) ;



%  Create push button for "Create Difference Analysis Menu"
%
buttony = (nmmbutton - 3) * BUTTONHT + (nmmbutton - 2) * VERTGAP ;
mmcbs3 = 'coamam' ;
          %  Main Menu CallBack String 3: calls coamam.m
mmb3hand = uicontrol(MMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','Go to Difference Analysis Menu',...
              'CallBack',mmcbs3) ;



%  Create push button for "Create Individual in Population Menu"
%
buttony = (nmmbutton - 4) * BUTTONHT + (nmmbutton - 3) * VERTGAP ;
mmcbs4 = 'coaipm' ;
          %  Main Menu CallBack String 4: calls coaipm.m
mmb4hand = uicontrol(MMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','Go to Individual in Population Menu',...
              'CallBack',mmcbs4) ;


