function [ht, dht, ddht] = rrecon(coefs, order, rgrid, angrid, rmax)
% RRECON, returns a vector of fitted coefficients for a given
%	grid of radii and angles
%
% Inputs -
%	coefs 	- the Zernike coefficients from a particular fit
%	order	- maximal order of Zernike fitting
%	rgrid	- given input grid of radius values
%	angrid	- given grid of angular values
%	rmax	- maximum radius of interest
% Output -
%	ht	- Zernike height mapping for reconstruction
%	dht	- first radial derivative mapping
%	ddht	- second radial derivative mapping
%
%  Copyright (c)  N.Locantore, 1998

%  last edited 1/22/98.

rgrid = rgrid(:);
angrid = angrid(:);

[design, ddesign, dddesign] = dradial(order, rmax, rgrid, angrid); 	
			% make Zernike values for grid

ht	= design * coefs;			% fit using existing coefs
clear design;

dht	= ddesign * coefs;			% first derivative grid
clear ddesign;

ddht	= dddesign * coefs; 			% second derivative grid
clear dddesign;

