function coaddm
% COADDM, Display, Decomposition Menu Generation for Cornean
%      Corneal Topography Analysis System, ver. 0.1
%   Creates a menu in the current Figure Window
%      Intended to be called by cornean.m
% Outputs:
%     Only graphics, in current Figure

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina


%  Set up global variables
%
%  First some general globals
global INFILESTR R0 NMAX ;
%  INFILESTR - string with input filename
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file

%  Next the paths for file control
global INDATPATH FEATMPATH ;
%  INDATPATH - path for input Keratron files
%  FEATMPATH - path for storing Zernike feature matrices

%  Next the globals for handles to figure windows and plots
global DDMHAND ;
%  DDMHAND - handle for Figure Window with Display, Decomposition Menu



%  Set Display / Decomposition Menu window and set up basics
%
if DDMHAND == [] ;          %  then need a new window
  DDMHAND = figure ;
else ;                     %  then work with existing menu
  figure(DDMHAND) ;
end ;
clf ;
set(DDMHAND,'Position',[50,200,300,200]) ;
set(DDMHAND,'Name','Display/Decomp. Menu') ;





%  Create header
%
h1s = 'Cornean: Corneal Topography Analysis System' ;
h1s = [h1s ' Display / Decompose Menu'] ;
          %  string to display as header, window size was chosen 
          %  to make this split correctly
ddmh1hand = uicontrol(DDMHAND,'Style','text','Position',[10 155 280 30],...
              'String',h1s) ;




%  Create push button for Raw Data Curvature plot
%
ddmcbs1 = 'coarawd' ;
          %  CallBack String 1: Calls coarwad.m, to construct
          %          raw data curvature plot
ddmb1hand = uicontrol(DDMHAND,'Style','push','Position',[40 95 220 20],...
              'String','Make Raw Data Curvature Map',...
              'CallBack',ddmcbs1) ;


%  Create push button for Zernike Decomposition
%
ddmcbs2 = 'coazdec' ;
          %  Display CallBack String 2: Calls coazdec for Zernike decomp.
ddmb2hand = uicontrol(DDMHAND,'Style','push','Position',[40 65 220 20],...
              'String','Make Zernike Decomposition File',...
              'CallBack',ddmcbs2) ;


%  have room for two more such buttons, 
%        at [40 35 220 20] and [40 5 220 20]





