disp('Cornean: Cornea Topography Analysis System, ver. 0.1') ;
disp('(c) J. S. Marron and N. Locantore, 1998') ;
disp('Department of Statistics, University of North Carolina') ;
disp(' ') ;
%
%    This generates main control menu of Cornean
%    Cornea Topography Analysis System,
%      for Analysis of Data Generated by the Keratron 2000
%    This system performs tasks including display of an image,
%      decomposition into Zernike feature matrices,
%      and analyis of populations of feature matrices
%



%  Set up global variables
%
%  First some general globals
global R0 NMAX RAMVCIND SMOMEAN SMOSD ;
R0 = 4.2 ;
          %  radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
NMAX = 5 ;
          %  maximum number of Zernike columns to consider
          %    this gets reloaded when a feature vec is reloaded from file
%  RAMVCIND - Vector of indicators for coefficients in our out,
%                      in manually driven reconstruction
%  SMOMEAN - mean for smoothed reconstruction
%  SMOSD - standard deviation for smoothed reconstruction

%  Next some globals for file names, etc.
global INFILESTR RFILESUF HFILESUF CFILESUF ;
%INFILESTR = '000053_1' ;    %  PRK doughnut to use as default
INFILESTR = '000121_2' ;    %  Kerataconus to use as default
          %  Prefix of filename for input data
          %           (here is a default)
RFILESUF = '.xla' ;
          %  radii data file suffix 
          %        common values are:  .xla, 
HFILESUF = '.zla' ;
          %  height data file suffix
          %        common values are:  .zla, 
CFILESUF = '.tla' ;
          %  curvature data file suffix
          %        common values are:  .tla, 

%  Next some global paths for file control
global INDATPATH FEATMPATH ;
INDATPATH = 'c:\matlab\cornean\indata\' ;
          %  path for input Keratron files
FEATMPATH = 'c:\matlab\cornean\zfm\' ;
          %  path for storing Zernike feature matrices

%  Next the globals for handles to figure windows and plots
global MMHAND DDMHAND RAMHAND RAMCBHAND RAMSL1HAND RAMSL2HAND RAMSAXHAND ;
%  MMHAND - handle for Figure Window with Main Menu
%  DDMHAND - handle for Figure Window with Display, Decomposition Menu
%  RAMHAND - handle for Figure Window with Reconstruct, Analyze Menu
%  RAMCBHAND - handle for CheckBoxes in Reconstruct, Analyze Menu
%  RAMSL1HAND - handle for Slider for Mean of smooths
%                              in Reconstruct, Analyze Menu
%  RAMSL2HAND - handle for Slider for sd of smooths
%                              in Reconstruct, Analyze Menu
%  RAMSAXHAND - handle for SmoothDemo Axis, in Reconstruct, Analyze Menu



%  Set Main Menu window and basics
%
if MMHAND == [] ;    %  then Main Menu is not up yet, so:
  MMHAND = figure ;
          %  Create a new window for Main Menu
else ;               %  then already have Main Menu up, so make it current
  figure(MMHAND) ;
end ;
clf ;
set(MMHAND,'Position',[10,240,300,260]) ;
set(MMHAND,'Name','Cornean Main Menu') ;



%  Create header text
%
mmhhand = uicontrol(MMHAND,'Style','text','Position',[10 230 280 16],...
              'String','Cornean: Corneal Topography Analysis System') ;



%  Create Editable text, for entering input Keratron data filename prefix
%
t1s = 'Enter Keratron Data File Prefix:' ;
          %  text to display in front of entry field
mmthand = uicontrol(MMHAND,'Style','text','Position',[10 180 188 20],...
              'String',t1s) ;
          %  Creation of text on Main menu, in front of entry field
mmethand = uicontrol(MMHAND,'Style','Edit',...
                    'String',INFILESTR,...
                    'Position',[200 180 70 19],...
                    'CallBack','INFILESTR = get(mmethand,''String'') ;') ;
          %  User types text into window, and then global variable
          %  "INFILESTR" contains string with filename
          %  Note: "String" is just a starting default, known to be there




%  Create push button for Create Display / Decompose Menu
%
mmcbs1 = 'coaddm' ;
          %  Main Menu CallBack String 1: calls coaddm.m
mmb1hand = uicontrol(MMHAND,'Style','push',...
              'Position',[40 125 220 20],...
              'String','Go to Display / Decompose Menu',...
              'CallBack',mmcbs1) ;



%  Create push button for Create Reconstruct Analyze Menu
%
mmcbs2 = 'coaram' ;
          %  Main Menu CallBack String 2: calls coaram.m
mmb2hand = uicontrol(MMHAND,'Style','push',...
              'Position',[40 95 220 20],...
              'String','Go to Reconstruct / Analyze Menu',...
              'CallBack',mmcbs2) ;



%  Create push button for Create Principle Component Analysis Menu
%
mmcbs3 = ['disp(''  This will create ' ...
                'Principle Component Analysis Menu'')'] ;
          %  Main Menu CallBack String 3:
          %          Create Principle Component Analysis Menu
mmb3hand = uicontrol(MMHAND,'Style','push',...
              'Position',[40 65 220 20],...
              'String','Go to Principle Component Menu',...
              'CallBack',mmcbs3) ;


%  have room for two more such buttons, 
%        at [40 35 220 20] and [40 5 220 20]


