function zchoose
% ZCHOOSE, Does reconstruction for user-specified Zernike
% 	coefficients (via gui).
%    Creates a mapping of the cornea curvature with specified
%	coefficients.  Called by coaram.m
% Outputs:
%	Graphics in figure window.

%	Copyright (c) J.S. Marron, N. Locantore, 1998
%	Department of Statistics, University of North Carolina 

%  Set up global variables
%
%  First some general globals
global MATLABVER INFILESTR R0 NMAX RAMVCIND SMOMEAN SMOSD ;
%  MATLABVER - version of Matlab, either 4 or 5
%  INFILESTR - string with input filename
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  RAMVCIND - Vector of indicators for coefficients in our out,
%                      in manually driven reconstruction
%  SMOMEAN - mean for smoothed reconstruction
%  SMOSD - standard deviation for smoothed reconstruction

%  Next the paths for file control
global FEATMPATH ;
%  FEATMPATH - path for storing Zernike feature matrices

%  Next the globals for handles to figure windows and plots
global RAMHAND RAMCBHAND RAMSL1HAND RAMSL2HAND RAMSAXHAND ;
%  RAMHAND - handle for Figure Window with Reconstruct, Analyze Menu
%  RAMCBHAND - handle for CheckBoxes in Reconstruct, Analyze Menu
%  RAMSL1HAND - handle for Slider for Mean of smooths
%                              in Reconstruct, Analyze Menu
%  RAMSL2HAND - handle for Slider for sd of smooths
%                              in Reconstruct, Analyze Menu
%  RAMSAXHAND - handle for SmoothDemo Axis, in Reconstruct, Analyze Menu



fvfilestr = [FEATMPATH INFILESTR '.mat'] ;  
eval(['load ' fvfilestr]) ;
vmask = [] ;

for neven = 0:2:NMAX-1 ;
  	i0freq = neven/2 * (neven/2 + 1) + 1 ;
  	submask = RAMVCIND(i0freq:(i0freq + neven + 1)) ;
  	submask = ones(2,1) * submask' ;
  	submask = reshape(submask,2 * neven + 4,1) ;           
  	submask = submask(2:length(submask)) ;
  	vmask = [vmask; submask] ;
	end ; 

if floor(NMAX/2) == NMAX/2 ;
  	i0freq = NMAX/2 * (NMAX/2 + 1) + 1 ;
  	submask = RAMVCIND(i0freq:(i0freq + floor(NMAX/2))) ;
  	submask = ones(2,1) * submask' ;
  	submask = reshape(submask,2 * (floor(NMAX/2)+1),1) ;
  	submask = submask(2:length(submask)) ;
 	vmask = [vmask; submask] ;
	end ;

betahat = betahat .* vmask ;
coazrec(betahat) ;
    	titstr = ['Chosen Zernikes for ' INFILESTR] ;
  	title(titstr) ;

hold on ;
  	trigap = .02 * (2 * R0) ;
  	trilength = .2 * (2 * R0) ;
  	trijump = trilength / NMAX ;
  	tristartx = R0 - trigap - trilength ;
  	tristarty = R0 - trigap ;
  	i = 0 ;
  	for n = 0:NMAX ;
    		if n/2 == round(n/2) ;
      			mstart = 0 ;
    		else ;
      			mstart = 1 ;
    			end ;
    		mend = n ;
    		for m = mstart:2:mend ;
      			i = i + 1 ;
      			flag = RAMVCIND(i) ;
      			xpt = tristartx + n * trijump ; 
      			ypt = tristarty - m * trijump ; 
      			if flag == 0 ;
        			plot(xpt,ypt,'.b') ;
      			else ;
        			plot(xpt,ypt,'.y') ;
      			end ;
      			vh = get(gca,'Children') ;
                        if MATLABVER == 4 ;
      			  set(vh(1),'MarkerSize',15) ;
                        elseif MATLABVER == 5 ;
                          set(vh(length(vh)),'MarkerSize',15) ;
                                %  because "most recent" seems to
                                %  at the end in MATALB 5
                        end ;
          end ;
  		end ;
hold off ;

          %  Callback String for termwise reconstruction
          %    vmask -  vector of "weights" for coefficients
          %                 (same size as full feature vector)
          %    neven - index of blocks of even and odd frequencies
          %    i0freq -  index (in RAMVCIND scheme) of 0 freq coeff
          %  last block creates triangle of indicators, showing which
          %      boxes were checked
