function coalwzrp
% COALWZRP, Does print of List Wise Zernike reconstruction
%      Corneal Topography Analysis System
%   Creates a color postscript file, of
%   large size window with several pages of List Wise Zernike recon's
%      Intended to be called by coapam.m
% Outputs:
%     Postscript file in directory ~cornean\outputs

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina




%  Set up global variables
%
global VLWZRHAND LISTFILESTR ;
%  VLWZRHAND - vector of handles for List-Wise Zernike Recon's
%  LISTFILESTR - Input list file name




if isempty(VLWZRHAND) ;
        %  then VLWZR window not yet created,
        %  so give error message

  disp('   ') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
  disp('!!!   Can''t print Listwise Zernike Decomp. plot,') ;
  disp('!!!   since no such windows open yet') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

else ;  %  then have done the analysis, so print result

  for iplot = 1:length(VLWZRHAND) ;
    
    curhand = VLWZRHAND(iplot) ;
    figure(curhand) ;

    orient landscape ;
    eval(['print outputs\' LISTFILESTR num2str(iplot) '.ps -dpsc']) ;

  end ;


  disp('  Finsished Creating Postscript files for ') ;
  disp(['    listwise reconstruction of list file: ' LISTFILESTR]) ;

end ;

