function coapam
% COAPAM, Population Analysis Menu Generation for Cornean
%      Corneal Topography Analysis System
%   Creates a menu in the current Figure Window
%      Intended to be called by cornean.m
% Outputs:
%     Only graphics, in current Figure

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina


%  Set up global variables
%
%  First some general globals
global LISTFILESTR SETLISTPATH LISTR R0 NMAX COMAP NRPT ;
%  LISTFILESTR - string with input name of file with list of filenames
%  LISTR - string for inputting list file
%  SETLISTPATH - string to set path to lists
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  COMAP - Color Map
%  NRPT - Number of times to Repeat Movie
global SCREENWD SCREENHT MENUWD ;
        % overall sizes of display area, generic menu width
global VERTGAP HORIZGAP TITLHT BUTTONHT
        %  generic sizes of objects on menus

%  Next the path for file control
global FEATMPATH ;
%  FEATMPATH - path for storing Zernike feature matrices

%  Next the globals for handles to figure windows and plots
global PAMHAND PAMHANDPOS PAMETHAND VLWZRHAND ;
%  PAMHAND - handle for Figure Window with Individual Analysis Menu
%  PAMHANDPOS - Position coordinates for Individual Analysis Menu
%  PAMETHAND - handle for editable text, with input file prefix
%  VLWZRHAND - vector of handles for List-Wise Zernike Recon's
global DPCAHANDPOS DPCAM1POS DPCAM2POS DPCAM3POS DPCAM4POS SPCAHANDPOS ;
%  DPCAHANDPOS - Position coordinates for Movie Control Menu
%  DPCAM1POS - Position coordinates for PCA Movie 1
%  DPCAM2POS - Position coordinates for PCA Movie 2
%  DPCAM3POS - Position coordinates for PCA Movie 3
%  DPCAM4POS - Position coordinates for PCA Movie 4
%  SPCAHANDPOS - Position coordinates for Static PCA plot
global LWZRHANDPOS ;
%  LWZRHANDPOS - Position coordinates for List-Wise Zernike recons
global DPCAM1HAND DPCAM2HAND DPCAM3HAND DPCAM4HAND SPCAHAND ;
        %  Handles for movie windows in Dynamic and Static PC Analysis
global DPCAM1 DPCAM2 DPCAM3 DPCAM4 ;
        %  Movie matrices in Dynamic PC Analysis
global RFILESUF HFILESUF ;
        %  File Suffixes for data files


%  Initialize list path, in case default is unacceptable
%
eval(SETLISTPATH) ;




%  Create Population Analysis Menu window and set up basics
%
if isempty(PAMHAND) ;          %  then need a new window
  PAMHAND = figure ;
else ;                     %  then work with existing menu
  figure(PAMHAND) ;
end ;
clf ;
set(PAMHAND, 'NumberTitle', 'off');
set(PAMHAND,'Position', [PAMHANDPOS]) ;
set(PAMHAND,'Name','Pop''n An. Menu (Don''t Close)') ;





%  Create header
%
titly = PAMHANDPOS(4) - (TITLHT + VERTGAP) ;
          %  get y coord of starting point working down from top
titlwd = (MENUWD - 2 * HORIZGAP) ;
h1s = 'Corneal Topography Analysis System' ;
          %  string to display as header, window size was chosen 
          %  to make this split correctly
pamh1hand = uicontrol(PAMHAND,'Style','text',...
            'Position',[HORIZGAP titly titlwd TITLHT],...
            'String',h1s, 'BackgroundColor', [0 0 0], ...
 	    'ForegroundColor', [0 1 1]);



%  Create Editable text, for entering input Keratron data filename prefix
%
t1s = 'File List Prefix:' ;
          %  text to display in front of entry field
twd = PAMHANDPOS(3) - 2 * HORIZGAP ;
          %  total width for this field
twd1 = .7 * twd ;
twd2 = .3 * twd ;
          %  respective parts for the label and editable text
ty = PAMHANDPOS(4) - (TITLHT + BUTTONHT + 2 * VERTGAP) ;
          %  get y coord of starting point working down from top
pamthand = uicontrol(PAMHAND,'Style','text',...
              'Position',[HORIZGAP ty twd1 BUTTONHT],...
              'String',t1s) ;
          %  Creation of text on Main menu, in front of entry field
PAMETHAND = uicontrol(PAMHAND,'Style','Edit',...
                    'String',LISTFILESTR,...
                    'Position',[(HORIZGAP + twd1) ty twd2 BUTTONHT],...
                    'CallBack',['LISTFILESTR = get(PAMETHAND,''String'') ;',...
                    'eval(SETLISTPATH) ;']) ;
          %  User types text into window, and then global variable
          %  "LISTFILESTR" contains string with filename
          %  Note: "String" is just a starting default, known to be there



%  Create push button for "Input List File Directory"
%
buttony = PAMHANDPOS(4) - (TITLHT + 2 * BUTTONHT + 3 * VERTGAP) ;
          %  get y coord of starting point working down from top
buttonwd = .3 * (MENUWD - 2 * HORIZGAP) ;
          %  only use 30% of usual width
pamcbs1 = ['disp(''Current List Files:'') ;'...
            'dir ' FEATMPATH '*.lst ;'] ;
          %  Population Analysis CallBack String 1: 
          %  shows currently available list files
mmb1hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','see Dir.',...
              'CallBack',pamcbs1) ;



%  Create push button for "Help"
%
buttonx = HORIZGAP + .7 * (MENUWD - 2 * HORIZGAP) ;
buttonwd = .3 * (MENUWD - 2 * HORIZGAP) ;
          %  only use 30% of usual width
pamcbs2 = ['disp(''      The field "File List Prefix:"'') ;'...
           'disp(''      needs to have the prefix of a file where '') ;'...
           'disp(''      ________.lst is in the "zfm" directory '') ;'...
           'disp('' '') ;'] ;
          %  Population Analysis CallBack String 1: 
          %  give some advice about file storage
mmb2hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[buttonx buttony buttonwd BUTTONHT],...
              'String','Help',...
              'CallBack',pamcbs2) ;



%  Create push button for Listwise Zernike Decomposition
%
buttony = PAMHANDPOS(4) - (TITLHT + 3 * BUTTONHT + 4 * VERTGAP) ;
          %  get y coord of starting point working down from top
buttonwd = MENUWD - 2 * HORIZGAP ;
%ddmcbs4 = 'disp(''listwise decomp. not ready yet'') ;' ;
ddmcbs4 = 'coalwzd' ;
          %  CallBack String 4: Calls coalwzd.m, for
          %          list-wise Zernike Decomp.
pamb4hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','Listwise Zernike Decomp.',...
              'CallBack',ddmcbs4) ;




%  Create push button for listwise recon. plot
%
buttony = PAMHANDPOS(4) - (TITLHT + 4 * BUTTONHT + 5 * VERTGAP) ;
          %  get y coord of starting point working down from top
twd = MENUWD - 2 * HORIZGAP ;
          %  total width for this field
bwd1 = .45 * twd ;
bgap = .1 * twd ;
bwd2 = .45 * twd ;
          %  respective parts for the left and right buttons
ddmcbs5 = 'coalwzr' ;
          %  CallBack String 5: Calls coalwzr.m, for
          %          list-wise Zernike reconstruction
pamb5hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[HORIZGAP buttony bwd1 BUTTONHT],...
              'String','Show Recons',...
              'CallBack',ddmcbs5) ;
ddmcbs6 = 'coalwzrp' ;
          %  CallBack String 6: Calls coalwrzp.m, for making print of
          %          list-wise Zernike reconstruction
pamb6hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[(HORIZGAP+bwd1+bgap) buttony bwd2 BUTTONHT],...
              'String','Print (.ps)',...
              'CallBack',ddmcbs6) ;





%  Create push button for Static PCA plot
%
buttony = PAMHANDPOS(4) - (TITLHT + 5 * BUTTONHT + 6 * VERTGAP) ;
          %  get y coord of starting point working down from top
twd = MENUWD - 2 * HORIZGAP ;
          %  total width for this field
bwd1 = .45 * twd ;
bgap = .1 * twd ;
bwd2 = .45 * twd ;
          %  respective parts for the left and right buttons
ddmcbs1 = 'coaspca' ;
          %  CallBack String 1: Calls coaspca.m, for
          %          static principal component analysis 
pamb1hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[HORIZGAP buttony bwd1 BUTTONHT],...
              'String','Static PCA',...
              'CallBack',ddmcbs1) ;
ddmcbs2 = 'coaspcap' ;
          %  CallBack String 2: Calls coaspcap.m, for making print of
          %          static principal component analysis 
pamb2hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[(HORIZGAP+bwd1+bgap) buttony bwd2 BUTTONHT],...
              'String','Print (.ps)',...
              'CallBack',ddmcbs2) ;


%  Create push button for Dynamic PCA plots
%
buttony = PAMHANDPOS(4) - (TITLHT + 6 * BUTTONHT + 7 * VERTGAP) ;
          %  get y coord of starting point working down from top
buttonwd = MENUWD - 2 * HORIZGAP ;
ddmcbs3 = 'coadpca' ;
          %  CallBack String 3: Calls coadpca.m, for
          %          dynamic principal component analysis 
pamb3hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','Dynamic PCA (movies)',...
              'CallBack',ddmcbs3) ;


%  Create push button to save Dynamic PCA plots in Mpeg form
%
buttony = PAMHANDPOS(4) - (TITLHT + 7 * BUTTONHT + 8 * VERTGAP) ;
          %  get y coord of starting point working down from top
buttonwd = MENUWD - 2 * HORIZGAP ;
bgap = .1 * twd ;
bwd = twd - 2* bgap ;
ddmcbs4 = 'coadpcas' ;
          %  CallBack String 4: Calls coadpcas.m, for saving
          %          dynamic principal component analysis 
          %          movies as mpeg files
pamb4hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[(HORIZGAP + bgap) buttony bwd BUTTONHT],...
              'String','Save Movies to files (.mpg)',...
              'CallBack',ddmcbs4) ;

