%%=====================================================================
%%  This should take care of the jockeying back and forth 
%%  between the PC and UNIX environment, and differences in 
%%  paths for users.

global R0 NMAX;
	% R0, Maximum radius and NMAX, maximum zernike order for analysis
global INFILESTR RFILESUF HFILESUF CFILESUF;
global RISTR HISTR CISTR INDATPATH FEATMPATH;
global MMHANDPOS DDMHANDPOS RAMHANDPOS RDHANDPOS PMAPHANDPOS;
	% Figure window positioning handles

ipath = 1;	%%  1 -- denotes file path for Marron
		%%  2 -- denotes file path for Locantore
		%%  more here as necessary

imonitor = 2;	%%  1 -- denotes monitor for 13" PC
		%%  2 -- denotes monitor for Sun Workstation
		%%  more here as necessary

%%=====================================================================

if ipath == 1;
%  General globals
	NMAX = 5 ;
          %  maximum order of Zernikes to use
	R0 = 4.2 ;
          %  radius of analysis
          %    these get reloaded when a feature vec is reloaded from file

	INFILESTR = '000121_2' ;    
          %  default file name for input         
	RFILESUF = '.xla' ;
          %  radii data file suffix 
	HFILESUF = '.zla' ;
          %  height data file suffix
	CFILESUF = '.tla' ;
          %  curvature data file suffix

	global INDATPATH FEATMPATH ;
	INDATPATH = 'c:\matlab\cornean\indata\' ;
          %  path for input Keratron files
	FEATMPATH = 'c:\matlab\cornean\zfm\' ;
          %  path for storing Zernike feature matrices

	RISTR = [INDATPATH INFILESTR RFILESUF] ;
	HISTR = [INDATPATH INFILESTR HFILESUF] ;
	CISTR = [INDATPATH INFILESTR CFILESUF] ;
          %  Set full filenames



	end;

%%--------------------------------------------------------------------

elseif ipath == 2;
%  General globals
	NMAX = 8 ;
  	  %  maximum number of Zernikes to use	
	R0 = 4.2 ;
          %  radius of analysis
          %    these get reloaded when a feature vec is reloaded from file

	INFILESTR = '1212' ;   
          %  default file name for input   
	RFILESUF = 'xla' ;
          %  radii data file suffix 
   	HFILESUF = 'zla' ;
          %  height data file suffix
   	CFILESUF = 'tla' ;
          %  curvature data file suffix

	global INDATPATH FEATMPATH ;
	INDATPATH = '/home/Mickey/students/tzhang/project/corneal/dat/' ;
          %  path for input Keratron files
	FEATMPATH = '/home/Mickey/students/locantor/cornean/zfm/' ;
          %  path for storing Zernike feature matrices

	RISTR = [INDATPATH RFILESUF INFILESTR '.dat'] ;
	HISTR = [INDATPATH HFILESUF INFILESTR '.dat'] ;
	CISTR = [INDATPATH CFILESUF INFILESTR '.dat'] ;
          %  Set full filenames

	end;

%%=====================================================================if imonitor == 1;
	MMHANDPOS   = [10,240,300,260] ;
	DDMHANDPOS  = [50,200,300,200] ;
	RAMHANDPOS  = [90,20,490,340];
	RDHANDPOS   = [400,200,200,200] ; 
	PMAPHANDPOS = [20,20,120,80];
	end;

elseif imonitor == 2;
	MMHANDPOS   = [10,650,300,260] ;
	DDMHANDPOS  = [10,420,300,160] ;
	RAMHANDPOS  = [10,220,490,340];
	RDHANDPOS   = [330,650,250,250] ; 
	PMAPHANDPOS = [600,650,200,200];
	end;

%%=====================================================================

cornean;

