function coabar(axhand,vy,colorstr,top) ;
% COABAR Draws Colored Bar Graph
%      Corneal Topography Analysis System
%   Draws, in the axis, with handle "axhand", a bar graph, with
%   read in bar heights.  Bars are then shaded in, using the given 
%   color.
%      Intended to be called by coazrec.m
% Inputs:
%       axhand - handle of an existing axis, where bar graph
%                   is to be drawn
%       vy - vector of heights for bars, assumed to lie in the range [0,top].
%                   length also gives number of bars, 
%       colorstr - string containing a color to shade the bars with
%                   (must be a "usual color", such as 'r', 'b', etc.)
%       top - gives upper bound on graph (lower bound will be 0),
%                   hence use 1 for proportions, and 100 for percentages,
%                   if unspecified, will use 1.05 * max(vy)
% Output:
%       Only a bar graph in the axis with handle "axhand"

%    Copyright (c) J. S. Marron, N. Locantore 1998
%    Department of Statistics, University of North Carolina


if nargin == 3 ;  %  then no top specified, so get from y
  itop = 1.1 * max(vy) ;
else ;            %  top was specified, so use that
  itop = top ;
end ;


%  Set up local parameters
%
nbar = length(vy) ;
left = 0.5 ;
right = nbar + 0.5 ;
bottom = 0 ;


%  Make input axes the current one
%
axes(axhand) ;


%  Build shading info
%
[xx,yy] = bar(vy) ;
%xx
%yy
xpatch = reshape(xx(2:(5*nbar+1)),5,nbar) ;
xpatch = xpatch(1:4,:) ;
ypatch = reshape(yy(2:(5*nbar+1)),5,nbar) ;
ypatch = ypatch(1:4,:) ;



%  Do main plot
%
plot(xx,yy,colorstr) ;
  axis([left right bottom itop]) ;
  patch(xpatch,ypatch,colorstr) ;
          %  This colors the bars
  hold on ;
    plot([left,right],[bottom,bottom],'w') ;
  hold off ;
          %  Redraw the x axis



