function coaiam
% COAIAM, Individual Analysis Menu Generation for Cornean
%      Corneal Topography Analysis System
%   Creates a menu in the current Figure Window
%      Intended to be called by cornean.m
% Outputs:
%     Only graphics, in current Figure

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina


%  Set up global variables
%
%  First some general globals
global INFILESTR SETPATHSTR R0 NMAX CRAD CANG COMAP ;
%  INFILESTR - string with input filename
%  SETPATHSTR - string to set paths
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  CRAD - radius of recentering (read in as editable text)
          %    this gets reloaded when a feature vec is reloaded from file
%  CANG - angle of recentering (read in as editable text)
          %    this gets reloaded when a feature vec is reloaded from file
%  COMAP - Color Map

global SCREENWD SCREENHT MENUWD ;
        % overall sizes of display area, generic menu width
global VERTGAP HORIZGAP TITLHT BUTTONHT
        %  generic sizes of objects on menus

%  Next the paths for file control
global INDATPATH FEATMPATH OUTPUTPATH ;
%  INDATPATH - path for input Keratron files
%  FEATMPATH - path for storing Zernike feature matrices
%  OUTPUTPATH - path for output, .ps files, .mpeg files

%  Next the globals for handles to figure windows and plots
global IAMHAND IAMHANDPOS IAMETHAND IAMETRHAND IAMETAHAND ;
%  IAMHAND - handle for Figure Window with Individual Analysis Menu
%  IAMHANDPOS - Position coordinates for Individual Analysis Menu
%  IAMETHAND - handle for editable text, with input file prefix
%  IAMETRHAND - handle for editable text, with input recentering radius
%  IAMETAHAND - handle for editable text, with input recentering angle


%  Set default recentering at the origin
%
CRAD = 0 ;
CANG = 0 ;



%  Create Individual Analysis Menu window and set up basics
%
if isempty(IAMHAND) ;          %  then need a new window
  IAMHAND = figure ;
else ;                     %  then work with existing menu
  figure(IAMHAND) ;
end ;
clf ;
set(IAMHAND, 'NumberTitle', 'off');
set(IAMHAND,'Position', [IAMHANDPOS]) ;
set(IAMHAND,'Name','Indiv. An. Menu') ;





%  Create header
%
titly = IAMHANDPOS(4) - (TITLHT + VERTGAP) ;
          %  get y coord of starting point working down from top
titlwd = (MENUWD - 2 * HORIZGAP) ;
h1s = 'Corneal Topography Analysis System' ;
          %  string to display as header, window size was chosen 
          %  to make this split correctly
ddmh1hand = uicontrol(IAMHAND,'Style','text',...
            'Position',[HORIZGAP titly titlwd TITLHT],...
            'String',h1s, 'BackgroundColor', [0 0 0], ...
 	    'ForegroundColor', [0 1 1]);



%  Create Editable text, for entering input Keratron data filename prefix
%
t1s = 'Keratron Data File Prefix:' ;
          %  text to display in front of entry field
twd = IAMHANDPOS(3) - 2 * HORIZGAP ;
          %  total width for this field
twd1 = .7 * twd ;
twd2 = .3 * twd ;
          %  respective parts for the label and editable text
ty = IAMHANDPOS(4) - (TITLHT + BUTTONHT + 2 * VERTGAP) ;
          %  get y coord of starting point working down from top
iamthand = uicontrol(IAMHAND,'Style','text',...
              'Position',[HORIZGAP ty twd1 BUTTONHT],...
              'String',t1s) ;
          %  Creation of text on Main menu, in front of entry field
IAMETHAND = uicontrol(IAMHAND,'Style','Edit',...
                    'String',INFILESTR,...
                    'Position',[(HORIZGAP + twd1) ty twd2 BUTTONHT],...
                    'CallBack',['INFILESTR = get(IAMETHAND,''String'') ;',...
                    'eval(SETPATHSTR) ;']) ;
          %  User types text into window, and then global variable
          %  "INFILESTR" contains string with filename
          %  Note: "String" is just a starting default, known to be there



%  Create push button for "Input Data File Directory"
%
buttony = IAMHANDPOS(4) - (TITLHT + 2 * BUTTONHT + 3 * VERTGAP) ;
          %  get y coord of starting point working down from top
buttonwd = .3 * (MENUWD - 2 * HORIZGAP) ;
          %  only use 30% of usual width
iamcbs1 = 'disp(''Contents of "indata" directory:'') ; dir indata ;' ;
          %  Individual Analysis CallBack String 1: 
          %  shows contents of input data directory 
mmb1hand = uicontrol(IAMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','see Dir.',...
              'CallBack',iamcbs1) ;



%  Create push button for "Help"
%
buttonx = HORIZGAP + .7 * (MENUWD - 2 * HORIZGAP) ;
buttonwd = .3 * (MENUWD - 2 * HORIZGAP) ;
          %  only use 30% of usual width
iamcbs2 = ['disp(''      The field "Keratron Data File Prefix"'') ;'...
           'disp(''      needs to have the prefix of a file that '') ;'...
           'disp(''      is in the "indata" directory '') ;'...
           'disp('' '') ;'] ;
          %  Individual Analysis CallBack String 1: 
          %  give some advice about file storage
mmb1hand = uicontrol(IAMHAND,'Style','push',...
              'Position',[buttonx buttony buttonwd BUTTONHT],...
              'String','Help',...
              'CallBack',iamcbs2) ;



%  Create push button for Raw Data Curvature plot
%
buttony = IAMHANDPOS(4) - (TITLHT + 3 * BUTTONHT + 4 * VERTGAP) ;
          %  get y coord of starting point working down from top
buttonwd = MENUWD - 2 * HORIZGAP ;
ddmcbs1 = 'coarawd' ;
          %  CallBack String 1: Calls coarawd.m, to construct
          %          raw data curvature plot
ddmb1hand = uicontrol(IAMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','Make Raw Data Curvature Map',...
              'CallBack',ddmcbs1) ;



% Put line between sections
%
ly = IAMHANDPOS(4) - (TITLHT + 2 + 3 * BUTTONHT + 5 * VERTGAP) ;
          %  get y coord of starting point working down from top
line1hand = uicontrol(IAMHAND,'Style','text',...
            'Position',[1 ly IAMHANDPOS(3) 2],...
            'BackgroundColor', [0 0 .5]) ;
           %  Create line between simple recon, and smoothed recon
%%--------------------------------------------------------------------



%  Create Editable text for recentering coordinates
%
t2s = 'Recenter, Radius:' ;
          %  text to display in front of entry field
t3s = 'Angle:' ;
twd = IAMHANDPOS(3) - 2 * HORIZGAP ;
          %  total width for this field
twd1 = .5 * twd ;
twd2 = .15 * twd ;
twd3 = .2 * twd ;
twd4 = .15 * twd ;
          %  respective parts for the label and editable text
ty = IAMHANDPOS(4) - (TITLHT + 2 + 4 * BUTTONHT + 6 * VERTGAP) ;
          %  get y coord of starting point working down from top
iamtrhand = uicontrol(IAMHAND,'Style','text',...
              'Position',[HORIZGAP ty twd1 BUTTONHT],...
              'String',t2s) ;
          %  Creation of text on Main menu, in front of entry field
et2cbstr = ['CRAD = str2num(get(IAMETRHAND,''String'')) ;'] ;
IAMETRHAND = uicontrol(IAMHAND,'Style','Edit',...
                    'String',num2str(CRAD),...
                    'Position',[(HORIZGAP + twd1) ty twd2 BUTTONHT],...
                    'CallBack',et2cbstr) ;
          %  User types text into window, and then global variable
          %  "CRAD" gets string turned into a number
iamtahand = uicontrol(IAMHAND,'Style','text',...
              'Position',[(HORIZGAP + twd1 + twd2) ty twd3 BUTTONHT],...
              'String',t3s) ;
          %  Creation of text on Main menu, in front of entry field
et3cbstr = ['CANG = str2num(get(IAMETAHAND,''String'')) ;'] ;
IAMETAHAND = uicontrol(IAMHAND,'Style','Edit',...
                    'String',num2str(CANG),...
                    'Position',[(HORIZGAP + twd1 + twd2 + twd3) ty twd4 BUTTONHT],...
                    'CallBack',et3cbstr) ;
          %  User types text into window, and then global variable
          %  "CANG" gets string turned into a number



%  Create push button for Zernike Decomposition
%
buttony = IAMHANDPOS(4) - (TITLHT + 2 + 5 * BUTTONHT + 7 * VERTGAP) ;
          %  get y coord of starting point working down from top
buttonwd = MENUWD - 2 * HORIZGAP ;
ddmcbs3 = ['coazdec ;' ...
           'disp([''    Finished Zernike Decomposition for '' INFILESTR]) ;'] ;
          %  Display CallBack String 3: Calls coazdec for Zernike decomp.
ddmb3hand = uicontrol(IAMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','Perform Zernike Decomposition',...
              'CallBack',ddmcbs3) ;

%  Create push button for Radial Decomposition
%
buttony = IAMHANDPOS(4) - (TITLHT + 6 * BUTTONHT + 8 * VERTGAP) ;
          %  get y coord of starting point working down from top
buttonwd = MENUWD - 2 * HORIZGAP ;
          %  only use 30% of usual width
iamcbs3 = ['coardec ;' ...
           'disp([''    Finished Radial Decomposition for '' INFILESTR]) ;'] ;
          %  Display CallBack String 3: Calls coardec for Radial decomp.

mmb1hand = uicontrol(IAMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','Perform Radial Decomposition',...
              'CallBack',iamcbs3) ;


% Put line between sections
%
ly = IAMHANDPOS(4) - (TITLHT + 2*2 + 6 * BUTTONHT + 9 * VERTGAP) ;
          %  get y coord of starting point working down from top
line2hand = uicontrol(IAMHAND,'Style','text',...
            'Position',[1 ly IAMHANDPOS(3) 2],...
            'BackgroundColor', [0 0 .5]) ;
           %  Create line between simple recon, and smoothed recon
%%--------------------------------------------------------------------

%  Create pushbutton to go to Reconstruct Analyze Menu
%
buttony = IAMHANDPOS(4) - (TITLHT + 2*2 + 7 * BUTTONHT + 10 * VERTGAP) ;
          %  get y coord of starting point working down from top
buttonwd = MENUWD - 2 * HORIZGAP ;
ddmcbs4 = 'coarampk' ;
          %  Display CallBack String 4: Calls coaram for Recon./Anal. Menu
ddmb4hand = uicontrol(IAMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','Go to Reconst. / Analyze Menu',...
              'CallBack',ddmcbs4) ;




%
