function coaspca
% COASPCA, Does Static Principal Component Analysis
%      Corneal Topography Analysis System
%   Creates a laege size window with one page PCA
%      Intended to be called by coapam.m
%      Reads list of files from LISTFILESTR
% Outputs:
%     Only graphics, in current Figure

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina




%  Set local parameters
%
ngrid = 64 ;     %  Construct surfaces as ngrid x ngrid array
    


%  Set up global variables
%
%  First some general globals
global R0 NMAX COMAP ;
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  COMAP - Color Map
global SPCAHANDPOS LISTFILESTR SPCAHAND ;
        %  window positioning vector,
        %  list file string
        %  handle for Static PCA Window



%  Read in matrix of Zernike feature coefficients
%
mfv = coaflr ;
d = size(mfv,1) ;
n = size(mfv,2) ;



%  Calculate grid quantities
%
xgrid = linspace(-R0, R0, ngrid) ;
ygrid = xgrid ;	        %  Vectors of image coordinate values 
[mxgrid, mygrid] = meshgrid(xgrid,ygrid) ;
              		%  Matrices of image coordinate values 



%  Do Principal Components
%
sst = sum(sum(mfv.^2)) ;
%  get mean feature vector, and resids from that
vmean = mean(mfv')' ;
vsd = std(mfv')' ;
ssm = n * sum(vmean.^2) ;
ssmr = sst - ssm ;
mresid = mfv - vec2mat(vmean,n) ;

%  Get cov's and eigen values
mcov = cov(mresid') ;
          %  Get covariance matrix, transpose, since want "coordinates
          %                      as variables"

[meigvec,meigval] = eig(mcov) ;
veigval = (diag(meigval)) ;
          %  Get eigenvalues and eigenvectors

[veigval,vind] = sort(veigval) ;
meigvec = meigvec(:,vind) ;
          %  Sort to avoid possible ordering problems
  
ev1 = meigvec(:,d) ;
          %  eigenvector with largest eigenvalue
pc1 = mresid' * ev1 ;
          %  vector of projections of data onto ev1
pc1rep = max(abs(pc1 - mean(pc1))) ;
          %  "most representative pc", defined as MAD
mpc1 = ev1 * pc1rep ;
          %  "average vector" for display
mresid1 = (mresid - ev1 * pc1') ;
ss1r = sum(sum(mresid1.^2)) ;
ss1 = ssmr - ss1r ;

ev2 = meigvec(:,d-1) ;
          %  eigenvector with largest eigenvalue
pc2 = mresid1' * ev2 ;
          %  vector of projections of data onto ev2
pc2rep = max(abs(pc2 - mean(pc2))) ;
          %  "most representative pc", defined as MAD
mpc2 = ev2 * pc2rep ;
          %  "average vector" for display
mresid2 = (mresid1 - ev2 * pc2') ;
ss2r = sum(sum(mresid2.^2)) ;
ss2 = ss1r - ss2r ;

ev3 = meigvec(:,d-2) ;
          %  eigenvector with largest eigenvalue
pc3 = mresid2' * ev3 ;
          %  vector of projections of data onto ev3
pc3rep = max(abs(pc3 - mean(pc3))) ;
          %  "most representative pc", defined as MAD
mpc3 = ev3 * pc3rep ;
          %  "average vector" for display
mresid3 = (mresid2 - ev3 * pc3') ;
ss3r = sum(sum(mresid3.^2)) ;
ss3 = ss2r - ss3r ;

ev4 = meigvec(:,d-3) ;
          %  eigenvector with largest eigenvalue
pc4 = mresid3' * ev4 ;
          %  vector of projections of data onto ev4
pc4rep = max(abs(pc4 - mean(pc4))) ;
          %  "most representative pc", defined as MAD
mpc4 = ev4 * pc4rep ;
          %  "average vector" for display
mresid4 = (mresid3 - ev4 * pc4') ;
ss4r = sum(sum(mresid4.^2)) ;
ss4 = ss3r - ss4r ;


%  Form mean +- representative eigenvectors
mpc1p = vmean + mpc1 ;
mpc1m = vmean - mpc1 ;
mpc2p = vmean + mpc2 ;
mpc2m = vmean - mpc2 ;
mpc3p = vmean + mpc3 ;
mpc3m = vmean - mpc3 ;
mpc4p = vmean + mpc4 ;
mpc4m = vmean - mpc4 ;




%  Create images
%
imm = coazr(vmean) ;
impc1p = coazr(mpc1p) ;
impc1m = coazr(mpc1m) ;
impc2p = coazr(mpc2p) ;
impc2m = coazr(mpc2m) ;
impc3p = coazr(mpc3p) ;
impc3m = coazr(mpc3m) ;
impc4p = coazr(mpc4p) ;
impc4m = coazr(mpc4m) ;




%  Set up window page
%
SPCAHAND = figure ;
          %  create a new window
set(SPCAHAND, 'NumberTitle', 'off');
set(SPCAHAND,'Position', SPCAHANDPOS) ;
set(SPCAHAND,'Name','Static PCA') ;



%  Put down plots in 4 x 4 array
%
%  Means first
%
for i = 1:4 ;
  subplot(4,4,4+i) ;
  pcolor(mxgrid,mygrid,imm) ;
    shading flat ;
    axis('square') ;
    title(['mean, ' LISTFILESTR]) ;
      caxis([0 1]) ;
    colormap(COMAP) ;
  hold on ;
    tx = -.95 * R0 ;
    ty = .7 * R0 ;
    eval(['pcss = 100 * ss' num2str(i) ' / ssmr ;']) ;
    ssstr = num2str(pcss) ;
    tstr = [ssstr '% of MR'] ;
    text(tx,ty,tstr) ;
  hold off ;
end ;


%  Now mean +- Pc's
%
for i = 1:4 ;
  subplot(4,4,i) ;
  eval(['pcolor(mxgrid,mygrid,impc' num2str(i) 'p)']) ;
    shading flat ;
    axis('square') ;
    title(['mean + PC' num2str(i)]) ;
      caxis([0 1]) ;
    colormap(COMAP) ;

  subplot(4,4,8+i) ;
  eval(['pcolor(mxgrid,mygrid,impc' num2str(i) 'm)']) ;
    shading flat ;
    axis('square') ;
    title(['mean - PC' num2str(i)]) ;
      caxis([0 1]) ;
    colormap(COMAP) ;
end ;


%  Now do kde's
%
for i = 1:4 ;
  subplot(4,4,12+i) ;
  eval(['[kde, xgrid] = gpkde(pc' num2str(i)  ') ;']) ;
  plot(xgrid,kde,'w') ;
    title('Projections') ;
    vlim = axis ;
          %  Get axis values for drawing vertical lines
    eval(['left = -pc' num2str(i) 'rep ;']) ;
    eval(['right = pc' num2str(i) 'rep ;']) ;
    range = right - left ;
    left = left - .05 * range ;
    right = right + .05 * range ;
    bottom = vlim(3) ;
    top = vlim(4) ;
    axis([left right bottom top]) ;
    hold on ;
      evstr = ['plot([pc' num2str(i) ' pc' num2str(i) ...
                    '], [bottom top], ''c'') ;'] ;
      eval(evstr) ;
          %  Show locations of projections
      plot(xgrid,kde,'w') ;
          %  Do a replot to ensure seeing kde
    hold off ;
end ;




%  Add a title
%
tx = 0.05 ;
ty = 0.94 ;
tw = 0.8 ;
th = 0.05 ;
          %  set position for new axes, containing only title
axes('Position',[tx,ty,tw,th]) ;
          %  create new axes
set(gca,'XTickLabelMode','manual') ;
set(gca,'XTickLabel',[]) ;
set(gca,'XTickMode','manual') ;
set(gca,'XTick',[]) ;
set(gca,'XColor',[0,0,0]) ;
set(gca,'YTickLabelMode','manual') ;
set(gca,'YTickLabel',[]) ;
set(gca,'YTickMode','manual') ;
set(gca,'YTick',[]) ;
set(gca,'YColor',[0,0,0]) ;
          %  Switch off axis stuff
set(gca,'visible','off') ;
          %  Turn off surrounding box
titstr = ['Static PCA for file list: ' LISTFILESTR] ;
titstr = [titstr ',  ' date] ;
titstr = [titstr '  NMAX = ' num2str(NMAX) '  r0 = ' num2str(R0)] ;
text(0,0.5,titstr) ;
          %  put down actual title



