disp('Running MATLAB script file vimu4.m') ;
%
%    For Analysis of Vistakon Multifocal Data
%    This reconstructs "predicted" lens images
%    and makes movies morphing from prediction to actual



ipart = 2 ;      %  1 - Make "predicted" images
                 %  2 - make movies



global INDATPATH NMAX R0 HICURVE IBASIS ;
global FEATMPATH SUBDIRSTR M1FILESTR M2FILESTR ;
global M1STR M2STR SETM1PATH SETM2PATH ;  
global RDHANDPOS MAMOVHAND MAM OUTPUTPATH ;


INDATPATH = '\matlab\cornean\indata\' ;
          %  path for input Keratron files
[COMAP, HICURVE] = coacmap ;
ncomap = size(COMAP,1) ;
          %  number of rows in the color map ;



if ipart == 1 ;    %   then make Predicted images

  figure(1) ;

  ngrid = 64 ;
  nang = 256;    % number of semi-meridians read per radial ring
  R0 = 4.2 ;
  NMAX = 10 ;
  IRECENT = 1 ;    %  work with recentering

  xgrid = linspace(-R0, R0, ngrid) ;
  ygrid = xgrid ;	        %  Vectors of image coordinate values 



  %  first load lens Zernike Coeff's, and contruct difference betahats
  %
  infilestr = ['\matlab\cornean\vimu1' num2str(iprofile) 'd.mat'] ;  
  eval(['load ' infilestr]) ;
  
  dbetahat = betahat - sbetahat ;
          %  adjustment, to be added to no lens betahat



  for ifile = 1:10 ;

    disp(['Working on file #' num2str(ifile)]) ;


    if ifile == 1 ;
      titstr = 'Ross,L,304' ;
%      filestr = '000357_2' ;
      filestr = '000352_5' ;
          %  replace filestr with corresponding no lens file
      pupoffamt = 0.119 ;
      pupoffdir = 125 ;
      lencenamt = .99 ;
      lencendir = 50 ;
      lflag = 1 ;
          %  1 for wearing lens
      nlpupoffamt = 0.13 ;
      nlpupoffdir = 101 ;
          %  corresponding no lens pupil center
    elseif ifile == 2 ;
      titstr = 'Ross,L,No' ;
      filestr = '000352_5' ;
      pupoffamt = 0.13 ;
      pupoffdir = 101 ;
      lencenamt = 0 ;
      lencendir = 0 ;
      lflag = 0 ;
          %  1 for wearing lens
    elseif ifile == 3 ;
      titstr = 'Ross,R,No' ;
      filestr = '000352_2' ;
      pupoffamt = 0.248 ;
      pupoffdir = 139 ;
      lencenamt = 0 ;
      lencendir = 0 ;
      lflag = 0 ;
          %  1 for wearing lens
    elseif ifile == 4 ;
      titstr = 'Ross,R,301' ;
%      filestr = '000357_4' ;
      filestr = '000352_2' ;
          %  replace filestr with corresponding no lens file
      pupoffamt = 0.189 ;
      pupoffdir = 144 ;
      lencenamt = 1.3 ;
      lencendir = 118 ;
      lflag = 1 ;
          %  1 for wearing lens
      nlpupoffamt = 0.248 ;
      nlpupoffdir = 139 ;
          %  corresponding no lens pupil center
    elseif ifile == 5 ;
      titstr = 'Duer,L,304' ;
%      filestr = '000358_2' ;
      filestr = '000353_2' ;
          %  replace filestr with corresponding no lens file
      pupoffamt = 0.085 ;
      pupoffdir = 300 ;
      lencenamt = .45 ;
      lencendir = 301 ;
      lflag = 1 ;
          %  1 for wearing lens
      nlpupoffamt = 0.109 ;
      nlpupoffdir = 287 ;
          %  corresponding no lens pupil center
    elseif ifile == 6 ;
      titstr = 'Duer,L,No' ;
      filestr = '000353_2' ;
      pupoffamt = 0.109 ;
      pupoffdir = 287 ;
      lencenamt = 0 ;
      lencendir = 0 ;
      lflag = 0 ;
          %  1 for wearing lens
    elseif ifile == 7 ;
      titstr = 'Duer,R,No' ;
      filestr = '000356_3' ;
      pupoffamt = 0.059 ;
      pupoffdir = 187 ;
      lencenamt = 0 ;
      lencendir = 0 ;
      lflag = 0 ;
          %  1 for wearing lens
    elseif ifile == 8 ;
      titstr = 'Duer,R,301' ;
%      filestr = '000358_1' ;
      filestr = '000356_3' ;
          %  replace filestr with corresponding no lens file
      pupoffamt = 0.099 ;
      pupoffdir = 244 ;
      lencenamt = .89 ;
      lencendir = 145 ;
      lflag = 1 ;
          %  1 for wearing lens
      nlpupoffamt = 0.059 ;
      nlpupoffdir = 187 ;
          %  corresponding no lens pupil center
    elseif ifile == 9 ;
      titstr = 'Duer,L,303' ;
%      filestr = '000360_1' ;
      filestr = '000353_2' ;
          %  replace filestr with corresponding no lens file
      pupoffamt = 0.116 ;
      pupoffdir = 290 ;
      lencenamt = .89 ;
      lencendir = 14 ;
      lflag = 1 ;
          %  1 for wearing lens
      nlpupoffamt = 0.109 ;
      nlpupoffdir = 287 ;
          %  corresponding no lens pupil center
    elseif ifile == 10 ;
      titstr = 'Duer,R,302' ;
%      filestr = '000360_4' ;
      filestr = '000356_3' ;
          %  replace filestr with corresponding no lens file
      pupoffamt = 0.067 ;
      pupoffdir = 261 ;
      lencenamt = .77 ;
      lencendir = 169 ;
      lflag = 1 ;
          %  1 for wearing lens
      nlpupoffamt = 0.059 ;
      nlpupoffdir = 187 ;
          %  corresponding no lens pupil center
    end ;


    if lflag == 1 ;     %  then looking at lens wearing ifile, so proceed




      %  Load previously saved data
      %
      infilestr = ['\matlab\cornean\vimu3' num2str(ifile) '.mat'] ;  
      eval(['load ' infilestr]) ;


      %  adjust by difference vector, to get predicted image
      %
      betahat = betahat + dbetahat ;


      %  Now do Recon. using lines from coazrec.m
      %
      mout = coarr(betahat) ;


      if ifile <= 8 ;
        subplot(3,4,ifile) ;
      else ;
        subplot(3,4,ifile+1) ;
      end ;

      %  Generate map
      %
      pcolor(xgrid,ygrid,mout) ;
        shading flat ;
        axis('square') ;
          caxis([0 1]) ;
        colormap(COMAP) ;

      hold on ;
        plot(0,0,'dk') ;
            %  put a diamond, for lens center
          titstr = ['Pred. of ' titstr] ;
        title(titstr) ;
      hold off ;



      %  Save this stuff in a file, for making movie
      %
      IBASIS  = 2 ;
          %  saves a flag that tells us this is a radially symmetric
          %  decomposition
      CRAD = 0 ;
      CANG = 0 ;

      outfilestr = ['\matlab\cornean\vimu4' num2str(ifile) '.mat'] ;  
      eval(['save ' outfilestr ' betahat IBASIS IRECENT ' ...
                         'R0 NMAX CRAD CANG']) ;



    end ;

  end ;

    orient landscape ;
  print -dpsc '\matlab\cornean\vimu4a.ps' ;



elseif ipart == 2 ;     %  then make movies

  % use same loop structure as above
  %


  for ifile = 1:10 ;

    disp(['Working on file #' num2str(ifile)]) ;

    if ifile == 1 ;
      titstr = 'Ross,L,304' ;
      lflag = 1 ;
          %  1 for wearing lens
    elseif ifile == 2 ;
      titstr = 'Ross,L,No' ;
      lflag = 0 ;
          %  1 for wearing lens
    elseif ifile == 3 ;
      titstr = 'Ross,R,No' ;
      lflag = 0 ;
          %  1 for wearing lens
    elseif ifile == 4 ;
      titstr = 'Ross,R,301' ;
      lflag = 1 ;
          %  1 for wearing lens
    elseif ifile == 5 ;
      titstr = 'Duer,L,304' ;
      lflag = 1 ;
          %  1 for wearing lens
    elseif ifile == 6 ;
      titstr = 'Duer,L,No' ;
      lflag = 0 ;
          %  1 for wearing lens
    elseif ifile == 7 ;
      titstr = 'Duer,R,No' ;
      lflag = 0 ;
          %  1 for wearing lens
    elseif ifile == 8 ;
      titstr = 'Duer,R,301' ;
      lflag = 1 ;
          %  1 for wearing lens
    elseif ifile == 9 ;
      titstr = 'Duer,L,303' ;
      lflag = 1 ;
          %  1 for wearing lens
    elseif ifile == 10 ;
      titstr = 'Duer,R,302' ;
      lflag = 1 ;
          %  1 for wearing lens
    end ;


    if lflag == 1 ;     %  then looking at lens wearing ifile, so proceed


      FEATMPATH = '\matlab\cornean\' ;
      SUBDIRSTR = '' ;

      M1FILESTR = ['vimu4' num2str(ifile)] ;  
          %  file name for predicted image
      
      M2FILESTR = ['vimu3' num2str(ifile)] ;  
          %  file name for actual image

      coamn ;
          %  make movie

      OUTPUTPATH = '\matlab\cornean\' ;

      coams ;
          %  save movie to file

    end ;

  end ;


end ;
