disp('Running MATLAB script file vire1r.m') ;
%
%    Reads in ASCII file, vire1_.in,
%    that was first created by vire1.m,
%    and then had day and session info
%    editted in
%    Then creates version, where for each patient,
%    the day and sessions are randomized
%

iR0 = 2 ;


%  Initialize parameters
%
ips = 1 ;
ipe = 4 ;


if iR0 == 1 ;
  outsuf = 'a' ;
  R0 = 4.2 ;
elseif iR0 == 2 ;
  outsuf = 'b' ;  
  R0 = 3.0 ;
end ;




%  Read in data matrix
%
fid = fopen(['\matlab\cornean\vire1' outsuf '.in'],'rt') ;
          %  'rt' is for "read only" and "text"

forstr = '%f %f %f %f %f' ;
          %  format for reading:
          %      file no.
          %      pat. no.
          %      day no.
          %      session no.
          %      eye no.
ninpar = 5 ;
ncoeff = 66 ;
for iformat = 1:ncoeff ;
  forstr = [forstr ' %f'] ;
end ;

[mdata,cnt] = fscanf(fid,forstr) ;
fclose(fid) ;

ncol = ninpar + ncoeff ;
nrow = cnt / ncol ;

mdata = reshape(mdata,ncol,nrow)' ;
          %   since reshape works column wise

%mdata(1:10,:)
%mdata(nrow,:)
          %  used for testing read in


%  Replace day and session number by random vector of 1,2,3 's
%
seed = 93487508 ;
rand('seed',seed) ;
vrand = 3 * rand(nrow,1) ;
          %  Unif(0,3) rv's ;
vrand = ceil(vrand) ;
          %  Random 1,2,3's
mdata(:,3) = vrand ;
          %      file no.
          %      pat. no.
          %      day no.
          %      session no.
          %      eye no.

vrand = 3 * rand(nrow,1) ;
          %  Unif(0,3) rv's ;
vrand = ceil(vrand) ;
          %  Random 1,2,3's
mdata(:,4) = vrand ;



mdata(:,1:7)
          %  check result




%  Save as ASCII file, using lines from gptable.m
%
fid = fopen(['\matlab\cornean\vire1' outsuf 'r.in'],'wt') ;
          %  'wt' is for "delete contents of this file and open 
          %               for writing" (with 't' for "text").
          %  Use 'ay' to append to what is already there, 'rt' for reading.

forstr = '%6.1f %1.0f %1.0f %1.0f %1.0f' ;
          %      file no.
          %      pat. no.
          %      day no.
          %      session no.
          %      eye no.
for iformat = 1:ncoeff ;
  forstr = [forstr ' %8.6f'] ;
end ;
forstr = [forstr '\n'] ;

cntbytes = fprintf(fid,forstr,mdata') ;
          %  Careful here, because this reads down columns first,
          %  So feed it the transpose of the usual form
fclose(fid) ;


disp(' ') ;
disp(' ') ;
disp(['Finished constructing ASCII file: vire1' outsuf 'r.in']) ;




