%  This function takes as its input the column vectors x and y which
%  specify the gridlines which will be graphed (x and y ranges of the data)
%  and mu and sigma, the parameters of a bivariate normal.  Its output is the Z
%  matrix which is the normal surface over the x and y ranges having mu and
%  sigma as its mean and variance.

function [Z] = bump(x, y, mu, sigma)

c = ((2*pi)^(-1))*(det(sigma)^(-1/2));

if det(sigma) == 0
	
	Z = zeros(length(y),length(x));
	i = 1; j = 1;
	while y(i) < mu(2,1)
		i = i+1;
	end
	while x(j) < mu(1,1)
		j = j+1;
	end
	Z(i,j) = Inf;

else
	siginv = inv(sigma);
	
	x = x - mu(1,1);
	y = y - mu(2,1);

	[X,Y] = meshgrid(x,y);


	M = (-1/2)*((siginv(1,1)*X.^2)+((siginv(2,1)+siginv(1,2))*X.*Y)+(siginv(2,2)*Y.^2));

	Z = c*exp(M);

end
