% This function will take as its input two points and their times: the column vector: (x1, y1, t1, x2, y2, t2)'; also the parameters sigma1 and sigma2. Further, the column vectors x and y which will define the region over which the surface will be plotted.  The output will be the z-matrix over that surface using the Brownian bridge model.

function Z = twobumpssmoothed(x,y,data,sigma1,sigma2,n)

x1 = data(1,1);
y1 = data(1,2);
t1 = data(1,3);
x2 = data(2,1);
y2 = data(2,2);
t2 = data(2,3);

Zint = zeros(length(y),length(x));

T = t2-t1;
b = [x2-x1;y2-y1];

for a = 0:(1/n):1
	mu = a*b + [x1;y1];
	sig1 = T*a*(1-a)*sigma1;
	sig2 = (a^2 + (1-a)^2)*sigma2;
	sig = (sig1+sig2)*eye(2);
	Ztemp = bump(x,y,mu,sig);
	Zint = Zint + Ztemp;
end

Z = Zint/(n+1);
