% this function takes as its input vectors x and y (the grid line definers)
% vectors xdata, ydata, and tdata, and the sigma matrix.
% Its output is the matrix Z which is the average of Gaussian bridges
% over consecutive pairs of data points.

function Z = twobumpy(x,y,xdata,ydata,tdata,sigma1,sigma2,n)

Z = zeros(length(y),length(x));

len = length(tdata);
Ttotal = tdata(len)-tdata(1);

for i = 1:(length(xdata)-1)
	countdown = length(xdata)-i
	data = [xdata(i,1),ydata(i,1),tdata(i,1);xdata(i+1,1),ydata(i+1,1),tdata(i+1,1)];
	Znew = twobumpssmoothed(x, y, data, sigma1, sigma2, n);
	Z = Z + Znew*((tdata(i+1,1)-tdata(i,1))/Ttotal);
end

sigma1
sigma2

