%%*************************************************************************
%% parameters.m: set OPTIONS structure to specify default
%%               parameters for sqlp.m
%%
%% OPTIONS.vers        : version of direction to use.  
%% OPTIONS.gam         : step-length parameter,
%% OPTIONS.predcorr    : whether to use Mehrotra predictor-corrector. 
%% OPTIONS.expon       : exponent in decrease of centering parameter sigma. 
%% OPTIONS.gaptol      : tolerance for duality gap as a fraction of the 
%%                       value of the objective functions. 
%% OPTIONS.inftol      : tolerance for stopping due to suspicion of 
%%                       infeasibility.
%% OPTIONS.steptol     : toloerance for stopping due to small steps.
%% OPTIONS.maxit       : maximum number of iteration allowed 
%% OPTIONS.printyes    : 1, if want to display result in each iteration, 
%%                          else = 0. 
%% OPTIONS.scale_data  : 1, if want to scale the data before solving the problem, 
%%                          else = 0
%% OPTIONS.randnstate  : state to be used for matlab's random normal generator.
%% OPTIONS.rmdepconstr : 1, if want to remove nearly dependent constraints,
%%                          else = 0. 
%%
%% SDPT3: version 3.0 
%% Copyright (c) 1997 by
%% K.C. Toh, M.J. Todd, R.H. Tutuncu
%% Last modified: 2 Feb 01
%%*************************************************************************

   OPTIONS.vers          = 1; 
   OPTIONS.gam           = 0;  
   OPTIONS.predcorr      = 1;
   OPTIONS.expon         = [1 1]; 
   OPTIONS.gaptol        = 1e-8;
   OPTIONS.inftol        = 1e-8; 
   OPTIONS.steptol       = 1e-6; 
   OPTIONS.maxit         = 50; 
   OPTIONS.printyes      = 1; 
   OPTIONS.scale_data    = 0; 
   OPTIONS.randnstate    = 0; 
   OPTIONS.spdensity     = 0.5; 
   OPTIONS.rmdepconstr   = 0; 
%%=============================================================




