disp('Running MATLAB script file GeomRepHDLSS1figA.m') ;
%
%    Which Makes Figure A for the 
%    "Geometric Representation of HDLSS" paper
%
%    Copied from:  HallHighDEg0
%
%    Which:
%    Makes Very Simple Toy Examples, illustrating basic ideas
%    in the Hall Marron High Dimensionality paper
%


%ipart = 1 ;      %  1 - n=2, Subspace    (4 plots)
%                 %  2 - n=3, Simplex     (movie output)
%  now does part 1    (Figure version)




fighand = figure(1) ;
clf ;

titlefontsize = 10 ;
axlength = 1.5 ;
alpha = 3 * pi / 4 ;
beta1 = -pi/4 ;
vdat1d2 = 1.05 * [cos(beta1); sin(beta1)] ;
beta2 = pi / 3 ;
vdat2d2 = 0.95 * [cos(beta2); sin(beta2)] ;
vdat1d3 = 1.05 * [cos(beta1) * cos(alpha); cos(beta1) * sin(alpha); sin(beta1)] ;
vdat2d3 = 0.95 * [cos(beta2) * cos(alpha); cos(beta2) * sin(alpha); sin(beta2)] ;


subplot(2,2,1) ;
  plot3(axlength * [[-1;1],[0;0],[0;0]], ...
        axlength * [[0;0],[-1;1],[0;0]], ...
        axlength * [[0;0],[0;0],[-1;1]],'k-') ;
  axis square ;
  hold on ;
%    plot3(vdat1d3(1),vdat1d3(2),vdat1d3(3),'bo','LineWidth',2,'MarkerSize',8) ;
%    plot3(vdat2d3(1),vdat2d3(2),vdat2d3(3),'bo','LineWidth',2,'MarkerSize',8) ;
    plot3(vdat1d3(1),vdat1d3(2),vdat1d3(3),'bo') ;
    plot3(vdat2d3(1),vdat2d3(2),vdat2d3(3),'bo') ;
  hold off ;
  title('n = 2 Toy Data Points in 3-d','FontSize',titlefontsize) ;


subplot(2,2,2) ;
  plot3(axlength * [[-1;1],[0;0],[0;0]], ...
        axlength * [[0;0],[-1;1],[0;0]], ...
        axlength * [[0;0],[0;0],[-1;1]],'k-') ;
  axis square ;

  hold on ;
  
    ph = patch([cos(alpha); cos(alpha); -cos(alpha); -cos(alpha)]+0.001, ...
               [sin(alpha); sin(alpha); -sin(alpha); -sin(alpha)]+0.001, ...
               [-1; 1; 1; -1],'c') ;
%        set(ph,'FaceAlpha',0.5) ;

%    plot3(vdat1d3(1),vdat1d3(2),vdat1d3(3),'bo','LineWidth',2,'MarkerSize',8) ;
%    plot3(vdat2d3(1),vdat2d3(2),vdat2d3(3),'bo','LineWidth',2,'MarkerSize',8) ;
%    plot3([vdat1d3(1);0],[vdat1d3(2);0],[vdat1d3(3);0],'b-', ...
%            'LineWidth',2,'MarkerSize',8) ;
%    plot3([vdat2d3(1);0],[vdat2d3(2);0],[vdat2d3(3);0],'b-', ...
%            'LineWidth',2,'MarkerSize',8) ;
%    plot3([vdat1d3(1);vdat2d3(1)],[vdat1d3(2);vdat2d3(2)], ...
%          [vdat1d3(3);vdat2d3(3)],'b--', ...
%            'LineWidth',2,'MarkerSize',8) ;
    plot3(vdat1d3(1),vdat1d3(2),vdat1d3(3),'bo') ;
    plot3(vdat2d3(1),vdat2d3(2),vdat2d3(3),'bo') ;
    plot3([vdat1d3(1);0],[vdat1d3(2);0],[vdat1d3(3);0],'b-') ;
    plot3([vdat2d3(1);0],[vdat2d3(2);0],[vdat2d3(3);0],'b-') ;
    plot3([vdat1d3(1);vdat2d3(1)],[vdat1d3(2);vdat2d3(2)], ...
          [vdat1d3(3);vdat2d3(3)],'b--') ;

  hold off ;
  title('Subspace (2-d) Generated by Data','FontSize',titlefontsize) ;


subplot(2,2,3) ;
  patch([1, 1, -1, -1, 1],[-1, 1, 1, -1, -1],'c') ;
  axis square ;
  axis([-axlength,axlength,-axlength,axlength]) ;

  hold on ;

    plot(axlength * [[-1;1],[0;0]], ...
         axlength * [[0;0],[-1;1]],'k-') ;

%    plot(vdat1d2(1),vdat1d2(2),'bo','LineWidth',2,'MarkerSize',8) ;
%    plot(vdat2d2(1),vdat2d2(2),'bo','LineWidth',2,'MarkerSize',8) ;
%    plot([vdat1d2(1);0],[vdat1d2(2);0],'b-','LineWidth',2) ;
%    plot([vdat2d2(1);0],[vdat2d2(2);0],'b-','LineWidth',2) ;
%    plot([vdat1d2(1);vdat2d2(1)],[vdat1d2(2);vdat2d2(2)],'b--','LineWidth',2) ;
    plot(vdat1d2(1),vdat1d2(2),'bo') ;
    plot(vdat2d2(1),vdat2d2(2),'bo') ;
    plot([vdat1d2(1);0],[vdat1d2(2);0],'b-') ;
    plot([vdat2d2(1);0],[vdat2d2(2);0],'b-') ;
    plot([vdat1d2(1);vdat2d2(1)],[vdat1d2(2);vdat2d2(2)],'b--') ;

  hold off
  title('2-d Projection','FontSize',titlefontsize) ;


  angle1 = atan2(vdat1d2(2),vdat1d2(1)) ;
  angle2 = atan2(vdat2d2(2),vdat2d2(1)) ;
  avangle = mean([angle1; angle2]) ;

  angrot = pi/4 - avangle ;
      %  angle to rotate, puts average angle at pi/4
  mrot = [[cos(angrot) -sin(angrot)]; [sin(angrot) cos(angrot)]] ;
      %  rotation matrix
  vdat1d2r = mrot * vdat1d2 ;
  vdat2d2r = mrot * vdat2d2 ;

subplot(2,2,4) ;
  plot(axlength * [[-1;1],[0;0]], ...
       axlength * [[0;0],[-1;1]],'k-') ;
  axis square ;
  axis([-axlength,axlength,-axlength,axlength]) ;

  hold on ;

%    plot(vdat1d2r(1),vdat1d2r(2),'bo','LineWidth',2,'MarkerSize',8) ;
%    plot(vdat2d2r(1),vdat2d2r(2),'bo','LineWidth',2,'MarkerSize',8) ;
%    plot([vdat1d2r(1);0],[vdat1d2r(2);0],'b-','LineWidth',2) ;
%    plot([vdat2d2r(1);0],[vdat2d2r(2);0],'b-','LineWidth',2) ;
%    plot([vdat1d2r(1);vdat2d2r(1)],[vdat1d2r(2);vdat2d2r(2)],'b--','LineWidth',2) ;
    plot(vdat1d2r(1),vdat1d2r(2),'bo') ;
    plot(vdat2d2r(1),vdat2d2r(2),'bo') ;
    plot([vdat1d2r(1);0],[vdat1d2r(2);0],'b-') ;
    plot([vdat2d2r(1);0],[vdat2d2r(2);0],'b-') ;
    plot([vdat1d2r(1);vdat2d2r(1)],[vdat1d2r(2);vdat2d2r(2)],'b--') ;

    plot([0, 1],[1, 0],'ko') ;
    plot([0, 1],[1, 0],'k--') ;

  hold off
  title('Rotation Toward Unit Simplex','FontSize',titlefontsize) ;


pstr = 'GeomRepHDLSS1figA' ;
orient portrait ;
set(gcf,'PaperSize',[6.0, 5.0]) ; 
set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 4.5]) ; 
print('-dpsc', [pstr '.ps']) ;



