disp('Running MATLAB script file GeomRepHDLSS1figB.m') ;
%
%    Which Makes Figure B for the 
%    "Geometric Representation of HDLSS" paper
%
%    Copied from:  HallHighDEg0
%
%    Which:
%    Makes Very Simple Toy Examples, illustrating basicideas
%    in the Hall Marron High Dimensionality paper
%


%ipart = 1 ;      %  1 - n=2, Subspace    (4 plots)
%                 %  2 - n=3, Simplex     (movie output)
%  now does part 2 only


ibw = 1 ;    %   0 for original color
             %   1 for black and white version



fighand = figure(1) ;
clf ;
%clear moviestruct ;


%  Set parameters
%
moviefps = 5 ;
moviecstr = 'Cinepak' ;
nrepeat = 2 ;
nframe = 60 ;
vangle = linspace(0,360 * (1 - 1/nframe),nframe) ;

titlefontsize = 15 ;
axlength = 1.5 ;
vdat1 = [0.6; 0.5; 0.8] ;
vdat2 = [-0.5; 0.1; 0.7] ;
vdat3 = [0.7; -0.6; 0.1] ;

vmean = mean([vdat1, vdat2, vdat3],2) ;
paramstruct = struct('npc',2,...
                     'iscreenwrite',0,...
                     'viout',[0 1]) ;
outstruct = pcaSM([vdat1, vdat2, vdat3],paramstruct) ;
meigvec = getfield(outstruct,'meigvec') ;

c1 = vmean + meigvec(:,1) + meigvec(:,2) ;  
c2 = vmean + meigvec(:,1) - meigvec(:,2) ;  
c3 = vmean - meigvec(:,1) - meigvec(:,2) ;  
c4 = vmean - meigvec(:,1) + meigvec(:,2) ;  

if ibw == 0 
  ph = patch([c1(1); c2(1); c3(1); c4(1); c1(1)], ...
             [c1(2); c2(2); c3(2); c4(2); c1(2)], ...
             [c1(3); c2(3); c3(3); c4(3); c1(3)], ...
             'c','FaceAlpha',0.5) ;
elseif ibw == 1 ;
  ph = patch([c1(1); c2(1); c3(1); c4(1); c1(1)], ...
             [c1(2); c2(2); c3(2); c4(2); c1(2)], ...
             [c1(3); c2(3); c3(3); c4(3); c1(3)], ...
             'k','FaceAlpha',0.5) ;
end ;

%  title('n = 3 Toy Data Points in 3-d & Simplex Generated by the Data','FontSize',12) ;
set(fighand,'Color',[1 1 1]) ;
axis equal ;
axis vis3d ;
axis off ;


hold on ;

  plot3(axlength * [[-1;1],[0;0],[0;0]], ...
        axlength * [[0;0],[-1;1],[0;0]], ...
        axlength * [[0;0],[0;0],[-1;1]],'k-','LineWidth',1) ;

%  plot3(vdat1(1),vdat1(2),vdat1(3),'bo','LineWidth',2,'MarkerSize',8) ;
%  plot3(vdat2(1),vdat2(2),vdat2(3),'bo','LineWidth',2,'MarkerSize',8) ;
%  plot3(vdat3(1),vdat3(2),vdat3(3),'bo','LineWidth',2,'MarkerSize',8) ;
%
%  plot3([vdat1(1); 0],[vdat1(2); 0],[vdat1(3); 0],'b-','LineWidth',2) ;
%  plot3([vdat2(1); 0],[vdat2(2); 0],[vdat2(3); 0],'b-','LineWidth',2) ;
%  plot3([vdat3(1); 0],[vdat3(2); 0],[vdat3(3); 0],'b-','LineWidth',2) ;
%
%  plot3([vdat1(1); vdat2(1)],[vdat1(2); vdat2(2)], ...
%        [vdat1(3); vdat2(3)],'b--','LineWidth',2) ;
%  plot3([vdat2(1); vdat3(1)],[vdat2(2); vdat3(2)], ...
%        [vdat2(3); vdat3(3)],'b--','LineWidth',2) ;
%  plot3([vdat1(1); vdat3(1)],[vdat1(2); vdat3(2)], ...
%        [vdat1(3); vdat3(3)],'b--','LineWidth',2) ;

if ibw == 0 ;

  plot3(vdat1(1),vdat1(2),vdat1(3),'bo','LineWidth',2,'MarkerSize',8) ;
  plot3(vdat2(1),vdat2(2),vdat2(3),'bo','LineWidth',2,'MarkerSize',8) ;
  plot3(vdat3(1),vdat3(2),vdat3(3),'bo','LineWidth',2,'MarkerSize',8) ;

  plot3([vdat1(1); 0],[vdat1(2); 0],[vdat1(3); 0],'b-','LineWidth',2) ;
  plot3([vdat2(1); 0],[vdat2(2); 0],[vdat2(3); 0],'b-','LineWidth',2) ;
  plot3([vdat3(1); 0],[vdat3(2); 0],[vdat3(3); 0],'b-','LineWidth',2) ;

  plot3([vdat1(1); vdat2(1)],[vdat1(2); vdat2(2)], ...
        [vdat1(3); vdat2(3)],'b--','LineWidth',2) ;
  plot3([vdat2(1); vdat3(1)],[vdat2(2); vdat3(2)], ...
        [vdat2(3); vdat3(3)],'b--','LineWidth',2) ;
  plot3([vdat1(1); vdat3(1)],[vdat1(2); vdat3(2)], ...
        [vdat1(3); vdat3(3)],'b--','LineWidth',2) ;

elseif ibw == 1 ;

  plot3(vdat1(1),vdat1(2),vdat1(3),'ko','LineWidth',2,'MarkerSize',8) ;
  plot3(vdat2(1),vdat2(2),vdat2(3),'ko','LineWidth',2,'MarkerSize',8) ;
  plot3(vdat3(1),vdat3(2),vdat3(3),'ko','LineWidth',2,'MarkerSize',8) ;

  plot3([vdat1(1); 0],[vdat1(2); 0],[vdat1(3); 0],'k-','LineWidth',2) ;
  plot3([vdat2(1); 0],[vdat2(2); 0],[vdat2(3); 0],'k-','LineWidth',2) ;
  plot3([vdat3(1); 0],[vdat3(2); 0],[vdat3(3); 0],'k-','LineWidth',2) ;

  plot3([vdat1(1); vdat2(1)],[vdat1(2); vdat2(2)], ...
        [vdat1(3); vdat2(3)],'k--','LineWidth',2) ;
  plot3([vdat2(1); vdat3(1)],[vdat2(2); vdat3(2)], ...
        [vdat2(3); vdat3(3)],'k--','LineWidth',2) ;
  plot3([vdat1(1); vdat3(1)],[vdat1(2); vdat3(2)], ...
        [vdat1(3); vdat3(3)],'k--','LineWidth',2) ;

end ;

hold off ;
set(gcf,'name','Toy Data') ;




%%  Do main movie loop
%%
%for iframe = 1:nframe ;
%
%  view(vangle(iframe),20) ;
%
%  moviestruct(iframe) = getframe(fighand) ;
%
%end ;    %  of iframe loop, to make movie
%
%
%
%%  Replay
%%
%movie(fighand,moviestruct,nrepeat,moviefps) ;
%        %  Play movie on screen
%
%
%%  Save results
%%
%
%
%  %if ioutput == 1 ;
%  %
%  %
%  %elseif ioutput == 2 ;
%
%%    orient landscape ;
%    pstr = 'HallHighDEg0n3' ;
%%    print('-dpsc', [pstr '.ps']) ;
%
%    savestr = 'TempMovie' ;
%    movie2avi(moviestruct,pstr,'compression',moviecstr, ...
%                      'keyframe',moviefps,'fps',moviefps) ;
%
%
%  %end ;


iframe = 47 ;
iframe = 50 ;
    %  gave good visual impression from movie version:
    %          

view(vangle(iframe),20) ;



if ibw == 0 ;
  pstr = 'GeomRepHDLSS1figB' ;
  orient portrait ;
  set(gcf,'PaperSize',[4.0, 4.0]) ; 
  set(gcf,'PaperPosition',[0.25, 0.25, 3.5, 3.5]) ; 
  print('-dpsc', [pstr '.ps']) ;
elseif ibw == 1 ;
  pstr = 'GeomRepHDLSS1figBbw' ;
  orient portrait ;
  set(gcf,'PaperSize',[4.0, 4.0]) ; 
  set(gcf,'PaperPosition',[0.25, 0.25, 3.5, 3.5]) ; 
  print('-dps2', [pstr '.ps']) ;
end ;



