disp('Running MATLAB script file GeomRepHDLSS1figF.m') ;
%
%    Makes Figure F for the DWD paper
%
%    Copied from HallHighDSim1.m
%
%    Which did simulations for the
%    Hall Marron High Dimensionality paper
%
%    Uses lines from 
%    and fromD:\Research\MatlabSoftware\HDD\hdd1hall1.m
%


%  11 - Error Rates Split by Class, and unbalanced


ibw = 1 ;    %   0 for original color
             %   1 for black and white version



vd = [10 100 1000] ;
                %  Vector of Dimensions


vidat = [1] ;
                  %  Vector of indices of data type
                  %  For ipart == 1,2:
                  %    1 - X1, X2 ind. N(0,1),  Y1, Y2 indep N(mu,1)
                  %    2 - X1, X2 ind. N(0,1),  Y1, Y2 indep N(1+mu,sqrt(2))
                  %  For ipart == 11:
                  %    1 - X1, X2 ind. N(0,1),  Y1, Y2 indep N(mu,1)
                  %              mu in [0,1]
                  %    2 - X1, X2 ind. N(0,1),  Y1, Y2 indep N(mu,sqrt(2))
                  %              mu in [1,2]



%elseif ipart == 11 ;    %  do simulations for unbalanced case


addpath(['C:\Documents and Settings\J S Marron\My Documents' ...
             '\Research\MatlabSoftware\HDD'],'-end') ;



  %  set up parameters
  %
  seed = 90387589745 ;
  randn('state',seed) ;
  ntest = 100 ;
  nsim = 1000 ;

%  vm = [2 1 2 2 2] ;
%  vn = [1 2 3 5 10] ;
vm = [2] ;
vn = [5] ;

ma1properrSVM = [] ;
ma1properrDWD = [] ;
ma1properrMD = [] ;
ma2properrSVM = [] ;
ma2properrDWD = [] ;
ma2properrMD = [] ;
maproperrSVM = [] ;
maproperrDWD = [] ;
maproperrMD = [] ;

mltypstr = strvcat(': ','--','- ') ;



  for d = vd ;   %  loop through dimensions


    for idat = vidat ;    %  loop through data settings


      if idat == 1 ;
%        vmu = [0 0.1 0.2 0.3 0.5 0.7 1] ;
        vmu = [0 0.3 0.5 0.6 0.7 0.8 0.9 1] ;
            %  this seems better in retrospect
      elseif idat == 2 ;
        vmu = [1 1.1 1.2 1.3 1.5 1.7 2] ;
      end ;
      minmu = min(vmu) ;
      maxmu = max(vmu) ;


      for imn = 1:length(vn) ;
      
        m = vm(imn) ;
        n = vn(imn) ;

        np = m ;
        nn = n ;


        if idat == 1 ;
          titstr1 = ['m = ' num2str(m) ' N(0,1), Class Error Rates'] ;
          titstr2 = ['n = ' num2str(n) ' N(mu,1), Class Error Rates'] ;
        elseif idat == 2 ;
          titstr1 = ['m = ' num2str(m) ' N(0,1), Class Error Rates'] ;
          titstr2 = ['n = ' num2str(n) ' N(mu,2), Class Error Rates'] ;
        end ;
        titstr3 = ['Combined (m,n prop''l) Error Rates, d = ' num2str(d)] ;
        titstr4 = ['Angle to Optimal, ' num2str(nsim) ' repl''ns'] ;


        figure(1) ;
        clf ;


        %  loop through mu's
        %
        va1properrSVM = [] ;
        va1properrDWD = [] ;
        va1properrMD = [] ;
        va2properrSVM = [] ;
        va2properrDWD = [] ;
        va2properrMD = [] ;
        vaproperrSVM = [] ;
        vaproperrDWD = [] ;
        vaproperrMD = [] ;
        vaangleSVM = [] ;
        vaangleDWD = [] ;
        vaangleMD = [] ;
        for mu = vmu ;


          %  loop through simulated data sets
          %
          v1properrSVM = [] ;
          v1properrDWD = [] ;
          v1properrMD = [] ;
          v2properrSVM = [] ;
          v2properrDWD = [] ;
          v2properrMD = [] ;
          vproperrSVM = [] ;
          vproperrDWD = [] ;
          vproperrMD = [] ;
          vangleSVM = [] ;
          vangleDWD = [] ;
          vangleMD = [] ;
          for isim = 1:nsim ;


            %  generate basedata
            %
            trainp = randn(d,np) ;
            trainn = randn(d,nn) ;
            testp = randn(d,ntest) ;
            testn = randn(d,ntest) ;

            if idat == 2 ;
              trainn = trainn * sqrt(2) ;
              testn = testn * sqrt(2) ;
            end ;


            mutrainn = trainn + mu * ones(d,nn) ;
            mutestn = testn + mu * ones(d,ntest) ;

            data = [testp mutestn] ;


            % do discrimination
            %
            randnstate = randn('state') ;
                %  save current state (since the following may reset it)


            %  Compute SVM
            %
            imethin = 4 ;
            methpar = -100 ;
            [dr, dirvec] = hdd1SM(data,trainp,mutrainn,imethin,methpar) ;

            if isempty(dr) ;
              numerr = 2 * ntest ;
            else ;          
              verr1 = (dr(1:ntest) ~= ones(1,ntest)) ;
              verr2 = (dr(ntest+1:2*ntest) ~= -ones(1,ntest)) ;
                  %  one where got wrong answer
              numerr1 = sum(verr1) ;
              numerr2 = sum(verr2) ;
            end ;
            properr1 = numerr1 / ntest ;
            properr2 = numerr2 / ntest ;
            properr = (m * properr1 + n * properr2) / (m + n) ;
                %  proportion of errors (on fresh data)

            v1properrSVM = [v1properrSVM; properr1] ;
            v2properrSVM = [v2properrSVM; properr2] ;
            vproperrSVM = [vproperrSVM; properr] ;

            vangleSVM = [vangleSVM; (90 / (pi/2)) * acos(abs(sum(dirvec)) / sqrt(d))] ;
                %  angle (in degrees) to 45 degree line (optimal)


            %  Compute DWD
            %
            imethin = 11 ;
            [dr, dirvec] = hdd1SM(data,trainp,mutrainn,imethin) ;

            if isempty(dr) ;
              numerr = 2 * ntest ;
            else ;          
              verr1 = (dr(1:ntest) ~= ones(1,ntest)) ;
              verr2 = (dr(ntest+1:2*ntest) ~= -ones(1,ntest)) ;
                  %  one where got wrong answer
              numerr1 = sum(verr1) ;
              numerr2 = sum(verr2) ;
            end ;
            properr1 = numerr1 / ntest ;
            properr2 = numerr2 / ntest ;
            properr = (m * properr1 + n * properr2) / (m + n) ;
                %  proportion of errors (on fresh data)

            v1properrDWD = [v1properrDWD; properr1] ;
            v2properrDWD = [v2properrDWD; properr2] ;
            vproperrDWD = [vproperrDWD; properr] ;

            vangleDWD = [vangleDWD; (90 / (pi/2)) * acos(abs(sum(dirvec)) / sqrt(d))] ;
                %  angle (in degrees) to 45 degree line (optimal)


            %  Compute MD
            %
            imethin = 1 ;
            [dr, dirvec] = hdd1SM(data,trainp,mutrainn,imethin) ;

            if isempty(dr) ;
              numerr = 2 * ntest ;
            else ;          
              verr1 = (dr(1:ntest) ~= ones(1,ntest)) ;
              verr2 = (dr(ntest+1:2*ntest) ~= -ones(1,ntest)) ;
                  %  one where got wrong answer
              numerr1 = sum(verr1) ;
              numerr2 = sum(verr2) ;
            end ;
            properr1 = numerr1 / ntest ;
            properr2 = numerr2 / ntest ;
            properr = (m * properr1 + n * properr2) / (m + n) ;
                %  proportion of errors (on fresh data)

            v1properrMD = [v1properrMD; properr1] ;
            v2properrMD = [v2properrMD; properr2] ;
            vproperrMD = [vproperrMD; properr] ;

            vangleMD = [vangleMD; (90 / (pi/2)) * acos(abs(sum(dirvec)) / sqrt(d))] ;
                %  angle (in degrees) to 45 degree line (optimal)



            randn('state',randnstate) ;
                %  set this back to earlier value, to get correct simulation data


          end ;    %  of isim loop



          va1properrSVM = [va1properrSVM; mean(v1properrSVM)] ;
          va2properrSVM = [va2properrSVM; mean(v2properrSVM)] ;
          vaproperrSVM = [vaproperrSVM; mean(vproperrSVM)] ;
          va1properrDWD = [va1properrDWD; mean(v1properrDWD)] ;
          va2properrDWD = [va2properrDWD; mean(v2properrDWD)] ;
          vaproperrDWD = [vaproperrDWD; mean(vproperrDWD)] ;
          va1properrMD = [va1properrMD; mean(v1properrMD)] ;
          va2properrMD = [va2properrMD; mean(v2properrMD)] ;
          vaproperrMD = [vaproperrMD; mean(vproperrMD)] ;
          vaangleSVM = [vaangleSVM; mean(vangleSVM)] ;
          vaangleDWD = [vaangleDWD; mean(vangleDWD)] ;
          vaangleMD = [vaangleMD; mean(vangleMD)] ;



        end ;    %  of mu loop



%        %  make main output graphic
%        %
%        subplot(2,2,1) ;
%          ph = plot(vmu',[va1properrMD va1properrDWD va1properrSVM], ...
%                           'LineWidth',2) ;
%            set(ph(1),'Color','r') ;
%            set(ph(2),'Color','m') ;
%            set(ph(3),'Color','b') ;
%            axis([minmu,maxmu,0,1.0]) ;
%            title(titstr1,'FontSize',15) ;
%            xlabel('\mu') ;
%            ylabel(['Avg. Error Rate (prop. in ' num2str(ntest) ')']) ;
%
%                tx = minmu + 0.1 * (maxmu - 0) ;
%                ty = 0 + (0.9 * (1 - 0)) ;
%              text(tx,ty,'MD','Color','r','FontSize',12) ;
%                ty = 0 + (0.8 * (1 - 0)) ;
%              text(tx,ty,'DWD','Color','m','FontSize',12) ;
%                ty = 0 + (0.7 * (1 - 0)) ;
%              text(tx,ty,'SVM','Color','b','FontSize',12) ;
%
%
%        subplot(2,2,2) ;
%          ph = plot(vmu',[va2properrMD va2properrDWD va2properrSVM], ...
%                           'LineWidth',2) ;
%            set(ph(1),'Color','r') ;
%            set(ph(2),'Color','m') ;
%            set(ph(3),'Color','b') ;
%            axis([minmu,maxmu,0,1.0]) ;
%            title(titstr2,'FontSize',15) ;
%            xlabel('\mu') ;
%            ylabel(['Avg. Error Rate (prop. in ' num2str(ntest) ')']) ;
%
%                tx = minmu + 0.1 * (maxmu - 0) ;
%                ty = 0 + (0.9 * (1 - 0)) ;
%              text(tx,ty,'MD','Color','r','FontSize',12) ;
%                ty = 0 + (0.8 * (1 - 0)) ;
%              text(tx,ty,'DWD','Color','m','FontSize',12) ;
%                ty = 0 + (0.7 * (1 - 0)) ;
%              text(tx,ty,'SVM','Color','b','FontSize',12) ;
%
%
%        subplot(2,2,3) ;
%          ph = plot(vmu',[vaproperrMD vaproperrDWD vaproperrSVM], ...
%                           'LineWidth',2) ;
%            set(ph(1),'Color','r') ;
%            set(ph(2),'Color','m') ;
%            set(ph(3),'Color','b') ;
%            axis([minmu,maxmu,0,1.0]) ;
%            title(titstr3,'FontSize',15) ;
%            xlabel('\mu') ;
%            ylabel(['Avg. Error Rate (prop. in ' num2str(ntest + ntest) ')']) ;
%
%                tx = minmu + 0.1 * (maxmu - 0) ;
%                ty = 0 + (0.9 * (1 - 0)) ;
%              text(tx,ty,'MD','Color','r','FontSize',12) ;
%                ty = 0 + (0.8 * (1 - 0)) ;
%              text(tx,ty,'DWD','Color','m','FontSize',12) ;
%                ty = 0 + (0.7 * (1 - 0)) ;
%              text(tx,ty,'SVM','Color','b','FontSize',12) ;
%
%
%        subplot(2,2,4) ;
%          ph = plot(vmu',[vaangleMD vaangleDWD vaangleSVM], ...
%                           'LineWidth',2) ;
%            set(ph(1),'Color','r') ;
%            set(ph(2),'Color','m') ;
%            set(ph(3),'Color','b') ;
%            axis([minmu,maxmu,0,95]) ;
%            title(titstr4,'FontSize',15) ;
%            xlabel('\mu') ;
%            ylabel('Avg. Angle (deg.)') ;
%
%
%
%          orient landscape ;
%        print('-dpsc2',['SimPlots\HDD1Hall1' ...
%                        'part' num2str(ipart) ...
%                        'dat' num2str(idat) ...
%                        'm' num2str(m) ...
%                        'n' num2str(n) ...
%                        'd' num2str(d)]) ;

        ma1properrSVM = [ma1properrSVM va1properrSVM] ;
        ma1properrDWD = [ma1properrDWD va1properrDWD] ;
        ma1properrMD = [ma1properrMD va1properrMD] ;
        ma2properrSVM = [ma2properrSVM va2properrSVM] ;
        ma2properrDWD = [ma2properrDWD va2properrDWD] ;
        ma2properrMD = [ma2properrMD va2properrMD] ;
        maproperrSVM = [maproperrSVM vaproperrSVM] ;
        maproperrDWD = [maproperrDWD vaproperrDWD] ;
        maproperrMD = [maproperrMD vaproperrMD] ;



      end ;    %  of imn loop


    end ;    %  of idat loop through data settings


  end ;    %  of d loop through dimensions




%  Make Main graphic
%
        if ibw == 0 ;
          ph = plot(vmu',[ma1properrMD(:,1) ma1properrDWD(:,1) ma1properrSVM(:,1)],':', ...
                           'LineWidth',1) ;
            set(ph(1),'Color','r') ;
            set(ph(2),'Color','m') ;
            set(ph(3),'Color','b') ;
            axis([minmu,maxmu,0,1.0]) ;
%            title(titstr1,'FontSize',15) ;
            xlabel('\mu') ;
            ylabel(['Avg. Error Rate (prop. in ' num2str(ntest) ')']) ;

                tx = minmu + 0.1 * (maxmu - 0) ;
                ty = 0 + (0.9 * (1 - 0)) ;
%              text(tx,ty,'MD','Color','r','FontSize',12) ;
              text(tx,ty,'CRD','Color','r','FontSize',12) ;
                ty = 0 + (0.8 * (1 - 0)) ;
              text(tx,ty,'DWD','Color','m','FontSize',12) ;
                ty = 0 + (0.7 * (1 - 0)) ;
              text(tx,ty,'SVM','Color','b','FontSize',12) ;

            for id = 1:length(vd) ;
              hold on ;
                plot([minmu + 0.55 * (maxmu - minmu) ; ...
                      minmu + 0.75 * (maxmu - minmu)], ...
                     ones(2,1) * 0 + (1 - 0.1 * id) * (1 - 0), ...
                     ['k' mltypstr(id,:)],'LineWidth',2) ;
              hold off ;
              text(minmu + 0.8 * (maxmu - minmu), ...
                   0 + (1 - 0.1 * id) * (1 - 0), ...
                   ['d = ' num2str(vd(id))], ...
                   'Color','k') ;
            end ;

              hold on ;
                plot([minmu + 0.55 * (maxmu - minmu) ; ...
                      minmu + 0.75 * (maxmu - minmu)], ...
                     ones(2,1) * 0 + 0.5 * (1 - 0), ...
                     'k-','LineWidth',1) ;
                text(minmu + 0.8 * (maxmu - minmu), ...
                     0 + 0.5 * (1 - 0), ...
                    'Class X', ...
                    'Color','k') ;

                plot([minmu + 0.55 * (maxmu - minmu) ; ...
                      minmu + 0.75 * (maxmu - minmu)], ...
                     ones(2,1) * 0 + 0.4 * (1 - 0), ...
                     'k-','LineWidth',2) ;
                text(minmu + 0.8 * (maxmu - minmu), ...
                     0 + 0.4 * (1 - 0), ...
                    'Class Y', ...
                    'Color','k') ;

                plot([minmu + 0.55 * (maxmu - minmu) ; ...
                      minmu + 0.75 * (maxmu - minmu)], ...
                     ones(2,1) * 0 + 0.3 * (1 - 0), ...
                     'k-','LineWidth',4) ;
                text(minmu + 0.8 * (maxmu - minmu), ...
                     0 + 0.3 * (1 - 0), ...
                    'Overall', ...
                    'Color','k') ;

              hold off ;




          hold on ;
                        ph = plot(vmu',[ma2properrMD(:,1) ma2properrDWD(:,1) ma2properrSVM(:,1)],':', ...
                             'LineWidth',2) ;
              set(ph(1),'Color','r') ;
              set(ph(2),'Color','m') ;
              set(ph(3),'Color','b') ;

            ph = plot(vmu',[maproperrMD(:,1) maproperrDWD(:,1) maproperrSVM(:,1)],':', ...
                             'LineWidth',4) ;
              set(ph(1),'Color','r') ;
              set(ph(2),'Color','m') ;
              set(ph(3),'Color','b') ;


            ph = plot(vmu',[ma1properrMD(:,2) ma1properrDWD(:,2) ma1properrSVM(:,2)],'--', ...
                             'LineWidth',1) ;
              set(ph(1),'Color','r') ;
              set(ph(2),'Color','m') ;
              set(ph(3),'Color','b') ;

            ph = plot(vmu',[ma2properrMD(:,2) ma2properrDWD(:,2) ma2properrSVM(:,2)],'--', ...
                             'LineWidth',2) ;
              set(ph(1),'Color','r') ;
              set(ph(2),'Color','m') ;
              set(ph(3),'Color','b') ;

            ph = plot(vmu',[maproperrMD(:,2) maproperrDWD(:,2) maproperrSVM(:,2)],'--', ...
                             'LineWidth',4) ;
              set(ph(1),'Color','r') ;
              set(ph(2),'Color','m') ;
              set(ph(3),'Color','b') ;


            ph = plot(vmu',[ma1properrMD(:,3) ma1properrDWD(:,3) ma1properrSVM(:,3)],'-', ...
                             'LineWidth',1) ;
              set(ph(1),'Color','r') ;
              set(ph(2),'Color','m') ;
              set(ph(3),'Color','b') ;

            ph = plot(vmu',[ma2properrMD(:,3) ma2properrDWD(:,3) ma2properrSVM(:,3)],'-', ...
                             'LineWidth',2) ;
              set(ph(1),'Color','r') ;
              set(ph(2),'Color','m') ;
              set(ph(3),'Color','b') ;

            ph = plot(vmu',[maproperrMD(:,3) maproperrDWD(:,3) maproperrSVM(:,3)],'-', ...
                             'LineWidth',4) ;
              set(ph(1),'Color','r') ;
              set(ph(2),'Color','m') ;
              set(ph(3),'Color','b') ;

          hold off ;





        elseif ibw == 1 ;

          subplot(1,3,1) ;

            ph = plot(vmu',[ma1properrMD(:,1) ma1properrDWD(:,1) ma1properrSVM(:,1)],'k', ...
                             'LineWidth',1) ;
              set(ph(1),'LineStyle','-.') ;
              set(ph(2),'LineStyle','--') ;
              set(ph(3),'LineStyle','-') ;
              axis([minmu,maxmu,0,1.0]) ;
              title(['d = ' num2str(vd(1))]) ;
%              xlabel('\mu') ;
              ylabel(['Avg. Error Rate (prop. in ' num2str(ntest) ')']) ;

              hold on ;
                  tx = minmu + 0.3 * (maxmu - 0) ;
                  ty = 0 + (0.9 * (1 - 0)) ;
                  lxs = minmu + 0.6 * (maxmu - 0) ;
                  lxe = minmu + 0.9 * (maxmu - 0) ;
                text(tx,ty,'CRD','Color','k','FontSize',12) ;
                plot ([lxs; lxe],[ty; ty],'k-.'),
                  ty = 0 + (0.8 * (1 - 0)) ;
                text(tx,ty,'DWD','Color','k','FontSize',12) ;
                plot ([lxs; lxe],[ty; ty],'k--'),
                  ty = 0 + (0.7 * (1 - 0)) ;
                text(tx,ty,'SVM','Color','k','FontSize',12) ;
                plot ([lxs; lxe],[ty; ty],'k-'),

                ph = plot(vmu',[ma2properrMD(:,1) ma2properrDWD(:,1) ma2properrSVM(:,1)],'k', ...
                                 'LineWidth',2) ;
                  set(ph(1),'LineStyle','-.') ;
                  set(ph(2),'LineStyle','--') ;
                  set(ph(3),'LineStyle','-') ;

                ph = plot(vmu',[maproperrMD(:,1) maproperrDWD(:,1) maproperrSVM(:,1)],'k', ...
                                 'LineWidth',4) ;
                  set(ph(1),'LineStyle','-.') ;
                  set(ph(2),'LineStyle','--') ;
                  set(ph(3),'LineStyle','-') ;

              hold off ;


          subplot(1,3,2) ;

            ph = plot(vmu',[ma1properrMD(:,2) ma1properrDWD(:,2) ma1properrSVM(:,2)],'k', ...
                             'LineWidth',1) ;
              set(ph(1),'LineStyle','-.') ;
              set(ph(2),'LineStyle','--') ;
              set(ph(3),'LineStyle','-') ;
              axis([minmu,maxmu,0,1.0]) ;
              title(['d = ' num2str(vd(2))]) ;
%              xlabel('\mu') ;

              hold on ;
                plot([minmu + 0.6 * (maxmu - minmu) ; ...
                      minmu + 0.9 * (maxmu - minmu)], ...
                     ones(2,1) * 0 + 0.9 * (1 - 0), ...
                     'k-','LineWidth',1) ;
                text(minmu + 0.2 * (maxmu - minmu), ...
                     0 + 0.9 * (1 - 0), ...
                    'Class X', ...
                    'Color','k') ;

                plot([minmu + 0.6 * (maxmu - minmu) ; ...
                      minmu + 0.9 * (maxmu - minmu)], ...
                     ones(2,1) * 0 + 0.8 * (1 - 0), ...
                     'k-','LineWidth',2) ;
                text(minmu + 0.2 * (maxmu - minmu), ...
                     0 + 0.8 * (1 - 0), ...
                    'Class Y', ...
                    'Color','k') ;

                plot([minmu + 0.6 * (maxmu - minmu) ; ...
                      minmu + 0.9 * (maxmu - minmu)], ...
                     ones(2,1) * 0 + 0.7 * (1 - 0), ...
                     'k-','LineWidth',4) ;
                text(minmu + 0.2 * (maxmu - minmu), ...
                     0 + 0.7 * (1 - 0), ...
                    'Overall', ...
                    'Color','k') ;

                ph = plot(vmu',[ma2properrMD(:,2) ma2properrDWD(:,2) ma2properrSVM(:,2)],'k', ...
                                 'LineWidth',2) ;
                  set(ph(1),'LineStyle','-.') ;
                  set(ph(2),'LineStyle','--') ;
                  set(ph(3),'LineStyle','-') ;

                ph = plot(vmu',[maproperrMD(:,2) maproperrDWD(:,2) maproperrSVM(:,2)],'k', ...
                                 'LineWidth',4) ;
                  set(ph(1),'LineStyle','-.') ;
                  set(ph(2),'LineStyle','--') ;
                  set(ph(3),'LineStyle','-') ;

              hold off ;


          subplot(1,3,3) ;

            ph = plot(vmu',[ma1properrMD(:,3) ma1properrDWD(:,3) ma1properrSVM(:,3)],'k', ...
                             'LineWidth',1) ;
              set(ph(1),'LineStyle','-.') ;
              set(ph(2),'LineStyle','--') ;
              set(ph(3),'LineStyle','-') ;
              axis([minmu,maxmu,0,1.0]) ;
              title(['d = ' num2str(vd(3))]) ;
%              xlabel('\mu') ;

              hold on ;

                ph = plot(vmu',[ma2properrMD(:,3) ma2properrDWD(:,3) ma2properrSVM(:,3)],'k', ...
                                 'LineWidth',2) ;
                  set(ph(1),'LineStyle','-.') ;
                  set(ph(2),'LineStyle','--') ;
                  set(ph(3),'LineStyle','-') ;

                ph = plot(vmu',[maproperrMD(:,3) maproperrDWD(:,3) maproperrSVM(:,3)],'k', ...
                                 'LineWidth',4) ;
                  set(ph(1),'LineStyle','-.') ;
                  set(ph(2),'LineStyle','--') ;
                  set(ph(3),'LineStyle','-') ;


              hold off ;


        end ;



  if ibw == 0 ;
      pstr = 'GeomRepHDLSS1figF' ;
      orient portrait ;
      set(gcf,'PaperSize',[6.0, 4.1]) ; 
      set(gcf,'PaperPosition',[0.25, 0.25, 5.0, 3.6]) ; 
    print('-dpsc', [pstr '.ps']) ;
  elseif ibw == 1 ;
      pstr = 'GeomRepHDLSS1figFbw' ;
      orient portrait ;
      set(gcf,'PaperSize',[8.0, 3.1]) ; 
      set(gcf,'PaperPosition',[0.25, 0.25, 7.5, 2.6]) ; 
    print('-dps2', [pstr '.ps']) ;
  end ;









