disp('Running MATLAB script file DWD1figE.m') ;
%
%    Makes Figure E for the DWD paper
%
%    Copied from HDD1sum1.m, which did:
%
%
%    For summarization of simulations from HDD1sim1.m
%    High Dimension Discrimination


ioutput = 2 ;    %  1 - Figure for paper
                 %  2 - Big Version for Talks


isum = [1] ;
                %  Vector of indices for summarization type
                %  1   - Compare MD, DWD, SVMPA mean Err Rate, mean Angle
                

idat = [1] ;
                  %  Vector of indices of data type
                  %  1 - mu = +-2.2, dim 1, d from vitest
                  %  2 - times 0.5, for d > 1, d from vitest
                  %  3 - times 2, for d > 1, d from vitest
                  %  4 - +-Chi Square 1, for d > 1, d from vitest
                  %  5 - +-log normal, for d > 1, d from vitest
                  %  6 - mu = +-2.2, dim 1, and for 20%:
                  %            +-100, dim 1 & +- 500, dim 2
                  %  7 - mu = +-2.2, dim 1, and for 10%:
                  %            +-0.1, dim 1 +- 100, same rand dim
                  %  8 - mu = +-5, others * 10
                  %  9 - donut, d/2, Embed 2, Rot'd



vimeth = [1 11 114 200] ;
%colorchararray = char('r','m','b','g') ;
%linearray = char('-', ':', '--', ':');
vidim = [1 2 3 4 5] ;
                %  Vector of indices of dimension
                %  1 - d = 10
                %  2 - d = 40
                %  3 - d = 100
                %  4 - d = 400
                %  5 - d = 1600


%  set up parameters
%
nsim = 100 ;
np = 25 ;
nn = 25 ;
ntest = 200 ;

vmeaner2 = [];
vcier2 = [];

if idat == 1 ;
  datstr = 'mu +-2.2, dim 1' ;
elseif idat == 2 ;
  datstr = 'mu +-2.2 & * 0.5' ;
elseif idat == 3 ;
  datstr = 'mu +-2.2 & * 2' ;
elseif idat == 4 ;
  datstr = 'mu +-2.2 & ChiSq1' ;
elseif idat == 5 ;
  datstr = 'mu +-2.2 & log-N' ;
elseif idat == 6 ;
  datstr = 'mu +-2.2 & 20% out' ;
elseif idat == 7 ;
  datstr = 'mu +-2.2 & 10% wobble' ;
elseif idat == 8 ;
  datstr = 'mu +-5 & * 10' ;
elseif idat == 9 ;
  datstr = 'Donut, Embed2, Rot' ;
end ;


%  Start Main graphics
%
figure(1) ;
clf ;

plot([0.5; 3.5],[0.5; 0.5],'k-') ;
if ioutput == 1 ;
  axis([0.5,3.5,0,0.25]) ;
  xlabel('log_{10}(dimension)') ;
  ylabel('Proportion Wrong') ;
elseif ioutput == 2 ;
  title(['Average Error Rate, ' datstr],'FontSize',15) ;
  axis([0.5,3.5,0,0.6]) ;
  xlabel('log_{10}(dimension)','FontSize',15) ;
  ylabel('Proportion Wrong','FontSize',15) ;
end ;


methcount = 0 ;
for imeth = vimeth ;    %    loop through discrimination methods

  methcount = methcount + 1 ;

  if imeth == 1 ;
%    methstr = 'Mean Difference' ;
    methstr = 'MD' ;
    methoutstr = 'MD' ;
    imethin = 1 ;
    methpar = [] ;
    linetype = 'r-';
  elseif imeth == 2 ;
    methstr = 'Correlation' ;
    methoutstr = 'C' ;
    imethin = 2 ;
    methpar = [] ;
  elseif imeth == 11 ;
%    methstr = 'DWD 1' ;
    methstr = 'DWD' ;
    methoutstr = 'DWD1' ;
    imethin = 11 ;
    methpar = [] ;
    linetype = 'm-.';
  elseif imeth == 21 ;
    methstr = 'OSP 1' ;
    methoutstr = 'OSP1' ;
    methpar = [] ;
    imethin = 21 ;
  elseif imeth == 101 ;
    methstr = '1 - NN' ;
    methoutstr = 'NN1' ;
    imethin = 3 ;
    methpar = 1 ;
  elseif imeth == 102 ;
    methstr = '5 - NN' ;
    methoutstr = 'NN5' ;
    imethin = 3 ;
    methpar = 5 ;
  elseif imeth == 103 ;
    methstr = '11 - NN' ;
    methoutstr = 'NN11' ;
    imethin = 3 ;
    methpar = 11 ;
  elseif imeth == 104 ;
    methstr = '21 - NN' ;
    methoutstr = 'NN21' ;
    imethin = 3 ;
    methpar = 21 ;
  elseif imeth == 111 ;
    C = 10^3 ;
    methstr = 'SVM, C = 10^3' ;
    methoutstr = 'SVM3' ;
    imethin = 4 ;
    methpar = C ;
elseif imeth == 112 ;
    C = 10^(-6) ;
    methstr = 'SVM, C = 10^{-6}' ;
    methoutstr = 'SVMm6' ;
    imethin = 4 ;
    methpar = C ;
  elseif imeth == 113 ;
    C = 10^(12) ;
    methstr = 'SVM, C = 10^{12}' ;
    methoutstr = 'SVM12' ;
    imethin = 4 ;
    methpar = C ;
  elseif imeth == 114 ;
%    methstr = 'SVM, PWD Adj.' ;
    methstr = 'SVM' ;
    methoutstr = 'SVMPA' ;
    imethin = 4 ;
    methpar = -100 ;
    linetype = 'b--';    
  elseif imeth == 200 ;
    C = 10^(12) ;
    methstr = 'RLR' ;
    methoutstr = 'RLR' ;
    imethin = 4 ;
    methpar = C ;    
    linetype = 'k:';
  end ;



  %  loop through dimensions
  %
  vdim = [] ;
  vmeaner = [] ;
  vsder = [] ;
  vmeanang = [] ;
  vsdang = [] ;
  for idim = vidim ;


    if idim == 1 ;
      d = 10 ;
    elseif idim == 2 ;
      d = 40 ;
    elseif idim == 3 ;
      d = 100 ;
    elseif idim == 4 ;
      d = 400 ;
    elseif idim == 5 ;
      d = 1600 ;
    end ;

    vdim = [vdim; d] ;

        if imeth ~= 200;
            load(['d:\Ahn\Papers\DWD\Sim\SimSummaries\HDD1sim' methoutstr 'dat' num2str(idat) 'd' num2str(d)]) ;
  
        elseif imeth == 200;
            vproperr = load(['d:\Ahn\Papers\DWD\Sim\RLR\fig5d' num2str(d) '.txt']);
            
        end;

    meaner = mean(vproperr) ;
    sder = std(vproperr) ;

    vmeaner = [vmeaner ; meaner] ;
    vsder = [vsder ; sder] ;
    vcier = 1.96 * vsder / sqrt(nsim - 1) ;

    if ~isempty(vangle) ;
      meanang = mean(vangle) ;
      sdang = std(vangle) ;
    
      vmeanang = [vmeanang ; meanang] ;
      vsdang = [vsdang ; sdang] ;
      vciang = 1.96 * vsdang / sqrt(nsim - 1) ;
    end ;


  end ;    %  of idim loop

%  Add these curves to plot
  %
  hold on ;
  %plot(log10(vdim),vmeaner, [colorchararray(methcount) '-']) ;
  plot(log10(vdim),vmeaner, linetype) ;
    
  %errorbar(log10(vdim),vmeaner,vcier,vcier, [colorchararray(methcount) '-']) ;
  errorbar(log10(vdim),vmeaner,vcier,vcier, linetype) ;
  
    %vax = axis ;
    %  tx = vax(1) + 0.1 * (vax(2) - vax(1)) ;
    %  ty = vax(3) + (1 - 0.1 * methcount) * (vax(4) - vax(3)) ;
    %if ioutput == 1 ;
    %  text(tx,ty,methstr,'Color',colorchararray(methcount)) ;
    %elseif ioutput == 2 ;
    %  text(tx,ty,methstr,'Color',colorchararray(methcount), ...
    %                                'FontSize',15) ;
    %end ;
  hold off ;

  
end ;    %  of imeth loop

legend('r-','MD', 'm-.','DWD', 'b--', 'SVM' , 'k:','RLR',2); 

 

if ioutput == 1 ;

    pstr = 'DWD1figE' ;
    orient portrait ;
    set(gcf,'PaperSize',[6.0, 4.1]) ; 
    set(gcf,'PaperPosition',[0.25, 0.25, 5.0, 3.6]) ; 
  print('-dpsc2', [pstr '.ps']) ;

elseif ioutput == 2 ;

  pstr = 'DWD1figEBig' ;
  orient landscape ;
  print('-dpsc2', pstr) ;

end ;




