disp('Running MATLAB script file hdd1SMtest.m') ;
%
%    FOR DEVELOPMENT AND TESTING OF MATLAB FUNCTION hdd1SM,
%    High Dimension Discrimination, version 1
%    Based on Mike Todd's SDPT3 - sep Optimization

vitest = [1] ;
                %  Vector of indices of test type:
                %  1 - Just try discrimination, 
                %             and report counts from 100 new data values


vidat = [1] ;
                  %  Vector of indices of data type
                  %  1 - Two Meatball data (from ICAeg2.m), n1 = n2 = 100
                  %          (use this only with itest = 1)
                  %  2 - Toy 4 point data (for easy plotting of OSP)


vimeth = [11] ;
%vimeth = [101 102 103 104] ;
%vimeth = [111 112 113] ;
%vimeth = [1 2 11 101 102 103 104 111 112 113 114] ;
%vimeth = [1 11 111 112 113] ;
%vimeth = [111 112 113 114] ;
                    %  Vector of indices on discrimination methods
                    %  1 - Mean Difference Discrimination
                    %  2 - Correlation Discrimination
                    %  11 - DWD 1, penalty factor = 100
                    %  21 - OSP 
                    %  101 - NN - 1
                    %  102 - NN - 5
                    %  103 - NN - 11
                    %  104 - NN - 21
                    %  111 - SVM, C = 10^3
                    %  112 - SVM, C = 10^(-6)
                    %  113 - SVM, C = 10^(12)
                    %  114 - SVM, penalty factor = 100




for itest = vitest ;


  if itest == 1 ;    %  Simple attempt at discrimination,
                     %    reporting counts from 100 new data values


    for idat = vidat ;    %    loop through data examples

      if idat == 1 ;    %  Two meatball data

        %  set up parameters
        %
        seed = 20943343 ;
        randn('state',seed) ;
        n = 100 ;
        datstr = 'Two Meatball Data' ;

        %  generate data
        %
        trainp = randn(2,n) ;
        trainp = [1.5 + 0.5 * trainp(1,:); 1.0 + 0.5 * trainp(2,:)] ;
        trainn = randn(2,n) ;
        trainn = [-1.5 + 0.5 * trainn(1,:); -1.0 + 0.5 * trainn(2,:)] ;

        testp = randn(2,n) ;
        testp = [1.5 + 0.5 * testp(1,:); 1.0 + 0.5 * testp(2,:)] ;
        testn = randn(2,n) ;
        testn = [-1.5 + 0.5 * testn(1,:); -1.0 + 0.5 * testn(2,:)] ;

        data = [testp testn] ;


      elseif idat == 2 ;

        trainp = [[1;2] [2;1]] ;
        trainn = [[-2;-2] [-1;-2]] ;
        data = [0; 0] ;

        n = 1 ;
        datstr = 'Toy Data for plotting OSP' ;


      else ;
        disp(['!!!  Warning: itest = 1, not programmed for this idat !!!']) ;
      end ;    %  of idat if-block



      for imeth = vimeth ;

        if imeth == 1 ;
          methstr = 'Mean Difference' ;
          methoutstr = 'MD' ;
          imethin = 1 ;
          methpar = [] ;
        elseif imeth == 2 ;
          methstr = 'Correlation' ;
          methoutstr = 'C' ;
          imethin = 2 ;
          methpar = [] ;
        elseif imeth == 11 ;
          methstr = 'DWD 1' ;
          methoutstr = 'DWD1' ;
          imethin = 11 ;
          methpar = [] ;
        elseif imeth == 21 ;
          methstr = 'OSP 1' ;
          methoutstr = 'OSP1' ;
          methpar = [] ;
          imethin = 21 ;
        elseif imeth == 101 ;
          methstr = '1 - NN' ;
          methoutstr = 'NN1' ;
          imethin = 3 ;
          methpar = 1 ;
        elseif imeth == 102 ;
          methstr = '5 - NN' ;
          methoutstr = 'NN5' ;
          imethin = 3 ;
          methpar = 5 ;
        elseif imeth == 103 ;
          methstr = '11 - NN' ;
          methoutstr = 'NN11' ;
          imethin = 3 ;
          methpar = 11 ;
        elseif imeth == 104 ;
          methstr = '21 - NN' ;
          methoutstr = 'NN21' ;
          imethin = 3 ;
          methpar = 21 ;
        elseif imeth == 111 ;
          C = 10^3 ;
          methstr = 'SVM, C = 10^3' ;
          methoutstr = 'SVM3' ;
          imethin = 4 ;
          methpar = C ;
        elseif imeth == 112 ;
          C = 10^(-6) ;
          methstr = 'SVM, C = 10^(-6)' ;
          methoutstr = 'SVMm6' ;
          imethin = 4 ;
          methpar = C ;
        elseif imeth == 113 ;
          C = 10^(12) ;
          methstr = 'SVM, C = 10^(12)' ;
          methoutstr = 'SVM12' ;
          imethin = 4 ;
          methpar = C ;
        elseif imeth == 114 ;
          methstr = 'SVM, PWD Adj.' ;
          methoutstr = 'SVMPA' ;
          imethin = 4 ;
          methpar = -100 ;
        end ;

        if isempty(methpar) ;
          dr = hdd1SM(data,trainp,trainn,imethin) ;
        else ;
          dr = hdd1SM(data,trainp,trainn,imethin,methpar) ;
        end ;


        if isempty(dr) ;
          numerr = 2 * n ;
        else ;          
          verr = (dr ~= [ones(1,n) -ones(1,n)]) ;
              %  one where got wrong answer
          numerr = sum(verr) ;
        end ;

        disp(['    For the ' datstr ', using ' methstr]) ;
        disp(['      # of Errors = ' num2str(numerr)]) ;


        pauseSM ;


      end ;    %  of imeth loop, through discrimination methods



    end ;    %  of idat loop



  end ;    %  of itest if-block


end ;    %  of itest loop





