disp('Running MATLAB script file hdd1sum1.m') ;
%
%    For summarization of simulations from HDD1sim1.m
%    High Dimension Discrimination


visum = [5] ;
                %  Vector of indices for summarization type
                %  1   - Compare MD, DWD, SVMPA mean Err Rate, mean Angle
                %  2   - Compare DWD, NN1, NN5, NN11, NN21 
                %                               mean Err Rate, mean Angle
                %  3   - Compare DWD, SVM3, SVM12, SVMm3, SVMPA
                %                               mean Err Rate, mean Angle
                %  4   - Compare DWD, OSP, SVMPA
                %                               mean Err Rate, mean Angle
                %  5   - Compare DWD, DWD 10^6, SVMPA
                %                               mean Err Rate, mean Angle
                %  101 - Compare MD, DWD, SVMPA 
                %                    for angular similarity of directions
                %  103 - Compare DWD, SVM3, SVM12, SVMm3, SVMPA 
                %                    for angular similarity of directions
                

vidat = [10 11] ;
%vidat = [1 2] ;
%vidat = [1 6 7] ;
%vidat = [1 2 3 4 5 6 7 8 9] ;
%vidat = [6 7 8 9] ;
                  %  Vector of indices of data type
                  %  1 - mu = +-2.2, dim 1, d from vitest
                  %  2 - times 0.5, for d > 1, d from vitest
                  %  3 - times 2, for d > 1, d from vitest
                  %  4 - +-Chi Square 1, for d > 1, d from vitest
                  %  5 - +-log normal, for d > 1, d from vitest
                  %  6 - mu = +-2.2, dim 1, and for 20%:
                  %            +-100, dim 1 & +- 500, dim 2
                  %  7 - mu = +-2.2, dim 1, and for 10%:
                  %            +-0.1, dim 1 +- 100, same rand dim
                  %  8 - mu = +-5, others * 10
                  %  9 - donut, d/2, Embed 2, Rot'd
                  %  10 - mu = +-2, dim1, and 75% Class+ at 100
                  %  11 - mu = +-2, d1 (mirrored), 75% C+ at 100



for isum = visum ;


  if  isum == 1  | ...
      isum == 2  | ...
      isum == 3  | ...
      isum == 4  | ...
      isum == 5  ;     %  Summarize with mean Err Rate, mean Angle


    if isum == 1 ;     %  Compare MD, DWD, SVMPA
      vimeth = [1 11 114] ;
      colorchararray = char('r','m','b') ;
    elseif isum == 2 ;     %  Compare DWD, NN1, NN5, NN11, NN21
      vimeth = [11 101 102 103 104] ;
      colorchararray = char('m','g','c','r','b') ;
    elseif isum == 3 ;     %  Compare DWD, SVM3, SVM12, SVMm3, SVMPA
      vimeth = [11 111 112 113 114] ;
      colorchararray = char('m','r','g','c','b') ;
    elseif isum == 4 ;     %  Compare DWD, OSP, SVMPA
      vimeth = [11 21 114] ;
      colorchararray = char('m','g','b') ;
    elseif isum == 5 ;     %  Compare DWD, DWD 10^6, SVMPA
      vimeth = [11 12 114] ;
      colorchararray = char('m','g','b') ;
    end ;
                    %  Vector of indices on discrimination methods
                    %  1 - Mean Difference Discrimination
                    %  2 - Correlation Discrimination
                    %  11 - DWD 1, penalty factor = 100
                    %  12 - DWD 1, penalty factor = 10^6
                    %  21 - OSP 
                    %  101 - NN - 1
                    %  102 - NN - 5
                    %  103 - NN - 11
                    %  104 - NN - 21
                    %  111 - SVM, C = 10^3
                    %  112 - SVM, C = 10^(-6)
                    %  113 - SVM, C = 10^(12)
                    %  114 - SVM, penalty factor = 100

    vidim = [1 2 3 4 5] ;
                    %  Vector of indices of dimension
                    %  1 - d = 10
                    %  2 - d = 40
                    %  3 - d = 100
                    %  4 - d = 400
                    %  5 - d = 1600


    %  set up parameters
    %
    nsim = 100 ;
    np = 25 ;
    nn = 25 ;
    ntest = 200 ;



    for idat = vidat ;    %    loop through data examples


      if idat == 1 ;
        datstr = 'mu +-2.2, dim 1' ;
      elseif idat == 2 ;
        datstr = 'mu +-2.2 & * 0.5' ;
      elseif idat == 3 ;
        datstr = 'mu +-2.2 & * 2' ;
      elseif idat == 4 ;
        datstr = 'mu +-2.2 & ChiSq1' ;
      elseif idat == 5 ;
        datstr = 'mu +-2.2 & log-N' ;
      elseif idat == 6 ;
        datstr = 'mu +-2.2 & 20% out' ;
      elseif idat == 7 ;
        datstr = 'mu +-2.2 & 10% wobble' ;
      elseif idat == 8 ;
        datstr = 'mu +-5 & * 10' ;
      elseif idat == 9 ;
        datstr = 'Donut, Embed2, Rot' ;
      elseif idat == 10 ;
        datstr = ['mu +-2, & 75% right'] ;
      elseif idat == 11 ;
        datstr = ['mu +-2, 75% R (Mir)'] ;
      end ;


      %  Start Main graphics
      %
      figure(1) ;
      clf ;

      subplot(2,2,1) ;
        plot([0.5; 3.5],[0.5; 0.5],'k-') ;
        title('Average Error Rate','FontSize',15) ;
        axis([0.5,3.5,0,0.6]) ;
        xlabel('log_{10}(dimension)','FontSize',15) ;
        ylabel('Proportion Wrong','FontSize',15) ;

      subplot(2,2,2) ;
        set(gca,'Box','on') ;
        title('Standard Deviation of Error Rate','FontSize',15) ;
        axis([0.5,3.5,0,0.1]) ;
        xlabel('log_{10}(dimension)','FontSize',15) ;
        ylabel('S. D. Proportion Wrong)','FontSize',15) ;

      subplot(2,2,3) ;
        plot([0.5; 3.5],log10([0.5; 0.5]),'k-') ;
        title(datstr,'FontSize',15) ;
        axis([0.5,3.5,-2.5,0]) ;
        xlabel('log_{10}(dimension)','FontSize',15) ;
        ylabel('log_{10}(Proportion Wrong)','FontSize',15) ;

      subplot(2,2,4) ;
        set(gca,'Box','on') ;
        title('Average Angle from Optimal','FontSize',15) ;
        axis([0.5,3.5,0,90]) ;
        xlabel('log_{10}(dimension)','FontSize',15) ;
        ylabel('Angle (degrees)','FontSize',15) ;


      methcount = 0 ;
      for imeth = vimeth ;    %    loop through discrimination methods

        methcount = methcount + 1 ;

        if imeth == 1 ;
          methstr = 'Mean Difference' ;
          methoutstr = 'MD' ;
          imethin = 1 ;
          methpar = [] ;
        elseif imeth == 2 ;
          methstr = 'Correlation' ;
          methoutstr = 'C' ;
          imethin = 2 ;
          methpar = [] ;
        elseif imeth == 11 ;
          methstr = 'DWD 1' ;
          methoutstr = 'DWD1' ;
          imethin = 11 ;
          methpar = [] ;
        elseif imeth == 12 ;
          methstr = 'DWD, 10^6' ;
          methoutstr = 'DWDM' ;
          imethin = 11 ;
          methpar = 10^6 ;
        elseif imeth == 21 ;
          methstr = 'OSP 1' ;
          methoutstr = 'OSP1' ;
          methpar = [] ;
          imethin = 21 ;
        elseif imeth == 101 ;
          methstr = '1 - NN' ;
          methoutstr = 'NN1' ;
          imethin = 3 ;
          methpar = 1 ;
        elseif imeth == 102 ;
          methstr = '5 - NN' ;
          methoutstr = 'NN5' ;
          imethin = 3 ;
          methpar = 5 ;
        elseif imeth == 103 ;
          methstr = '11 - NN' ;
          methoutstr = 'NN11' ;
          imethin = 3 ;
          methpar = 11 ;
        elseif imeth == 104 ;
          methstr = '21 - NN' ;
          methoutstr = 'NN21' ;
          imethin = 3 ;
          methpar = 21 ;
        elseif imeth == 111 ;
          C = 10^3 ;
          methstr = 'SVM, C = 10^3' ;
          methoutstr = 'SVM3' ;
          imethin = 4 ;
          methpar = C ;
        elseif imeth == 112 ;
          C = 10^(-6) ;
          methstr = 'SVM, C = 10^{-6}' ;
          methoutstr = 'SVMm6' ;
          imethin = 4 ;
          methpar = C ;
        elseif imeth == 113 ;
          C = 10^(12) ;
          methstr = 'SVM, C = 10^{12}' ;
          methoutstr = 'SVM12' ;
          imethin = 4 ;
          methpar = C ;
        elseif imeth == 114 ;
          methstr = 'SVM, PWD Adj.' ;
          methoutstr = 'SVMPA' ;
          imethin = 4 ;
          methpar = -100 ;
        end ;



        %  loop through dimensions
        %
        vdim = [] ;
        vmeaner = [] ;
        vsder = [] ;
        vmeanang = [] ;
        vsdang = [] ;
        for idim = vidim ;


          if idim == 1 ;
            d = 10 ;
          elseif idim == 2 ;
            d = 40 ;
          elseif idim == 3 ;
            d = 100 ;
          elseif idim == 4 ;
            d = 400 ;
          elseif idim == 5 ;
            d = 1600 ;
          end ;

          vdim = [vdim; d] ;


          load(['SimSummaries\HDD1sim' methoutstr ...
                    'dat' num2str(idat) 'd' num2str(d)]) ;


          meaner = mean(vproperr) ;
          sder = std(vproperr) ;

          vmeaner = [vmeaner ; meaner] ;
          vsder = [vsder ; sder] ;
          vcier = 1.96 * vsder / sqrt(nsim - 1) ;

          if ~isempty(vangle) ;
            meanang = mean(vangle) ;
            sdang = std(vangle) ;
          
            vmeanang = [vmeanang ; meanang] ;
            vsdang = [vsdang ; sdang] ;
            vciang = 1.96 * vsdang / sqrt(nsim - 1) ;
          end ;


        end ;    %  of idim loop


        %  Add these curves to plot
        %
        subplot(2,2,1) ;
          hold on ;
            plot(log10(vdim),vmeaner,[colorchararray(methcount) '-']) ;
            errorbar(log10(vdim),vmeaner,vcier,vcier, ...
                              [colorchararray(methcount) '-']) ;
              vax = axis ;
              tx = vax(1) + 0.1 * (vax(2) - vax(1)) ;
              ty = vax(3) + (1 - 0.1 * methcount) * (vax(4) - vax(3)) ;
            text(tx,ty,methstr,'Color',colorchararray(methcount), ...
                                            'FontSize',15) ;
          hold off ;

        subplot(2,2,2) ;
          hold on ;
            plot(log10(vdim),vsder,[colorchararray(methcount) '-']) ;
              vax = axis ;
              tx = vax(1) + 0.1 * (vax(2) - vax(1)) ;
              ty = vax(3) + (1 - 0.1 * methcount) * (vax(4) - vax(3)) ;
            text(tx,ty,methstr,'Color',colorchararray(methcount), ...
                                            'FontSize',15) ;
          hold off ;

        subplot(2,2,3) ;
          hold on ;
            plot(log10(vdim),log10(vmeaner),[colorchararray(methcount) '-']) ;
              vax = axis ;
              tx = vax(1) + 0.1 * (vax(2) - vax(1)) ;
              ty = vax(3) + (1 - 0.1 * methcount) * (vax(4) - vax(3)) ;
            text(tx,ty,methstr,'Color',colorchararray(methcount), ...
                                            'FontSize',15) ;
          hold off ;

        subplot(2,2,4) ;
          hold on ;
            if ~isempty(vangle) ;
              plot(log10(vdim),vmeanang,[colorchararray(methcount) '-']) ;
              errorbar(log10(vdim),vmeanang,vciang,vciang, ...
                                [colorchararray(methcount) '-']) ;
            end ;
              vax = axis ;
              tx = vax(1) + 0.1 * (vax(2) - vax(1)) ;
              ty = vax(3) + (1 - 0.1 * methcount) * (vax(4) - vax(3)) ;
            text(tx,ty,methstr,'Color',colorchararray(methcount), ...
                                            'FontSize',15) ;
          hold off ;


      end ;    %  of imeth loop



      %  Save this summarization plot
      %
      orient landscape ;
      print('-dpsc2',['SimPlots\HDD1sum1P' num2str(isum) ...
                      'dat' num2str(idat)]) ;



    end ;    %  of idat loop



  elseif  isum == 101  | ...
          isum == 103  ;     %  Compare direction vectors


    if isum == 101 ;
      vimeth = [1 11 114] ;
    elseif isum == 103 ;
      vimeth = [11 111 112 113 114] ;
    end ;
                    %  1 - Mean Difference Discrimination
                    %  2 - Correlation Discrimination
                    %  11 - DWD 1, penalty factor = 100
                    %  12 - DWD 1, penalty factor = 10^6
                    %  21 - OSP 
                    %  101 - NN - 1
                    %  102 - NN - 5
                    %  103 - NN - 11
                    %  104 - NN - 21
                    %  111 - SVM, C = 10^3
                    %  112 - SVM, C = 10^(-6)
                    %  113 - SVM, C = 10^(12)
                    %  114 - SVM, penalty factor = 100

    vidim = [1 2 3 4 5] ;
                    %  Vector of indices of dimension
                    %  1 - d = 10
                    %  2 - d = 40
                    %  3 - d = 100
                    %  4 - d = 400
                    %  5 - d = 1600


    figure(1) ;
    clf ;


    %  set up parameters
    %
    nsim = 100 ;
    np = 25 ;
    nn = 25 ;
    ntest = 200 ;

    colormap(hot(91)) ;


    for idat = vidat ;    %    loop through data examples


      if idat == 1 ;
        datstr = 'mu +-2.2, dim 1' ;
      elseif idat == 2 ;
        datstr = 'mu +-2.2 & * 0.5' ;
      elseif idat == 3 ;
        datstr = 'mu +-2.2 & * 2' ;
      elseif idat == 4 ;
        datstr = 'mu +-2.2 & ChiSq1' ;
      elseif idat == 5 ;
        datstr = 'mu +-2.2 & log-N' ;
      elseif idat == 6 ;
        datstr = 'mu +-2.2 & 20% out' ;
      elseif idat == 7 ;
        datstr = 'mu +-2.2 & 10% wobble' ;
      elseif idat == 8 ;
        datstr = 'mu +-5 & * 10' ;
      elseif idat == 9 ;
        datstr = 'Donut, Embed2, Rot' ;
      elseif idat == 10 ;
        datstr = 'mu +-2, & 75% right' ;
      elseif idat == 11 ;
        datstr = 'mu +-2, 75% R (Mir)' ;
      end ;


      %  loop through dimensions
      %
      for idim = vidim ;

        if idim == 1 ;
          d = 10 ;
        elseif idim == 2 ;
          d = 40 ;
        elseif idim == 3 ;
          d = 100 ;
        elseif idim == 4 ;
          d = 400 ;
        elseif idim == 5 ;
          d = 1600 ;
        end ;



        methcount = 0 ;
        a3ddirvec = [] ;
        for imeth = vimeth ;    %    loop through discrimination methods

          methcount = methcount + 1 ;

          if imeth == 1 ;
            methstr = 'Mean Difference' ;
            methoutstr = 'MD' ;
            imethin = 1 ;
            methpar = [] ;
          elseif imeth == 2 ;
            methstr = 'Correlation' ;
            methoutstr = 'C' ;
            imethin = 2 ;
            methpar = [] ;
          elseif imeth == 11 ;
            methstr = 'DWD 1' ;
            methoutstr = 'DWD1' ;
            imethin = 11 ;
            methpar = [] ;
          elseif imeth == 12 ;
            methstr = 'DWD, 10^6' ;
            methoutstr = 'DWDM' ;
            imethin = 11 ;
            methpar = 10^6 ;
          elseif imeth == 21 ;
            methstr = 'OSP 1' ;
            methoutstr = 'OSP1' ;
            methpar = [] ;
            imethin = 21 ;
          elseif imeth == 101 ;
            methstr = '1 - NN' ;
            methoutstr = 'NN1' ;
            imethin = 3 ;
            methpar = 1 ;
          elseif imeth == 102 ;
            methstr = '5 - NN' ;
            methoutstr = 'NN5' ;
            imethin = 3 ;
            methpar = 5 ;
          elseif imeth == 103 ;
            methstr = '11 - NN' ;
            methoutstr = 'NN11' ;
            imethin = 3 ;
            methpar = 11 ;
          elseif imeth == 104 ;
            methstr = '21 - NN' ;
            methoutstr = 'NN21' ;
            imethin = 3 ;
            methpar = 21 ;
          elseif imeth == 111 ;
            C = 10^3 ;
            methstr = 'SVM, C = 10^3' ;
            methoutstr = 'SVM3' ;
            imethin = 4 ;
            methpar = C ;
          elseif imeth == 112 ;
            C = 10^(-6) ;
            methstr = 'SVM, C = 10^(-6)' ;
            methoutstr = 'SVMm6' ;
            imethin = 4 ;
            methpar = C ;
          elseif imeth == 113 ;
            C = 10^(12) ;
            methstr = 'SVM, C = 10^(12)' ;
            methoutstr = 'SVM12' ;
            imethin = 4 ;
            methpar = C ;
          elseif imeth == 114 ;
            methstr = 'SVM, PWD Adj.' ;
            methoutstr = 'SVMPA' ;
            imethin = 4 ;
            methpar = -100 ;
          end ;


          if imeth == vimeth(1) ;
            camethstr = methoutstr ;
          else ;
            camethstr = char(camethstr,methoutstr) ;
          end ;


          load(['SimSummaries\HDD1sim' methoutstr ...
                    'dat' num2str(idat) 'd' num2str(d)]) ;


          a3ddirvec = cat(3,a3ddirvec,mdirvec) ;



        end ;    %  of imeth loop



        %  Compute average angles
        %
        nmeth = length(vimeth) ;
        mout = zeros(nmeth,nmeth) ;
        for iimeth = 1:nmeth ;

          for iimethinner = (iimeth+1):nmeth ;

            avgang = mean((180 / pi) * acos(sum( ...
                              a3ddirvec(:,:,iimeth) .* ...
                                   a3ddirvec(:,:,iimethinner),1))) ;
            mout(iimeth,iimethinner) = avgang ;
            mout(iimethinner,iimeth) = avgang ;

          end ;    %  of iimethinner loop

        end ;    %  of iimeth loop

        mout = real(mout) ;
            %  seem to get complex values due to roundoff


        %  Make Angular comparison image plot
        %
        subplot(2,3,idim) ;
          image(mout+1) ;
              %  +1, since will map numbers 0-90 
              %  into indices of colormap
          title(['Avg. Dir''n Angles, d = ' num2str(d)]) ;
          axis image ;
          set(gca,'XTickMode','manual') ;
          set(gca,'XTickLabel',camethstr) ;
          set(gca,'YTickMode','manual') ;
          set(gca,'YTickLabel',camethstr) ;



      end ;    %  of idim loop



      subplot(2,3,6) ;
        title(datstr) ;
        colorbar ;



      %  Save this summarization plot
      %
      orient landscape ;
      print('-dpsc2',['SimPlots\HDD1sum1P' num2str(isum) ...
                      'dat' num2str(idat)]) ;



    end ;    %  of idat loop


  end ;    %  of itest if-block


end ;    %  of itest loop





