disp('Running MATLAB script file LongDat1fig1A.m') ;
%
%    Makes Figure 1A for the Longitudinal Data Analysis paper
%
%    Copied from \Research\ComplexPopn\ToyExamples\EGCurvDat1.m, which:
%
%    makes toy curves as data examples
%
%    uses:
%
%         idat = 3      %  Example from classes\322\s322eg12.m  "Parabs"
%
%         ipart = 0 ;    %  0  -  Raw Data
%                        %  1  -  Standard PCA



%  Generate data
%
datastr = 'Parabolas' ;
d = 10 ;
n = 50 ;
xgrid = (.5:1:d)' ;
mdata = (xgrid - 6).^2 ;
  randn('seed',88769874) ;
  eps1 = 4 * randn(1,n) ;
  eps2 = .5 * randn(1,n) ;
  eps3 = 1 * randn(d,n) ;
mdata = vec2matSM(mdata,n) + vec2matSM(eps1,d) + ...
               vec2matSM(eps2,d) .* vec2matSM(xgrid-d/2,n) + eps3 ;



%  make main graphic
%
figure(1) ;
clf ;

d = size(mdata,1) ;
         %  dimension of each data curve
n = size(mdata,2) ;
         %  number of data curves

xgrid = (1:d)' ;
min1 = min(min(mdata)) ;
max1 = max(max(mdata)) ;
range1 = max1 - min1 ;
min1 = min1 - 0.05 * range1 ;
max1 = max1 + 0.05 * range1 ;

ph = plot(xgrid,mdata,'-') ;
%  title(['Raw Data, n = ' num2str(n) ', d = ' num2str(d)],'FontSize',24) ;
  axis([1,d,min1,max1]) ;
  set(gca,'XTickLabelMode','manual') ;
  set(gca,'YTickLabelMode','manual') ;




  pstr = 'LongDat1fig1A' ;
  orient portrait ;
  set(gcf,'PaperSize',[3.25, 2.75]) ; 
  set(gcf,'PaperPosition',[0.25, 0.25, 2.75, 2.25]) ; 
print('-dpsc', [pstr '.ps']) ;





