disp('Running MATLAB script file LongDat1fig1B.m') ;
%
%    Makes Figure 1B for the Longitudinal Data Analysis paper
%
%    Copied from \Research\ComplexPopn\ToyExamples\EGCurvDat1.m, which:
%
%    makes toy curves as data examples
%
%    uses:
%
%         idat = 3      %  Example from classes\322\s322eg12.m  "Parabs"
%
%         ipart = 1 ;    %  1  -  Standard PCA



%  Generate data
%
datastr = 'Parabolas' ;
d = 10 ;
n = 50 ;
xgrid = (.5:1:d)' ;
mdata = (xgrid - 6).^2 ;
  randn('seed',88769874) ;
  eps1 = 4 * randn(1,n) ;
  eps2 = .5 * randn(1,n) ;
  eps3 = 1 * randn(d,n) ;
mdata = vec2matSM(mdata,n) + vec2matSM(eps1,d) + ...
               vec2matSM(eps2,d) .* vec2matSM(xgrid-d/2,n) + eps3 ;



%  make main graphic
%
figure(1) ;
clf ;


ah1 = subplot(2,2,1) ;
  paramstruct = struct('vipcplot',0,...
                       'vicolplot',2,...
                       'isingleaxis',1,...
                       'iscreenwrite',1) ;
  curvdatSM(mdata,paramstruct) ;
  title('') ;
  set(ah1,'XTickLabelMode','manual') ;
  set(ah1,'XTickLabel',[]) ;
  set(ah1,'YTickLabelMode','manual') ;
  set(ah1,'yTickLabel',[]) ;
  vchil = get(ah1,'Children') ;
  set(vchil(1),'String',[]) ;


ah2 = subplot(2,2,2) ;
  paramstruct = struct('vipcplot',0,...
                       'vicolplot',3,...
                       'isingleaxis',1,...
                       'iscreenwrite',1) ;
  curvdatSM(mdata,paramstruct) ;
  title('') ;
  set(ah2,'XTickLabelMode','manual') ;
  set(ah2,'XTickLabel',[]) ;
  set(ah2,'YTickLabelMode','manual') ;
  set(ah2,'yTickLabel',[]) ;
  vchil = get(ah2,'Children') ;
  set(vchil(1),'String',[]) ;


ah3 = subplot(2,2,3) ;
  paramstruct = struct('vipcplot',1,...
                       'vicolplot',1,...
                       'isingleaxis',1,...
                       'iscreenwrite',1) ;
  curvdatSM(mdata,paramstruct) ;
  title('') ;
  set(ah3,'XTickLabelMode','manual') ;
  set(ah3,'XTickLabel',[]) ;
  set(ah3,'YTickLabelMode','manual') ;
  set(ah3,'yTickLabel',[]) ;


ah4 = subplot(2,2,4) ;
  paramstruct = struct('vipcplot',1,...
                       'vicolplot',3,...
                       'isingleaxis',1,...
                       'iscreenwrite',1) ;
  curvdatSM(mdata,paramstruct) ;
  title('') ;
  set(ah4,'XTickLabelMode','manual') ;
  set(ah4,'XTickLabel',[]) ;
  set(ah4,'YTickLabelMode','manual') ;
  set(ah4,'yTickLabel',[]) ;
  vchil = get(ah4,'Children') ;
  set(vchil(1),'String',[]) ;




  pstr = 'LongDat1fig1B' ;
  orient portrait ;
  set(gcf,'PaperSize',[6.0, 5.0]) ; 
  set(gcf,'PaperPosition',[0.25, 0.25, 5.0, 4.5]) ; 
print('-dpsc', [pstr '.ps']) ;





