disp('Running MATLAB script file LongDat1fig2A.m') ;
%
%    Makes Figure 2A for the Longitudinal Data Analysis paper
%

% Input data
%
fid=fopen('spellman_alpha_complete.txt', 'rt');
genevec=fscanf(fid, '%f');
mdata=reshape(genevec, [18, 4489]);

%  make main graphic
%
figure(1) ;
clf ;

d = size(mdata,1) ;
         %  dimension of each data curve
n = size(mdata,2) ;
         %  number of data curves

xgrid = (1:d)' ;
min1 = min(min(mdata)) ;
max1 = max(max(mdata)) ;
range1 = max1 - min1 ;
min1 = min1 - 0.05 * range1 ;
max1 = max1 + 0.05 * range1 ;

ph = plot(xgrid,mdata,'-') ;
%  title(['Raw Data, n = ' num2str(n) ', d = ' num2str(d)],'FontSize',24) ;
  axis([1,d,min1,max1]) ;
  set(gca,'XTickLabelMode','manual') ;
  set(gca,'YTickLabelMode','manual') ;




  pstr = 'LongDat1fig2A' ;
  orient portrait ;
  set(gcf,'PaperSize',[3.25, 2.75]) ; 
  set(gcf,'PaperPosition',[0.25, 0.25, 2.75, 2.25]) ; 
print('-dpsc', [pstr '.ps']) ;





