disp('Running MATLAB script file LongDat1fig3A.m') ;
%
%    Makes Figure 3A for the Longitudinal Data Analysis paper
%

% Input data
%
fid=fopen('spellman_alpha_complete.txt', 'rt');
genevec=fscanf(fid, '%f');
mdata=reshape(genevec, [18, 4489]);


% compute the projections of data onto the 2-dimension Fourier space
d=18;
j=1:d;
w1=4*pi/d;
w2=8*pi/d;
w3=12*pi/d;
w4=16*pi/d;
% C(X) is the subspace of the fourier bases
X=[cos(w1*j);sin(w1*j);cos(w2*j);sin(w2*j);cos(w3*j);sin(w3*j);cos(w4*j);sin(w4*j)]';
M=X*inv(X'*X)*X'; % M is projection operator onto C(X)
proj_mdata=M*mdata;


%  make main graphic
%
figure(1) ;
clf ;

d = size(proj_mdata,1) ;
         %  dimension of each data curve
n = size(proj_mdata,2) ;
         %  number of data curves

xgrid = (1:d)' ;
min1 = min(min(proj_mdata)) ;
max1 = max(max(proj_mdata)) ;
range1 = max1 - min1 ;
min1 = min1 - 0.05 * range1 ;
max1 = max1 + 0.05 * range1 ;

ph = plot(xgrid,proj_mdata,'-') ;
%  title(['Raw Data, n = ' num2str(n) ', d = ' num2str(d)],'FontSize',24) ;
  axis([1,d,min1,max1]) ;
  set(gca,'XTickLabelMode','manual') ;
  set(gca,'YTickLabelMode','manual') ;




  pstr = 'LongDat1fig3A' ;
  orient portrait ;
  set(gcf,'PaperSize',[3.25, 2.75]) ; 
  set(gcf,'PaperPosition',[0.25, 0.25, 2.75, 2.25]) ; 
print('-dpsc', [pstr '.ps']) ;





