disp('Running MATLAB script file LongDat1fig4.m') ;
%
%    Makes Figure 4 for the Longitudinal Data Analysis paper
%          make the scatterplot of the 2d projections of data: proj_sin vs proj_cos
%

% input the raw data
%
fid=fopen('spellman_alpha_complete.txt', 'rt');
genevec=fscanf(fid, '%f');
mdata=reshape(genevec, [18, 4489]);

% compute the projection coordinates (proj_cos and proj_sin) in the two-dimension Fourier subspace
%
d=18;
j=1:d;
w=4*pi/d;
cosX=[cos(w*j)]';
sinX=[sin(w*j)]';
proj_cos=inv(cosX'*cosX)*cosX'*mdata;
proj_sin=inv(sinX'*sinX)*sinX'*mdata;

% make main graphic
%
figure(1) ;
clf ;

min_x = min(proj_cos) ;
max_x = max(proj_cos) ;
range_x = max_x - min_x ;
min_x = min_x - 0.05 * range_x ;
max_x = max_x + 0.05 * range_x ;

min_y = min(proj_sin) ;
max_y = max(proj_sin) ;
range_y = max_y - min_y ;
min_y = min_y - 0.05 * range_y ;
max_y = max_y + 0.05 * range_y ;

plot(proj_cos(1), proj_sin(1),'+');
hold on;
plot([0 0], [min_y max_y], 'm-'); 
plot([min_x max_x], [0 0], 'm-');
for idat=2:4489
    plot(proj_cos(idat), proj_sin(idat),'+');
end
hold off;
% title('scatterplot of 2-d projections of data');
% xlabel('ProjCos');
% ylabel('ProjSin');
axis([min_x, max_x, min_y, max_y]);
set(gca,'XTickLabelMode','manual') ;
set(gca,'YTickLabelMode','manual') ;


  pstr = 'LongDat1fig4' ;
  orient portrait ;
  set(gcf,'PaperSize',[3.25, 2.75]) ; 
  set(gcf,'PaperPosition',[0.25, 0.25, 2.75, 2.25]) ; 
print('-dpsc', [pstr '.ps']) ;




