disp('Running MATLAB script file LongDat1fig9.m') ;
%
%    Makes Figure 9 for the Longitudinal Data Analysis paper
% 

fid=fopen('spell_alpha_comp_G1.txt', 'rt');
genevec1=fscanf(fid, '%f');
spell_G1=reshape(genevec1, [18, 223]);  % dimention = # of time points

fid=fopen('spell_alpha_comp_S.txt', 'rt');
genevec2=fscanf(fid, '%f');
spell_S=reshape(genevec2, [18, 47]);  % dimention = # of time points


fid=fopen('spell_alpha_comp_G2.txt', 'rt');
genevec3=fscanf(fid, '%f');
spell_G2=reshape(genevec3, [18, 92]);  % dimention = # of time points


fid=fopen('spell_alpha_comp_M.txt', 'rt');
genevec4=fscanf(fid, '%f');
spell_M=reshape(genevec4, [18, 158]);  % dimention = # of time points

fid=fopen('spell_alpha_comp_MG1.txt', 'rt');
genevec5=fscanf(fid, '%f');
spell_MG1=reshape(genevec5, [18, 92]);  % dimention = # of time points

spell_612=[spell_G1 spell_S spell_G2 spell_M spell_MG1];

% assign different colors to different gene phases
icolor=zeros(612,3);
for i=1:223
    icolor(i,:)=[1 0 0]; % G1 phase is red
end
for i=224:270
    icolor(i,:)=[0 1 0]; % S phase is green
end
for i=271:362
   icolor(i,:)=[0 0 1]; % G2 phase is blue
end
for i=363:520
    icolor(i,:)=[1 1 0]; % M phase is yellow
end
for i=521:612
    icolor(i,:)=[0 1 1]; % MG1 phase is cyan
end

%  make main graphic
%
figure(1) ;
clf ;

% Spellman classified 612 periodic genes
ah1 = subplot(3,2,1);
    paramstruct_curv_612=struct('viout', 1, 'vipcplot', 0, 'vicolplot', 1, 'icolor', icolor, 'isingleaxis', 1, 'iscreenwrite', 1);
    CurvDatSM(spell_612,paramstruct_curv_612); 
    axis([1 18 -3 5]);
    title('') ;
    set(ah1,'XTickLabelMode','manual') ;
    set(ah1,'XTickLabel',[]) ;
    set(ah1,'YTickLabelMode','manual') ;
    set(ah1,'yTickLabel',[]) ;
    vchil = get(ah1,'Children') ;
    %set(vchil(1),'String',[]) ;

% G1 group
ah2 = subplot(3,2,2);
    paramstruct_curv_G1=struct('viout', 1, 'vipcplot', [0], 'vicolplot', [1], 'icolor', icolor(1:223,:), 'isingleaxis', 1, 'iscreenwrite', 1);
    CurvDatSM(spell_612(:,1:223),paramstruct_curv_G1); 
    axis([1 18 -3 5]);
    title('') ;
    set(ah2,'XTickLabelMode','manual') ;
    set(ah2,'XTickLabel',[]) ;
    set(ah2,'YTickLabelMode','manual') ;
    set(ah2,'yTickLabel',[]) ;
    vchil = get(ah2,'Children') ;
    %set(vchil(1),'String',[]) ;
    
% S group
ah3 = subplot(3,2,3);
    paramstruct_curv_S=struct('viout', 1, 'vipcplot', [0], 'vicolplot', [1], 'icolor', icolor(224:270,:), 'isingleaxis', 1, 'iscreenwrite', 1);
    CurvDatSM(spell_612(:,224:270),paramstruct_curv_S); 
    axis([1 18 -3 5]);
    title('') ;
    set(ah3,'XTickLabelMode','manual') ;
    set(ah3,'XTickLabel',[]) ;
    set(ah3,'YTickLabelMode','manual') ;
    set(ah3,'yTickLabel',[]) ;
    vchil = get(ah3,'Children') ;
    %set(vchil(1),'String',[]) ;

% G2 group
ah4 = subplot(3,2,4);
    paramstruct_curv_G2=struct('viout', 1, 'vipcplot', [0], 'vicolplot', [1], 'icolor', icolor(271:362,:), 'isingleaxis', 1, 'iscreenwrite', 1);
    CurvDatSM(spell_612(:,271:362),paramstruct_curv_G2); 
    axis([1 18 -3 5]);
    title('') ;
    set(ah4,'XTickLabelMode','manual') ;
    set(ah4,'XTickLabel',[]) ;
    set(ah4,'YTickLabelMode','manual') ;
    set(ah4,'yTickLabel',[]) ;
    vchil = get(ah4,'Children') ;
    %set(vchil(1),'String',[]) ;

% M group
ah5 = subplot(3,2,5);
    paramstruct_curv_M=struct('viout', 1, 'vipcplot', [0], 'vicolplot', [1], 'icolor', icolor(363:520,:), 'isingleaxis', 1, 'iscreenwrite', 1);;
    CurvDatSM(spell_612(:,363:520),paramstruct_curv_M); 
    axis([1 18 -3 5]);
    title('') ;
  set(ah5,'XTickLabelMode','manual') ;
  set(ah5,'XTickLabel',[]) ;
  set(ah5,'YTickLabelMode','manual') ;
  set(ah5,'yTickLabel',[]) ;
  vchil = get(ah5,'Children') ;
  %set(vchil(1),'String',[]) ;

% MG1 group
ah6 = subplot(3,2,6);
    paramstruct_curv_MG1=struct('viout', 1, 'vipcplot', [0], 'vicolplot', [1], 'icolor', icolor(521:612,:), 'isingleaxis', 1, 'iscreenwrite', 1);
    CurvDatSM(spell_612(:,521:612),paramstruct_curv_MG1); 
    axis([1 18 -3 5]);
    title('') ;
  set(ah6,'XTickLabelMode','manual') ;
  set(ah6,'XTickLabel',[]) ;
  set(ah6,'YTickLabelMode','manual') ;
  set(ah6,'yTickLabel',[]) ;
  vchil = get(ah6,'Children') ;
  %set(vchil(1),'String',[]) ;



 pstr = 'LongDat1fig9' ;
 orient portrait ;
 set(gcf,'PaperSize',[6.0, 5.0]) ; 
 set(gcf,'PaperPosition',[0.25, 0.25, 5.0, 4.5]) ; 
print('-dpsc', [pstr '.ps']) ;