disp(['Running MATLAB script gpgui.m']) ;
%
%    This gives generic GUI constructions
%    including menus, text (with colors), push buttons,
%    sliders, editable text, a "dir" button, and a "help" button
%
%    This calls gpguisl.m, which must be present in the same directory

%    Copyright (c) J. S. Marron 1998



%  Start with some "global" variables
%  (these are often important for passing quantities, etc.
%            between GUI processes)
%  Use capital letters for such variables
global FIGWINDHAND COLORBARWINDHAND RADIOBUTTON1 RADIOBUTTON2 ;
%  FIGWINDHAND - Figure Window Handle for main figure window
%  COLORBARWINDHAND - Handle for Color Bar Window
%  RADIOBUTTON1 - Handle for Radio Button 1
%  RADIOBUTTON2 - Handle for Radio Button 2
global SLIDERWINDHAND SLIDERHAND BARCROSS ;
%  SLIDERWINDHAND - Handle for Slider Window
%                 (making these global allows checking for whether
%                    or not they already exist, which avoids
%                    creation of duplicate windows)
%  SLIDERHAND -  Handle for Slider that reads in BARCROSS
%  BARCROSS - Value Passed from Slider to Color Bar window
%                 (very important to make this global)



%  Start with a default value to be changed by slider
%
BARCROSS = 32 ;




%  If there are earlier versions of graphics, then close them
%
if ~isempty(COLORBARWINDHAND) ;    %  if this variable is not empty
  close(COLORBARWINDHAND) ;
          %  close the old window
  COLORBARWINDHAND = [] ;
          %  set to empty to flag no such window
end ;
if ~isempty(SLIDERWINDHAND) ;    %  if this variable is not empty
  close(SLIDERWINDHAND) ;
          %  close the old window
  SLIDERWINDHAND = [] ;
          %  set to empty to flag no such window
end ;





%  Starting with setting up basics for positioning
%
ScreenSize = get(0,'ScreenSize') ;
          %  4-vector of screensize in pixels
          %      [starting left, starting bottom, 
          %             screen width, screen height]
          %  Note:  "0" is the handle for the whole screen

fwleft = ScreenSize(1) + .5 * ScreenSize(3) ;
          %  left side of window half way accross screen

fwbottom = ScreenSize(2) + .3 * ScreenSize(4) ;
          %  bottom of window 30% up screen

  buttonwd = 240 ; 
          %  Width of buttons in pixels
          %  (adjust according to text length, etc.)
  buttonwgap = 20 ;
          %  Horizontal gap between buttons in pixels
          %  (adjust according to visual impression)
fwwidth = buttonwd + 2 * buttonwgap ;
          %  put "gap" on both left and right

  nbuttonrow = 6 ;
          %  number of rows of buttons on this menu
  buttonht = 20 ;
          %  Height of button in pixels
          %  (adjust according to visual impression)
  buttonhgap = 25 ;
          %  Vertical gap between buttons in pixels
          %  (adjust according to visual impression)
fwheight = nbuttonrow * (buttonht + buttonhgap) + buttonhgap ;
          %  create space for the buttons, and one more gap at bottom

FigWindPos = [fwleft,fwbottom,fwwidth,fwheight] ;




%  Next set up a Figure Window
%
FIGWINDHAND = figure(1) ;
          %  makes Figure window 1, the current one, and assigns
          %  a "handle" to it (for "next" figure window use no argument)
clf ;
          %  Clear out anything that may have been in this window
          %  previously
set(FIGWINDHAND,'position',FigWindPos) ;
set(FIGWINDHAND,'NumberTitle', 'off') ; 
          %  This turns off the "Figure 1" part of the "name" below
set(FIGWINDHAND,'name','Test Gui Menu') ;
          %  "name" appears above the menu bar of the figure window


%  Next set up a standard text button 
%
fieldy = (nbuttonrow - 1) * (buttonht + buttonhgap) + buttonhgap ;
          %  bottom of 1st button field
fwtext1hand = uicontrol(FIGWINDHAND,'Style','text',...
            'Position',[buttonwgap fieldy buttonwd buttonht],...
            'String','Here is a standard text field');




%  Next set up a colored text button 
%
fieldy = (nbuttonrow - 2) * (buttonht + buttonhgap) + buttonhgap ;
          %  bottom of 2nd button field
fwtext2hand = uicontrol(FIGWINDHAND,'Style','text',...
            'Position',[buttonwgap fieldy buttonwd buttonht],...
            'String','Here is a Colored text field', ...	   
 	    'BackgroundColor', [0 0 0], ...
 	    'ForegroundColor', [0 1 1]) ;
          %  Setting background to black eliminates "edge material"
          %  so text has no "small window"
          %  colors are magnitudes of "red, green, blue"



%  Next do Pushbutton 1,
%  which creates additional small window with a colorbar
%
fieldy = (nbuttonrow - 3) * (buttonht + buttonhgap) + buttonhgap ;
          %  bottom of 3rd button field in Figure Window
  cbwleft = ScreenSize(1) + .05 * ScreenSize(3) ;
  cbwbottom = ScreenSize(2) + .1 * ScreenSize(4) ;
  cbwwidth = .3 * ScreenSize(3) ;
  cbwheight = .8 * ScreenSize(4) ;
CBWindPos = [cbwleft cbwbottom cbwwidth cbwheight] ;
fwb1cbs = ['if isempty(COLORBARWINDHAND) ;' ...
           '  COLORBARWINDHAND = figure ;' ...
           'else ;' ...
           '  figure(COLORBARWINDHAND) ;' ...
           'end ;' ...
           'set(COLORBARWINDHAND,''position'',CBWindPos) ;' ...
           'clf ;' ...
           'colorbar(gca) ;' ...
           'hold on ;' ...
           '  plot([-1 1],[BARCROSS BARCROSS],''k-'') ;' ...
           'hold off ;'] ;
          %  Figure Window Button 1 CallBack String
          %  Important point: often simplest to call a subroutine here
          %      (very big plus is then get line numbers for debugging)
fwbutton1hand = uicontrol(FIGWINDHAND,'Style','push',...
              'Position',[buttonwgap fieldy buttonwd buttonht],...
              'String','Create a Color Bar',...
              'CallBack',fwb1cbs) ;



%  Next do radio buttons, for controlling colormap
%
fieldy = (nbuttonrow - 4) * (buttonht + buttonhgap) + buttonhgap ;
          %  bottom of 4th button field in Figure Window
%  First set text part
RadioButtonText = uicontrol(FIGWINDHAND,...
          'Style','text',...
          'String','Colors:',...
          'Position',[buttonwgap,fieldy,buttonwd/3,buttonht]) ;
%  First radio button
RADIOBUTTON1 = uicontrol(FIGWINDHAND,...
          'Style','radio',...
          'String','Full',...
          'Value',1,...
          'Position',[buttonwd/3 + 2*buttonwgap,fieldy,buttonwd/3,buttonht],...
          'Callback',[...
               'set(RADIOBUTTON1,''Value'',1),'...
               'set(RADIOBUTTON2,''Value'',0),'...
               'figure(COLORBARWINDHAND) ;'...
               'colormap(''default'') ;']) ;
               %  Note this first resets the other button, then sets
               %  the color map
          %  Value indicates which button is currently "pushed"
%  Second Radio Button
RADIOBUTTON2 = uicontrol(FIGWINDHAND,...
          'Style','radio',...
          'String','Gray',...
          'Position',[2*buttonwd/3 + 3*buttonwgap,fieldy,buttonwd/3,buttonht],...
          'Callback',[...
               'set(RADIOBUTTON2,''Value'',1),'...
               'set(RADIOBUTTON1,''Value'',0),'...
               'figure(COLORBARWINDHAND) ;'...
               'colormap(gray) ;']) ;
               %  Note this first resets the other button, then sets
               %  the color map
          %  Value indicates which button is currently "pushed"



%  Next do Pushbutton 2
%  which creates a slider for manipulating line crossing color bar
%
fieldy = (nbuttonrow - 5) * (buttonht + buttonhgap) + buttonhgap ;
          %  bottom of 5th button field in Figure Window
  swleft = ScreenSize(1) + .4 * ScreenSize(3) ;
  swbottom = ScreenSize(2) + .05 * ScreenSize(4) ;
  swwidth = .5 * ScreenSize(3) ;
  swheight = .15 * ScreenSize(4) ;
SWindPos = [swleft swbottom swwidth swheight] ;
fwb2cbs = ['if isempty(SLIDERWINDHAND) ;' ...
           '  SLIDERWINDHAND = figure ;' ...
           'else ;' ...
           '  figure(SLIDERWINDHAND) ;' ...
           'end ;' ...
           'set(SLIDERWINDHAND,''position'',SWindPos) ;' ...
           'clf ;' ...
           'WindowPos = get(gcf,''Position'') ;' ...
           'SliderHt = 20 ;' ...
           'SliderPos = [.45 * WindowPos(3) .5*WindowPos(4)-SliderHt/2] ;' ...
           'SliderPos = [SliderPos .5*WindowPos(3) SliderHt] ;' ...
           'slcbs = ''gpguisl'' ;' ...
           'SLIDERHAND = uicontrol(SLIDERWINDHAND,''Style'',''slider'', '...
           '    ''Position'',SliderPos, ' ...
           '    ''Min'',1,''Max'',64,''Value'',BARCROSS,' ...
           '    ''CallBack'',slcbs) ;' ...
           'TextHt = 20 ;' ...
           'TextPos = [.05 * WindowPos(3) .5*WindowPos(4)-TextHt/2] ;' ...
           'TextPos = [TextPos .35*WindowPos(3) TextHt] ;' ...
           'slcbs = ''gpguisl'' ;' ...
           'Texthand = uicontrol(SLIDERWINDHAND,''Style'',''text'', '...
           '    ''Position'',TextPos, ' ...
           '    ''String'',''Cross Bar Height'') ;'] ;
          %  Figure Window Button 2 CallBack String
          %  Important point: often simplest to call a subroutine here
          %      (big plus is then get line numbers for debugging,
          %       drawback is need to pass more things as globals)
fwbutton2hand = uicontrol(FIGWINDHAND,'Style','push',...
              'Position',[buttonwgap fieldy buttonwd buttonht],...
              'String','Create a Slider',...
              'CallBack',fwb2cbs) ;





%  Next do Pushbuttons 3 and 4
%  for directory and help
%
fieldy = (nbuttonrow - 6) * (buttonht + buttonhgap) + buttonhgap ;
          %  bottom of 6th button field in Figure Window
fwb3cbs = ['disp('' '') ;' ...
           'disp(''    Contents of current directory are:'') ;' ...
           'dir ;' ...
           'disp('' '') ;' ...
           'disp('' '') ;'] ;
          %  Figure Window Button 3 CallBack String
fwbutton3hand = uicontrol(FIGWINDHAND,'Style','push',...
              'Position',[buttonwgap fieldy .3*buttonwd buttonht],...
              'String','Dir.',...
              'CallBack',fwb3cbs) ;
fwb4pos = [buttonwgap + .7 * buttonwd fieldy .3*buttonwd buttonht] ;
          %  Figure Window Button 4 Position Vector
fwb4cbs = ['disp('' '') ;' ...
           'disp(''      Here is the place'') ;' ...
           'disp(''            to put'') ;' ...
           'disp(''    some helpful comments'') ;' ...
           'disp('' '') ;'] ;
          %  Figure Window Button 4 CallBack String
fwbutton4hand = uicontrol(FIGWINDHAND,'Style','push',...
              'Position',fwb4pos,...
              'String','Help',...
              'CallBack',fwb4cbs) ;



%  Add a Pull down (for the figure header) menu alternate to some things
%
pulldownmenu = uimenu(FIGWINDHAND,'Label','Test') ;
      %  attach main menu
  colbarmenu = uimenu(pulldownmenu,'Label','Add a Color Bar', ...
                      'CallBack',fwb1cbs, ...
                      'Separator','On') ;
      %  submenu for creating a color bar
  colormenu = uimenu(pulldownmenu,'Label','Choose Colors', ...
                      'Separator','On') ;
      %  submenu for changing color scheme
    fullmenu = uimenu(colormenu,'Label','Full', ...
                          'CallBack',['figure(COLORBARWINDHAND) ;'...
                                      'colormap(''default'') ;']) ;
      %  subsubmenu for changing to full color
    graymenu = uimenu(colormenu,'Label','Gray', ...
                          'CallBack',['figure(COLORBARWINDHAND) ;'...
                                      'colormap(gray) ;']) ;
      %  subsubmenu for changing to full color
  slidermenu  = uimenu(pulldownmenu,'Label','Create a Slider', ...
                      'CallBack',fwb2cbs) ;


disp(' ') ;
disp('Graphics Constructed, Start pushing buttons...') ;
disp(' ') ;
disp(' ') ;



