function gpguisl
% GPGUISL, Toy function for calling by gpgui.m

%    Copyright (c) J. S. Marron 1998

global COLORBARWINDHAND SLIDERWINDHAND SLIDERHAND BARCROSS ;
%  COLORBARWINDHAND - Handle for Color Bar Window
%  SLIDERWINDHAND - Handle for Slider Window
%  SLIDERHAND -  Handle for Slider that reads in BARCROSS
%  BARCROSS - Value Passed from Slider to Color Bar window




BARCROSS = get(SLIDERHAND,'Value') ;
          %  first update value of BARCROSS



if isempty(COLORBARWINDHAND) ;
          %  then haven't created color bar yet, so send warning

  disp(' ') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
  disp('!!!    Warning: need to create color bar    !!!') ;
  disp('!!!               before using slider       !!!') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
  disp(' ') ;

else ;

  figure(COLORBARWINDHAND) ;
          %  Change current figure to color bar, to update cross bar

  vaxchil = get(gca,'Children') ;

  for ic = 1:length(vaxchil) ;    %  loop through children of this axis 

    ctype = get(vaxchil(ic),'Type') ; 
          %  look at type of Children

    if strcmp(ctype,'line') ;
          %  only child that is a "line" is our cross bar, so change that
      set(vaxchil(ic),'YData',[BARCROSS BARCROSS])  ;
    end ;

  end ;

  figure(SLIDERWINDHAND) ;
          %  return to slider as current figure
end ;


