disp(['Running MATLAB script gptable.m']) ;
%
%    This gives a generic tabular output to a file,
%    intended to be copied and modified when that is needed


%  Generate easily recognizable matrix of values
mout = vec2matSM(2.^(0:3),3) ;
mout = mout .* vec2matSM(3.^((0:2)'),4) 


%  WRITE ANSWERS INTO A FILE
fid = fopen('/Research/MatlabSoftware/gptable.out','wt') ;
          %  'wt' is for "delete contents of this file and open 
          %               for writing" (with 't' for "text").
          %  Use 'ay' to append to what is already there, 'rt' for reading.

  titlstr1 = 'Output from the MATLAB Script gptable.m,   ' ;
  titlstr1 = [titlstr1,date] ;
cntbytes = fprintf(fid,'%1s\n',titlstr1) ;
          %  '%1s/n' says "print string, followed by a line feed"
          %       (Note, this only goes to next line)

  titlstr2 = '     A generic write of a matrix to a file. ' ;
cntbytes = fprintf(fid,'%1s\n\n\n',titlstr2) ;
          %  3 line feeds gives two blank lines

  titlstr3 = '                  col 2      col 3  col 4' ;
cntbytes = fprintf(fid,'%1s\n',titlstr3) ;

  forstr = '   col1=%6.3f   %6.3f        %3.0f (%6.3f)\n' ;
          %  Embedded text appears as written (including parens)
cntbytes = fprintf(fid,forstr,mout') ;
          %  Careful here, because this reads down columns first,
          %  So feed it the transpose of the usual form

  outstr1 = 'get tabs using \t' ;
  outstr2 = 'and another string' ;
cntbytes = fprintf(fid,'\n\n%1s\t   %6.3f\t   %1s\t   .',outstr1,27,outstr2) ;


  str = 'Here is how to add a page feed (the \f):' ;
cntbytes = fprintf(fid,'\n\n%1s\f',str) ;



fclose('all') ;
%  !!!! Careful !!!!  Need to do this to be able work with files after
%  running matlab.  Alternative is:
%  fclose(fid) ;


end ; 

