% A few line template to make movies


%  Set parameters
%
moviefps = 5 ;
moviecstr = 'Cinepak' ;
nrepeat = 2 ;
nframe = 11 ;


%  Initiate figure and movie
%
fighand = figure(1) ;
clf ;
clear moviestruct ;



%  Do main movie loop
%
for iframe = 1:nframe ;

  vx = 0:iframe ;
  vy = 0:iframe ;
  
  plot(vx,vy) ;
    axis([0,nframe,0,nframe]) ;


  moviestruct(iframe) = getframe(fighand) ;

end ;    %  of iframe loop, to make movie



%  Reorder frames, and replay
%
vmorder = [(1:nframe),((nframe-1):-1:2)] ;
moviestruct = moviestruct(vmorder) ;
        %  reorder frames, to loop back to beginning

movie(fighand,moviestruct,nrepeat,moviefps) ;
        %  Play movie on screen



%  Save results
%
savestr = 'TempMovie' ;
movie2avi(moviestruct,savestr,'compression',moviecstr, ...
                      'keyframe',moviefps,'fps',moviefps) ;



%  For a spinning point cloud plot,
%  the following are very useful
%
%  set(fighand,'Color',[1 1 1]) ;
%  axis equal ;
%  axis vis3d ;
%  axis off ;
%  vangle = linspace(0,360 * (1 - 1/nframe),nframe) ;
%  view(vangle(iframe),30) ;



