disp(['Running MATLAB script gpread.m']) ;
%
%    This gives a generic read of an ASCII file, with strings,
%    intended to be copied and modified when that is needed
%    Assumes file gpread.dat is in \matlab\stevefun\tests

itest = 1 ;     %  test of format types: 1,


fid = fopen('/matlab/stevefun/tests/gpread.dat','rt') ;
          %  'rt' is for "read only" and "text"

if itest == 1 ;
  fstr = '%s %f %f' ;
          %  this seems to say "find a string, then an f, then an f"
elseif itest == 2 ;
  fstr = '%5s %f %f' ;
end ;

[inmat,cnt] = fscanf(fid,fstr) 
          %  can add a "size" parameter when don't want to read all.
          %  cnt tells how many reads were done (2 * 3 fields = 6)

fclose('all') ;
%  !!!! Careful !!!!  Need to do this to be able work with files after
%  running matlab.  Alternative is:
%  fclose(fid) ;

disp('here is how the input is stored, after the read') ;
inmat

disp('Often want to reshape, e.g.') ;
inmat = reshape(inmat,7,2)' 
          %  use this for 2x7 matrix, since reshape works column wise
          %  7 came from 5 parts to string, plus 2 others

%  now change string part back into strings
minstr = [] ;
for i = 1:2 ;
  instr = setstr(inmat(i,1:5)) ;
  minstr = str2mat(minstr,instr) ;
          %  concatenates string row vectors, into "column vector
          %  of strings", actually a matrix of ASCII values
end ;

disp('Here is the string matrix') ;
minstr
