function k = kerepac(xg,h) 
% KEREPAN, evaluates canonical version of the EPAN. KERnel
%     at a grid of x's, xg (matrix or vector),
%     for the bandwidth h
%     For use in NonParametric Regression MOVies

%    Copyright (c) J. S. Marron and D. Ruppert, 1997

del0 = (15)^(1/5) ;
          %  Canonical rescaling from Marron and Nolan (1989)
          %      Stat. and Prob. Letters, 7, 195-199.

k = kerepan(xg / del0, h) / del0 ;





