function k = kergauc(xg,h) 
% KERGAUC, evaluates canonical version of the GAUSsian KERnel
%     at a grid of x's, xg (matrix or vector),
%     for the bandwidth h
%     For use in NonParametric Regression MOVies

%    Copyright (c) J. S. Marron and D. Ruppert, 1997

del0 = (1 / (4 * pi))^(1/10) ;
          %  Canonical rescaling from Marron and Nolan (1989)
          %      Stat. and Prob. Letters, 7, 195-199.

k = kergaus(xg / del0, h) / del0 ;





